<?php
/**
 *
 * @todo 압축에는 여러가지 방식이 있다. zlib 를 바탕으로 gzip, 과 deflate 등 몇가지가 사용이 가능하다. zlib 를 통해서 할 수 있는 압축 방식을 모두 지원하도록 한다.
 * @return int 0 on success, otherwise error code.
 */
/**
 * ZLIB 라이브러리가 설치되어 있지 않으면 리턴.
 */
if (!function_exists('gzclose')) return 1;
/**
 * 설정 파일 읽음
 */
$file = module_repository.'/output_compress.conf';
$cfg_output_compress = @readAs($file);
$cfg = &$cfg_output_compress;
if ( $cfg === FALSE || empty($cfg) ) return 0;

$GLOBALS['cfg_output_compress'] = $cfg;


// 설정에 따라, 차단, 무조건 압축, 조건 압축 등을 한다.


/**
 * 압축 안함 옵션
 */
if ( isset($cfg['send']) && $cfg['send'] == '0' )
{
	return 0;
}

/**
 * 압축 전송을 지원하지 않는 클라이언트 차단 옵션.
 * 여기서 종료를 하면 스크립트 전체가 종료된다.
 */
if ( isset($cfg['block']) )
{
	if ( ! substr_count($_SERVER['HTTP_ACCEPT_ENCODING'], 'gzip') ) exit;
}

/**
 * 웹 클라이언트 요청시 압축
 */
if ( isset($cfg['send']) && $cfg['send'] == '1' )
{
	if ( ! substr_count($_SERVER['HTTP_ACCEPT_ENCODING'], 'gzip') ) return 0;
}






// ============================================================================
// 압축 전송 HANDLER
// ============================================================================
/**
 * 출력 내용을 받아서 압축 후 리턴.
 *
 * 이 함수는 스크립트의 마지막에 자동으로 호출된다.
 * 현제는 gzip 압축만 한다.
 * 모든 출력 작업을 버퍼링해서 이 함수 하나로 처리를 하므로, 여러가지 기능 처리에 관한 책임이 막중하다.
 *
 * @param string $buffer 웹 브라우저로 전송될 HTML 내용
 * @since 2007/03/08 다운로드하는 데이터가 text 라면, 이 데이터에 대해서도 압축을 한다.
 * @note 이미지, 동영상 파일은 그 자체가 압축되어 있는 상태이므로 압축 전송을 해도 효과가 없다.
 */
function output_compress_handler($buffer)
{

	/**
	 * 헤더가 있는 경우(주로 파일 다운로드), Content-Type 이 text 이면, 압축을 한다.
	 *
	 * @since 2007/03/8 파일 다운로드할 경우에도 압축을 하도록한다.
	 * 출력된 헤더를 체크한다.
	 */
	$headers = headers();
	foreach( $headers as $k=>$v )
	{
		//
		// 파일의 데이터 타입이, text 이면 압축, 아니면 그대로 리턴을한다.
		if ( strtolower($k) == 'content-type' )
		{
			if ( strstr($v, 'text') )
				break;
			else
				return $buffer;
		}
	}
	
	chdir(dirname($_SERVER['SCRIPT_FILENAME']));
	$cfg = &$GLOBALS['cfg_output_compress'];
	
	$length = ob_get_length();


	// 통계 옵션
	if ( isset($cfg['stat']) )
	{
		$file = module_repository.'/output_compress.totallength.cnt';
		$re = sumfile($file, $length);
		if ( $re )
		{
			$file = module_repository.'/output_compress.cnt';
			increasefile($file);
		}
		else
		{
			return "$re 압축 통계 기록 실패: ".getcwd()." = $file, $length";
		}
	}

	header('Content-Encoding: gzip');
	header('Vary: Accept-Encoding');
	$gzdata = gzencode($buffer, 6);
	$gzdatalength = strlen($gzdata);
	header("Content-Length: ".$gzdatalength);
	{
		$file = module_repository.'/output_compress.gzlength.cnt';
		$re = sumfile($file, $gzdatalength);
	}	
	return $gzdata;
}


/**
 * 아래의 코드가 실행되어야 압축 전송이 동작한다.
 * 아래의 코드가 실행되기 전에 리턴을 했다면, 압축 전송은 실행되지 않는다.
 */
ob_start('output_compress_handler');

return 0;
?>
