<?php
/**
 * 압축 전송
 *
 * rss 리더기 제작을 하려는데, 문제가 발생한다.
 * 압축 전송을 올바로 해석하지 못하고 있다. 따라서 기존의 별도의 rss 출력기를 제작했다. etc/rss.php
 *
 * @todo 압축에는 여러가지 방식이 있다. zlib 를 바탕으로 gzip, 과 deflate 등 몇가지가 사용이 가능하다. zlib 를 통해서 할 수 있는 압축 방식을 모두 지원하도록 한다.
 * @return int 0 on success, otherwise error code.
 */
/**
 * ZLIB 라이브러리가 설치되어 있지 않으면 리턴.
 */
if (!function_exists('gzclose')) return 1;
/**
 * 설정 파일 읽음
 */
$file = module_repository.'/output_compress.conf';
$cfg_output_compress = @readAs($file);
$cfg = &$cfg_output_compress;
if ( $cfg === FALSE || empty($cfg) ) return 0;

$GLOBALS['cfg_output_compress'] = $cfg;


// 설정에 따라, 차단, 무조건 압축, 조건 압축 등을 한다.


/**
 * 압축 안함 옵션
 */
if ( isset($cfg['send']) && $cfg['send'] == '0' )
{
	return 0;
}

/**
 * 압축 전송을 지원하지 않는 클라이언트 차단 옵션
 */
if ( isset($cfg['block']) )
{
	if (
		substr_count($_SERVER['HTTP_ACCEPT_ENCODING'], 'gzip')
			||
		substr_count($_SERVER['HTTP_ACCEPT_ENCODING'], 'deflate') 
	) { }
	else
	{
		echo "blocked by output_compress handlder. cause: you do not accept encoding";
		exit;
	}
}

/**
 * 웹 클라이언트 요청시 압축
 */
if ( isset($cfg['send']) && $cfg['send'] == '1' )
{
	if ( ! substr_count($_SERVER['HTTP_ACCEPT_ENCODING'], 'gzip') ) return 0;
}






// ============================================================================
// HANDLER
// ============================================================================
/**
 * 출력 내용을 압축
 *
 * 이 함수는 스크립트의 마지막에 자동으로 호출된다. 현제는 gzip 압축만 한다.
 * 모든 출력 작업을 버퍼링해서 이 함수 하나로 처리를 하므로, 여러가지 기능 처리에 관한 책임이 막중하다.
 *
 * @param string $buffer 웹 브라우저로 전송될 HTML 내용
 *
 */
function output_compress_handler($buffer)
{

	/**
	 * 출력된 헤더를 체크한다. 만약, 압축/다운로드 관련 해더가 출력이 되었으면, 그냥 내용을 출력해버리고 작업을 마무리한다.
	 */
	$headers = headers();
	foreach( $headers as $k=>$v )
	{
		// 파일 다운로드의 경우, 그냥 리턴한다.
		$chk = "Content-Disposition";
		if ( $k == $chk ) return $buffer;
	}
	
	chdir(dirname($_SERVER['SCRIPT_FILENAME']));
	$cfg = &$GLOBALS['cfg_output_compress'];
	
	$length = ob_get_length();


	// 통계 옵션
	if ( isset($cfg['stat']) )
	{
		$file = module_repository.'/output_compress.totallength.cnt';
		$re = sumfile($file, $length);
		if ( $re )
		{
			$file = module_repository.'/output_compress.cnt';
			increasefile($file);
		}
		else
		{
			return "$re 압축 통계 기록 실패: ".getcwd()." = $file, $length";
		}
	}
/*

*/
	header('Content-Encoding: gzip');
	$gzdata = gzencode($buffer, 6);
	
	
	//header('Content-Encoding: deflate');
	//$gzdata = gzcompress($buffer);

	header('Vary: Accept-Encoding');
	$gzdatalength = strlen($gzdata);
	header("Content-Length: ".$gzdatalength);
	{
		$file = module_repository.'/output_compress.gzlength.cnt';
		$re = sumfile($file, $gzdatalength);
	}	
	return $gzdata;
}


/**
 * @todo 핸들러를 설치하기 전에, 통계 등의 값을 체크한다. ?? 무슨 뜻인지 이해가 안감.
 */
ob_start('output_compress_handler');

return 0;
?>
