<?php
/**
 * 메모장 설치
 *
 * 본 스크립트는 관리자 스크립트 {@link admin.php} 에서 실행이된다.
 * {@link info.php} 에 의해서 관리자 모드에 '메모장' 메뉴가 나타나며 이 메뉴를 클릭하면 admin.php 가 실행되고 memo.admin.html 에서 이 스크립트로 링크를 거는 것이다.
 *
 * 메모장 모듈의 시작은 memo/begin.php 부터이다. begin.php 에 많은 것들이 준비되어있다. 먼저 begin.php 파일을 열어서 살펴보기 바란다.
 * @note 모듈 관리자 및 설치 테스트 작업은 새창에서 하는 것이 도움이 된다.
 *
 *
 * 메모장 설치 방법:
 * - 모듈(메모장)의 기본 정보 읽는다. (메모장 모듈의 아이디. 즉, 카테고리 아이디, 카테고리 이름 등을 정하고 info.php 에 기록을 한다. )
 * - 이 정보를 바탕으로 설치가 가능한지 체크를 한다.
 * - 설치가 불 가능하면 메세지를 출력하고 종료한다.
 * @package memo
 */

/**
 * 설치에 필요한 라이브러리와 정보 인클루드
 */
lib('module');
include( script('info') );

// module_id 는 begin.php 에 기록되어 있다.
$version = getModuleVersion(module_id);



if ( $version >= $info['version'] )
	goBack( doneBefore, "The installed module - $info[name] version $info[version] by $info[author] - is newer than the one you are installing now. So, you cannot install this version of the module.");


// 모듈 정보 설정. 모듈은 카테고리이다. 모듈 정보를 설정하는 것은 카테고리 설정을 하는 것이다. 이 과정을 통해서 메모장의 카테고리 정보 영역을 준비한 것이다.
$rc = setModule(module_id, $info['name'], CATE_MEMO, $info['version'], GRADE_PRIVATE, $info['description']);
// 에러 체크 후 절절한 페이지로 이동
if ( $rc != ok ) goBack();
else go('?cate=memo&mode=admin', "$info[name] version $info[version] has successfully installed.");


return array('00000');
?>
