<?php

$file = module_repository . "/log.cfg.php";
$cfg  = config($file);
if ( empty($cfg) )
{
	$cfg = array();
	$cfg['level'] = '1';
	config($file, $cfg);
}

if ( isset($ui['extra']) && $ui['extra'] == 'submit' )
{
	$cfg['level'] = $ui['level'];
	config($file, $cfg);
}


lib('module');
$version = getModuleVersion(module_id);


?>

<html>
<head>
	<meta http-equiv=Content-Type content='text/html;charset=utf-8'>
	<link rel="stylesheet" type="text/css" href="etc/res/css/basic.css">
	<style>
		body, td, div {font-size:10pt;}
	</style>
</head>
<body>

<div id="title">로그 모듈 관리자 화면</div>
<div id="comment">
	로그 모듈을 설치하면, 시스템(홈페이지)의 활동 내역이 기록됩니다.<br>
	이 기록을 바탕으로 각 종 통계를 내는데에 활용할 수 있습니다.
</div>
<div id="comment">
	본 모듈의 설치하면 매 페이지마다 로그를 DB 에 기록합니다.<br>
	즉, 매 페이지마다 DB 액세스가 일어납니다. 캐쉬 시스템을 사용하여 DB 액세스를 제로로 하고자 할 경우,
	본 모듈의 사용은 걸림돌이 될 수 있습니다.
</div>
<p>
<div id="note"><a href="?cate=log&mode=install">설치</a> 로그 모듈을 설치합니다.</div>
<div id="note"><a href="?cate=log&mode=uninstall">제거</a> 설치된 로그 모듈을 제거합니다.</div>
</p>
<div id="comment">
	로그 모듈을 제거하시면, 로그 데이터가 모두 사라집니다.<br>
	따라서 로그 데이터를 초기화 하고자 않다면, 제거 후 다시 설치를 하셔도 좋습니다.<br>
</div>

<p>
	현제 모듈 <?=$cate?>
<?if($version){?>
	 의 버젼 <?=$version?> 이 <b>설치되어 있습니다.</b>
<?}else{?>
	는 설치되지 않았습니다.
<?}?>
<div id="comment">
	설치/제거를 위해서는 상단의 링크를 클릭하시면됩니다.
</div>
</p>

<form action="?" style="display:inline;">
<input type="hidden" name="cate" value="log">
<input type="hidden" name="mode" value="admin">
<input type="hidden" name="extra" value="submit">


로그 레벨 
<select name="level">
<option value="<?=$cfg['level']?>"><?=$cfg['level']?></option>
<option value="0">0</option>
<option value="1">1</option>
<option value="2">2</option>
<option value="3">3</option>
</select>
단계로 <input type="submit" class="button_gray" value=" 설정 ">
</form>
<div id="comment">
	레벨이 높을 수록 로그 정보가 자세하게 기록이 되며, 로그 파일의 용량도 많아집니다.<br>
	로그 레벨이 0 이면 로그 정보를 기록하지 않습니다.<br>
	로그 모듈을 설치 해 놓고, 그리고 기존 로그 정보를 유지한 채, 로그 데이터를 더 이상 기록하지 않으려면
	로그 레벨을 0 으로 하면됩니다.
</div>
</body>
</html>
<?return noskin()?>
