<?php
/**
 * 메모장 시작 스크립트.
 *
 * begin.php 는 각 모듈(해당 정보 영역)의 기능별 스크립트에 우선하여 자동으로 실행되는 스크립트이다.
 * 이 스크립트에서 각종 상수, 변수를 정의하고 필요한 사용자 인증, 에러 체크 등의 작업을 한다.
 *
 * 작업:
 * - 메모장은 개인 정보 영역이다. 회원 인증을 한다.
 * - HTTP 변수로 idx 가 입력될 경우 게시물을 읽어서 기본 변수에 설정한다.	
 *
 * 기본 변수:
 *	- $uidx 현제 블로그 주인의 아이디 번호
 *	- $blogger 현제 블로그 주인의 사용자 정보가 담긴다. $user 변수는 사용자 자신의 정보를 담는다.
 *	- $category 현제 블로그의 옵션 정보. 만약, 이 값이 empty 이면 현제 사용자의 블로그 옵션 정보가 설정되지 않은 상태이다.
 *	- $configured 0 이면, 설정 안됨. 1이면 설정됨.
 *	- $myblog is set to 1, if the blog belongs to him.
 */

// 모듈(카테고리) 아이디를 상수로 정의
define('module_id',			"$cate.module", 	true);
define('category_id',				 module_id,		true);

lib('user');
lib('module');


/** 블로그가 설치되지 않아도 되는 경우 */
if ( in_array($ui['mode'], array('admin','install') ) ) return;
/** 그 외에는 설치가 되어야 진행이된다. */

$blog_category = getCategory(module_id);
if ( empty($blog_category) ) goBack(notAvailable, "blog has not installed, yet.");


/**
 * When you post your blog (or you do somethig else to your blog ), the blogger's idx (user idx of the blogger) is the same as your idx.
 * So, you dont have to specify uidx as hidden in the HTML FORM tag.
 */
if ( login() && in_array($mode, array("write", "write_submit", "modify", "modify_submit", "config", "config_submit", "delete", "delete_submit", "deletefile_submit", "trackback") ) )
{
	$blogger = $user;
}
else if ( isset($ui['id']) ) { $blogger = user($ui['id']); }
else if ( isset($ui['uidx']) ) $blogger = user($ui['uidx']);


if ( empty($blogger) ) go("?", "There is no blog entry by that name or you have tried to access wrong page. you will be moved to main page.", wrongID);
$uidx	= $blogger['idx'];


//$category = getCategory("blog.".$blogger['id']);
$category = userCategory(CATE_BLOG, $blogger['idx']);
if ( empty($category) ) $configured = 0; else $configured = 1;
if ( $user['id'] == $blogger['id'] ) $myblog = 1; else $myblog = 0;





/**
 * if the blog has configured, set options.
 *
 * - image link
 */
if ( $configured )
{
	changeSkin($category['skin']);
	lib('filesystem');
	$files = files($category['idx'], CATE_BLOG);
	if ( count($files) == 1 )
	{
		$idx_file = $files[0]['idx'];
		$url_image = "?cate=download&idx=$idx_file";
	}
}



$url_list			= "?cate=blog&mode=index&uidx=$uidx";
$url_blog			= $url_list;

$url_config		= "?cate=blog&mode=config&uidx=$uidx";


//
$url_write = "?cate=blog&mode=write&uidx=$uidx";
$url_modify = "?cate=blog&mode=modify&idx=$ui[idx]&uidx=$uidx";


$url_delete_submit = "?cate=blog&mode=delete_submit&idx=$ui[idx]";

?>
