<?php
/**
 * 글 관리 ( 이동, 복사 등 )
 *
 * begin.php 와 상관 없이 직접 여기서 인증을 한다.
 *
 */

/**
 * 원본 글의 정보
 */
$post			= post($ui['idx']);
/**
 * 복사할 장소
 */
$category	= category($ui['to']);

/**
 * 다음의 경우에 이동이 가능하다.
 *
 * - 관리자이거나 자신의 글이고
 * - 이동할 카테고리에 쓰기 권한이 있을 경우,
 */
if ( admin('bbs') || ( myPost($post) && grade($category['w']) ) ) { }
else goBack(accessDenied, "you don't have permission to move/copy a post.");




/**
 * 이동의 경우, 카테고리만 변경하면된다.
 */
if ( $ui['action'] == 'move' )
{
	updatePostfield($post['idx'], 'idx_category', $category['idx']);
}
else if ( $ui['action'] == 'copy' )
{
	/**
	 * 글만 복사를 한다. 파일은 복사를 하지 않는다. 따라서 원글의 파일이 현재 글에 붙지 않는다.
	 * @todo 파일까지 복사를 할 수는없다. 정 필요하면 link 개념을 도입해야한다.
	 */
	unset($post['idx']);
	$post['idx_category']				= $category['idx'];
	$post['idx_category_type']	= $category['type'];
	$post['files'] = 0;
	$rc = insertPost($post);
	if ( faultCode( $rc ) ) goBack(failed, "bbs::man_submit 글을 복사하지 못하였습니다.");
}


return output(0, "?cate=bbs&mode=list&idx=$ui[to]");
?>
