<?php
/**
 * 장난을 위한 파일 업로드 클래스
 *
 * @copyright		2006 by ky 본 라이브러리(본 스크립트 또는 소스 파일)는 그대로 복사,수정하여서 사용할 수 있습니다. 수정된 내용은 알려주셔야합니다.
 * @license			http://www.opensource.org/licenses/gpl-license.php GPL
 * @version			new revision: 1.6 /cvsroot/siteapi/jangnan/lib/upload.php,v
 * @example			module/massposting/submit.php
 * @example			module/upload/submit.php
 * @author			ky (thruthesky) <thruthesky@yahoo.co.kr>
 * @see					README 참조
 * @link				http://thruthesky.webzero.co.kr/etc/jangnan/
 * @link				http://thruthesky.webzero.co.kr/etc/jangnan/docs/hometools/
 * @package			library
 * @filesource
 * @since				2006/12/13
 * @todo				CGI 작업 설정이 잘 못되었는지, 용량이 큰 파일이 업로드되면, HTML FORM 자체가 수행(submit)이 안되어서 지정된 스크립트를 수행할 수 없다. 이와 관련해서 용량이 큰 파일을 업로드할 경우 체크가 필요하다.
 */
/**#@+
 * 상수 정의
 *
 * PHP 4.2.0 에는 error code 만 정의되어있고 관련된 constants 는 PHP 4.3.0 부터 시작된다.
 * @see PHP Manual Chapter 38. Handling file uploads
 */
if (!defined('UPLOAD_ERR_OK')) define('UPLOAD_ERR_OK', 0);
if (!defined('UPLOAD_ERR_INI_SIZE')) define('UPLOAD_ERR_INI_SIZE', 1);
if (!defined('UPLOAD_ERR_FORM_SIZE')) define('UPLOAD_ERR_FORM_SIZE', 2);
if (!defined('UPLOAD_ERR_PARTIAL')) define('UPLOAD_ERR_PARTIAL', 3);
if (!defined('UPLOAD_ERR_NO_FILE')) define('UPLOAD_ERR_NO_FILE', 4);
/**#@-*/


/**
 * 파일 업로드 클래스
 *
 * HTML FORM 으로 부터 입력받는 file type 의 변수는 임의적으로 지정이된다.
 * 이 클래스는 HTML FORM 변수에 대한 파일 업로드를 한다.
 *
 * @since 2006/12/14 $this->cnt 변수는 사용하지 않는다. 이것은 코딩을 어렵게하는 원인이 된다.
 *
 * <code>
 * lib('upload');
 * $up = new Upload();
 * $ar = $up->names();
 * $no=0;
 * foreach ($ar as $var)
 * {
 * 	$no++;
 * 	$up->set($var);
 * 	
 * 	$to = "c:\\tmp\\$var$no.gif";
 * 	
 * 	if ( ! $up->isarray() )
 * 	{
 * 		if ( $up->move($to) )
 * 			alert("파일 업로드 실패: $to");
 * 	}
 * 	else
 * 	{
 * 		// 동일한 변수명에 다중 파일 업로드
 * 		for( $i=0; $i < $up->size(); $i++ )
 * 		{
 * 			$to = "c:\\tmp\\$var$no$i.gif";
 * 			if ( $rc = $up->move($to) )
 * 			{
 * 				$from = $up->tmpname();
 * 				alert("멀티 파일 업로드 실패: ($rc) $from -> $to");
 * 			}
 * 		}
 * 	}
 * }
 * //g($up->names());
 * //$up->printx();
 * </code>
 */
class Upload {
	
	var $varname;
	
	/**
	 * 생성자
	 *
	 * @param string $varname HTML FORM 으로 부터 입력되는 변수
	 */
	function Upload($varname='file')
	{
		$this->set($varname);
	}
	/**
	 * HTML FORM 변수를 지정한다.
	 *
	 * 이 클래스는 특정 변수 하나에 대한 파일 업로드 작업을 한다. 이 함수에 그 변수의 이름을 입력해야한다.
	 * @param string HTML FORM 변수 이름
	 */
	function set($varname)
	{

		$this->varname = $varname;
	}
	
	
	/**
	 * HTML FORM 으로 부터 넘어온 file type 의 변수를 배열로 리턴한다.
	 *
	 * @return array HTML FORM 의 file type 변수(들)를 배열로 리턴한다.
	 */
	function names()
	{
		$names = array();
		foreach ( $_FILES as $k => $v )
		{
			$names[] = $k;
		}
		return $names;
	}
	/**
	 * 지정된 변수가 HTTP 파일 업로드 배열 변수인지 체크한다.
	 *
	 * @return boolean 그렇다면 true, 아니면 false
	 */
	function isarray()
	{
		$var = $this->varname;
		return is_array($_FILES[$var]['name']);
	}
	/**
	 * 지정된 변수가 array 일 때, file type array 의 배열 크기를 리턴한다.
	 *
	 * @note 함수 size 는 HTML FORM 변수에 대한 것이지 업로드된 파일을 크기를 가르키는 속성이 아니다.
	 */
	function size()
	{
		$var = $this->varname;
		return count($_FILES[$var]['name']);
	}

	/**
	 *
	 * @param int $cnt 지정된 파일 변수가 배열일 경우, 요소를 입력한다.
	 * @return associative-array 파일의 정보 키/값의 쌍을 가지는 연관배열로 리턴
	 */
	function info($cnt = NULL)
	{
		if ( $this->isArray() )
		{
			$ar['tmp_name'] = $_FILES[$this->varname]['tmp_name'][$cnt];
			$ar['name'] = $_FILES[$this->varname]['name'][$cnt];
			$ar['type'] = $_FILES[$this->varname]['type'][$cnt];
			$ar['size'] = $_FILES[$this->varname]['size'][$cnt];
			$ar['error'] = $_FILES[$this->varname]['error'][$cnt];
			return $ar;
		}
		else
			return $_FILES[$this->varname];
	}
	

	/**
	 * 업로드된 파일 저장
	 *
	 * 다중 파일 업로드의 경우, HTML FORM 변수가 배열일 때, 배열 요소를 입력 받지 않는다. 내부적으로 자동으로 처리한다.
	 * @param string $to 업로드된 파일을 저장할 파일 경로
	 * @return int 성공시 UPLOAD_ERR_OK(값 0, false), 아니면 에러값이 리턴된다.
	 */
	function move($to, $cnt = NULL)
	{
		$var = $this->varname;
		
			
		if ( $this->isArray() )
		{
			if ( is_null($cnt) ) return -1;
			if ($_FILES[$var]['error'][$cnt] != UPLOAD_ERR_OK) return $_FILES[$var]['error'][$cnt];
			$from = $this->tmpname($cnt);
		}
		else
		{
			if ($_FILES[$var]['error'] != UPLOAD_ERR_OK) return false;
			$from = $_FILES[$var]['tmp_name'];
		}
		
		if (move_uploaded_file($from, $to))
			return UPLOAD_ERR_OK;
		else
		{
			return -1;
		}
	}
	/**
	 * 임시 파일 이름을 리턴
	 *
	 * 배열일 경우, $cnt 가 null 이면, ...
	 * @param int $cnt 동일한 변수명으로 다중 파일 업로드일 경우, 인덱스 값
	 * @return string 업로드된 임시 파일 이름을 리턴. 만약 없로드 파일이 없을 경우 empty 가 리턴된다.
	 * @note 
	 * <code>
	 * lib('upload');
	 * $up = new Upload();
	 * for( $i = 0; $i < $up->size(); $i ++ )
	 * {
	 * 	g($up->tmpname($i));
	 * }
	 * </code>
	 *
	 * <code>
	 * lib('upload');
	 * lib('file');
	 * $up = new Upload();
	 * for( $i = 0; $i < $up->size(); $i ++ )
	 * {
	 * 	$file = $up->tmpname($i);
	 * 	if ( !empty($file) )
	 * 	{
	 * 		$content = readfileEx($file);
	 * 		echo $content;
	 * 	}
	 * }
	 * </code>
	 */
	function tmpname($cnt = NULL)
	{
		if ( $this->isArray() )
		{
			if ( is_null($cnt) ) return NULL;
			return $_FILES[$this->varname]['tmp_name'][$cnt];
		}
		else
			return $_FILES[$this->varname]['tmp_name'];
	}
	

	function printx()
	{
		g($_FILES);
	}
}
?>
