<?php
/**
 * MySQL dump 파일을 분석한다.
 *
 * phpMyAdmin 으로 덤프한 파일은 테스트 되었다.
 * @author 더 카이, thruthesky@yahoo.co.kr
 * @copyright 더 카이, thruthesky@yahoo.co.kr
 *
 * MySQL dump 파일 by phpMyAdmin 규칙:
 * - 라인이 -- 로 시작하면 주석
 * - 라인이 ; 로 끝나면 SQL 문장의 끝
 * 
 * @package library
 */
/**
 *
 * @param string $sql phpMyAdmin 으로 부터 SQL 파일을 덤프 받은 내용이다.
 * @return array 각 요소는 하나의 SQL 문장을 가지는 쿼리 스트링을 리턴한다.
 */
function parse_sql_dump($sql)
{
	$rows = array();
	if ( empty($sql) ) $rows;
	
	$q = NULL;
	$lines = explode("\n", $sql);
	foreach( $lines as $line )
	{
		$line = trim($line);
		if (empty($line)) continue;
		if ( substr($line, 0, 2) == '--' ) continue;
		
		if ( $line[strlen($line)-1] == ';' )
		{
			$q .= trim($line,';');
			$rows[] = $q;
			$q = NULL;;
		}
		else
		{
			$q .= $line;
		}
	}
	return $rows;
}

?>
