<?php
/**
 * 로그 관련 라이브러리
 *
 * @since 2007/04/01 시스템의 모든 로그 관련 코드를 제거하고 새로 작업을 한다.
 * @note 이 라이브러리는 module_log 테이블에 작업을 한다. 따라서 module_log 테이블에 작성하는 정보는
 * 본 라이브러리와 맞추어져야한다.
 */
/**
 * IP 를 바탕으로 중복되는 레코드를 제거한, 고유 IP 의 갯수를 얻는다.
 *
 *
 *
 * @param associative-array $kvs same as searchPost
 * @param associative-array $limit same as searchPost
 * <code>
 *	$limit['fromData'] = mktime(0,0,0,date("m"), date("d")-1, date("Y"));
 *	$limit['toData'] = mktime(0,0,0,date("m"), date("d"), date("Y"));
 *	$hit_yesterday = countUnique(array(), $limit);
 * </code>
 */
function countUniqueLog($search = array(), $limit = array())
{
	$date				= qDateTime($limit, 't');				// 변수 위치 주의

	$limit			= qLimit($limit);
	$fields			= qFields($search);

	$cond = array();
	
	if ( !empty($date) )		$cond[] = $date;
	if ( !empty($fields) )	$cond[] = $fields;

	$where = NULL;
	if ( !empty($cond) )
	{
		$where = "WHERE " . implode(" AND ", $cond);
	}
	
	global $db;
	$q = "SELECT count(DISTINCT h) FROM module_log $where";
	$rows = $db->result($q);
	return $rows;
}
?>
