<?php
/**
 * 위치별 플러그인 설정 스크립트
 *
 * 본 스크립트는 articles 플러그인의 설정 스크립트(또는 복사된)이다.
 * 본 스크립트는 설정의 작업 처리를 위한 표준적인 방법을 제시한다. 따라서 설정 스크립트를 작성할 때에는
 * 본 스크릡트를 참조하는 것이 도움이 될 것이다.
 *
 * 특정 위치에 최근글(들)의 제목을 리스트하기 위한 옵션 설정을 한다.
 *
 *
 *
 */

/**
 * 필요한 라이브러리 로드
 */
lib('plugin');

/**
 * 플러그인 정보
 */
$pd = dirRoot."/plugin/$ui[dir]";
include $pd."/info.php";
$file = module_repository . "/plugin.cfg.$ui[areaname].php"; //설정 파일
$cfg = config($file);





/**
 * 초기값 체크
 */
if ( !isset($cfg['category'])  ) $cfg['category'] = NULL;
if ( !isset($cfg['header'])  ) $cfg['header'] = NULL;
if ( !isset($cfg['number']) ) $cfg['number'] = 10;
//if ( !isset($cfg['length_title']) ) $cfg['length_title'] = 30;



$total_category_checked =
$total_article_checked = $week_article_checked = $yesterday_article_checked = $today_article_checked =
$total_user_checked = $week_user_checked = $yesterday_user_checked = $today_user_checked =
$total_reply_checked = $week_reply_checked = $yesterday_reply_checked = $today_reply_checked = NULL;


if ( isset($cfg['total_category']) && $cfg['total_category'] == 'checked' ) $total_category_checked = "checked";
if ( isset($cfg['total_article']) && $cfg['total_article'] == 'checked' ) $total_article_checked = "checked";
if ( isset($cfg['week_article']) && $cfg['week_article'] == 'checked' ) $week_article_checked = "checked";
if ( isset($cfg['yesterday_article']) && $cfg['yesterday_article'] == 'checked' ) $yesterday_article_checked = "checked";
if ( isset($cfg['today_article']) && $cfg['today_article'] == 'checked' ) $today_article_checked = "checked";

if ( isset($cfg['total_user']) && $cfg['total_user'] == 'checked' ) $total_user_checked = "checked";
if ( isset($cfg['week_user']) && $cfg['week_user'] == 'checked' ) $week_user_checked = "checked";
if ( isset($cfg['yesterday_user']) && $cfg['yesterday_user'] == 'checked' ) $yesterday_user_checked = "checked";
if ( isset($cfg['today_user']) && $cfg['today_user'] == 'checked' ) $today_user_checked = "checked";

if ( isset($cfg['total_reply']) && $cfg['total_reply'] == 'checked' ) $total_reply_checked = "checked";
if ( isset($cfg['week_reply']) && $cfg['week_reply'] == 'checked' ) $week_reply_checked = "checked";
if ( isset($cfg['yesterday_reply']) && $cfg['yesterday_reply'] == 'checked' ) $yesterday_reply_checked = "checked";
if ( isset($cfg['today_reply']) && $cfg['today_reply'] == 'checked' ) $today_reply_checked = "checked";



$hide_checked = NULL;
if ( isset($cfg['hide']) && $cfg['hide'] == 'checked' ) $hide_checked = "checked";

if ( !isset($cfg['cache']) ) $cfg['cache'] = "0";



/**
 * 캐쉬 정보를 저장할 경우, 캐쉬 옵션이 0 이면, 기존의 캐쉬 파일을 여기서 지운다.
 */
if ( empty($cfg['cache']) )
{
	$cache_file = tmp_repository . "/cache/plugin.$ui[areaname].php";
	@unlink($cache_file);
}












?>
<? include "etc/res/php/plugin_config_header.php" ?>

<form action="?" method="post" style="display:inline;">
<input type="hidden" name="cate" value="plugin">
<input type="hidden" name="mode" value="plugin">
<input type="hidden" name="action" value="config_submit">
<input type="hidden" name="dir" value="<?=$ui['dir']?>">
<input type="hidden" name="areaname" value="<?=$ui['areaname']?>">

<table>
	<tr>
		<td width="50"><div id="name">제목</div></td><td><input class="in" name="header" size=30 value="<?=$cfg['header']?>"></td>
	</tr>
	<tr>
		<td><div id="name">표시</div></td><td>
<input type="checkbox" name="total_category" value="checked" <?=$total_category_checked?>>총 글 영역 카테고리<br>
<input type="checkbox" name="total_user" value="checked" <?=$total_user_checked?>>총 사용자 수
<input type="checkbox" name="week_user" value="checked" <?=$week_user_checked?>>일주일
<!--<input type="checkbox" name="yesterday_user" value="checked" <?=$yesterday_user_checked?>>어제//-->
<input type="checkbox" name="today_user" value="checked" <?=$today_user_checked?>>오늘<br>
<input type="checkbox" name="total_article" value="checked" <?=$total_article_checked?>>총 글 수
<input type="checkbox" name="week_article" value="checked" <?=$week_article_checked?>>일주일
<input type="checkbox" name="yesterday_article" value="checked" <?=$yesterday_article_checked?>>어제
<input type="checkbox" name="today_article" value="checked" <?=$today_article_checked?>>오늘<br>
<input type="checkbox" name="total_reply" value="checked" <?=$total_reply_checked?>>총 답변글 수
<input type="checkbox" name="week_reply" value="checked" <?=$week_reply_checked?>>일주일
<input type="checkbox" name="yesterday_reply" value="checked" <?=$yesterday_reply_checked?>>어제
<input type="checkbox" name="today_reply" value="checked" <?=$today_reply_checked?>>오늘
		</td>
	</tr>
	<tr>
		<td><div id="name">숨기기</div></td><td><input class="in" type="checkbox" name="hide" value="checked" <?=$hide_checked?>> 화면에 나타내지 않기</td>
	</tr>
	<tr>
		<td><div id="name">스킨</div></td>
		<td>
			<select name='skin'>
			<?
				$dirs = getdirs($pd."/skin");
				foreach( $dirs as $dir )
				{
					echo "<option value='$dir'";
					if ( isset($cfg['skin']) && $cfg['skin'] == $dir ) echo " selected";
					echo ">$dir</option>";
				}
			?>
			</select>
		</td>
	</tr>
	<tr valign="top">
		<td><div id="name">캐쉬</div></td>
		<td>
			<select name="cache">
				<?=@plugin_cache_options($cfg['cache'])?>
			</select>
			분 <div id="comment">설정(변경) 작업시에는 캐쉬안함으로 체크를 해야합니다.</div>
		</td>
	</tr>
	<tr>
		<td></td><td><input class="button_blue" type="submit" value=" 적 용 [저장] "></td>
	</tr>
</table>


</form>

<script>
	window.resizeTo(500,650);
</script>

<br>
<div id="key">미리보기</div><div id="value">위의 저장(변경)된 내용이 아래 바로 적용이됩니다.</div>
<br>
<?
	plugin($ui['areaname']);
?>
