<?php
/**
 * 검색 처리를 하고 결과를 리스트하기 위한 준비를 한다.
 *
 * 스크립트 명칭을 보기 좋게 하느라 list.php 이지 실제로는 submit.php 정도가 되어야한다.
 * @todo 검색을 할 때에 자신의 권한 이하인 것만 검색을 하도록 해야한다.
 */
/**
 *
 */



/**
 * @doc 글 (검색 결과나 목록) 리스트를 할 때에, 목록의 갯수와 페이징의 결정이 어렵다.
 * 다음과 같은 과정을 따른다,
 *
 * 1. 한 페이지에 목록할 글의 수를 결정한다. 아래에서는 $articles 에 10 으로 결정을 했다.
 * 2. 현제 페이지 번호를 구한다.
 * 3. 현제 페이지 번호와 한 페이지당 글 목록 수를 바탕으로 SQL LIMIT 구문을 만든다.
 *		searchPost 함수를 사용하면, $limit 배열을 아래와 같이 만든다.
 * 4. LIMIT 구문에 따라 검색 결과를 보여 주고, 페이징에 대해서는 pager.php 를 참고한다.
 * 5. $opt_search 변수를 보면 알 수 있듯이, 검색 구문을 만들때, 미리 검색 옵션을 변수로 만들어두고 나중에 페이징을 할 때 사용을 한다.
 *	아래와 같이 UTF-8 환경에서는 문자에 대해서 urlencode 시켜야한다.
 * 	$opt_search .= "&kv=$ui[kv]&cond=$ui[cond]&keyword=".urlencode($ui['keyword']);
 */
if ( !isset($ui['articles']) || empty($ui['articles']) ) $ui['articles'] = numberOfRecords;
if ( !isset($ui['pageNo']) || empty($ui['pageNo']) ) $ui['pageNo'] = 1;
$limit['fromNumber']	= ($ui['pageNo'] - 1) * $ui['articles'];
$limit['toNumber']		= $ui['articles'];


$opt_search = NULL;
$opt_search = "&articles=$ui[articles]";


//g($ui);
//g($limit);




if ( !isset($ui['keyword']) || empty($ui['keyword']) ) goBack("No keyword.");


//@todo 문자셋 처리
/*
g($ui['keyword']);
$newstring = @iconv("EUC-KR", "UTF-8", $ui['keyword']);
g($newstring);
if ( !empty($newstring) && ( $ui['keyword'] != $newstring ) ) $ui['keyword'] = $newstring;
g($ui['keyword']);
*/

lib('post');


/**
 * 카테고리
 */
$categories = array();
if ( isset($ui['all']) && $ui['all'] == "checked" )
{
	$opt_search .= "&all=checked";
}
else
{
	if ( isset($ui['category_type']) && !empty($ui['category_type']) )
	{
		foreach($ui['category_type'] as $ct)
		{
			$opt_search .= "&category_type[]=$ct";
		}
	}
	if ( isset($ui['categories']) )
	{
		$categories = $ui['categories'];
		foreach($categories as $c)
		{
			$opt_search .= "&categories[]=$c";
		}
	}
}


// 검색 제한. 기간.
// 입력된 값 1이 1년이다.
if ( isset($ui['fromDate']) )
{
	$lastweek = mktime(0, 0, 0, date("m"), date("d"), date("Y")-$ui['fromDate']);
	$fromDate = dateTime($lastweek);
	$limit['fromDate'] = $fromDate;
	$opt_search .= "&fromDate=$ui[fromDate]";
}

// 검색 항목과 검색 연산
$kvs = array();
if ( isset($ui['kv']) )
{
	if ( $ui['kv'] == 'title_description' )
	{
		$kvs['title']							= $ui['keyword'];
		$kvs['title cond']				= $ui['cond'];
		$kvs['description']				= $ui['keyword'];
		$kvs['description cond']	= $ui['cond'];
	}
	else
	{
		$key = $ui['kv'];
		$kvs[$key]					= $ui['keyword'];
		$kvs["$key cond"]		= $ui['cond'];
	}
	$opt_search .= "&kv=$ui[kv]&cond=$ui[cond]&keyword=".urlencode($ui['keyword']);
}

// 정렬은 아무렇게나
$orderby = array();

$number = countPost($categories, $kvs, $limit);
$posts = searchPost($categories, $kvs, $limit, array('dateTime'=>'DESC'));

/*
g("총글수: $number");
foreach($ar as $as)
{
	g($as['idx_category'] . "/" . $as['name'] . " / " . $as['title']);
}
*/
lib('list');
?>
