<?php
/**
 * 주문 정보 출력
 *
 * 
 * 주문한 내용이 있으면, 아이템의 주문 정보를 장바구니 파일에 기록하고,
 * 지금까지 장바구니에 담은 정보를 화면에 보여줄 수 있도록 준비를 한다.
 */

login() or go(urlLoginPage($lang["loginfirst"]."\r\n\r\nmall::order In order to see your shopping bag, you must login first!"));



lib('filesystem');



/**
 * 장바구니의 내용을 읽는다.
 */
$as = readAs($mallfile);
if ( $as === FALSE ) $as = array();

/**
 * 주문한 내용이 있으면, 장바구니 내용에 추가해서, 장바구니 파일에 보관한다.
 */
if ( isset($ui['idx']) )
{
	$item = item($ui['idx']);
	if ( isset($ui['number']) ) $number = $ui['number'];
	else $number = 1;
	
	
	// 정보를 기록하는 방법. 이 표현이 DB 에 그대로 기록된다.
	if ( !isset($ui['size']) ) $ui['size'] = NULL;
	$as[$item['idx']] = "$number,$ui[size],$item[price]";
	writeAs($mallfile,$as);
}



/**
 * 출력을 위한 처리를 한다.
 *
 * $items 에는 array of associative-array 로 각 상품에 대한 정보가 기록된다.
 */
$items = array();
foreach($as as $k => $v)
{
	$post		= post($k);
	$item		= convToItem($post);
	$image	= fileChecked($item['idx']);
	if ( empty($image) )
	{
		$image['url']		= 'skin/default/noimage.gif';
	}

	$item['image']	= $image;
	$item['url']		= "?cate=mall&mode=read&idx=$item[idx]";
	@list($item['number'],$item['size']) = explode(",",$v);
	$items [] = $item;
}


?>
