<?php
/**
 * 설치 스크립트
 *
 * 스킨 파일은 작성하지 않는다. (쓸데없이 스킨 파일 많이 만들어 어려움을 증가 시킬 필요 없다.)
 * @package install
 */
/**
 * 조용히 설치를 하도록한다.
 */
quiet();

/**에러체크*/
if ( empty($ui['db_user']) ) goBack("데이터베이스 사용자 아이디를 입력하십시오.");
if ( empty($ui['db_password']) ) goBack("데이터베이스 사용자 비밀번호를 입력하십시오.");
if ( empty($ui['db_database']) ) goBack("데이터베이스 이름(파일)을 입력하십시오.");
if ( empty($ui['db_host']) ) $ui['db_host'] = 'localhost';
if ( empty($ui['admin_id']) ) goBack("홈페이지 관리자 아이디를 입력하십시오.");
if ( empty($ui['admin_password']) ) goBack("홈페이지 관리자 비밀번호를 입력하십시오.");







/**@note 설치로그*/
installlogToMainServer();






lib('file');
umask(0);
/**
 * @note 디렉토리가 존재하면, 퍼미션 체크를 해야한다.
 * @note 이 구문은 여기 있을것이 아니다. 지워버린다. 수정을 통해서만 저장소를 바꿀 수 있도록 한다.
 * @since 2007/01/21 file 디렉토리는 기본적으로 존재한다. 따라서 아래의 구문은 생략이되었다.
 */
/*
if ( ! is_dir($system['repository']) )
{
	if ( ! mkdirEx ($system['repository']) )
		goBack("파일 데이터 저장소 - $system[repository] - (디렉토리) 생성에 실패하였습니다. 퍼미션 관련 정보를 체크하십시오.");
}
*/






// ============================================================================
//
//                  [ 데이터베이스 접속 ]
//
// ============================================================================

$system['db_user']						= &$ui['db_user'];
$system['db_password']				= &$ui['db_password'];
$system['db_database']				= &$ui['db_database'];
$system['db_host']						= &$ui['db_host'];
$system['charset']						= &$ui['charset'];

lib('db');





// ============================================================================
//
//                  [ 데이터베이스 기존 정보 삭제 ]
//
// ============================================================================

if ( isset($ui['reinstall']) && !empty($ui['reinstall']) )
{
	$db->query("DROP TABLE IF EXISTS category");
	$db->query("DROP TABLE IF EXISTS file");
	$db->query("DROP TABLE IF EXISTS post");
	$db->query("DROP TABLE IF EXISTS user");
}


// ============================================================================
//
//                  [ 데이터베이스 체크 ]
//
// ============================================================================

$db_installed = 0;
if ( $db->checkField('category', 'dateTime') && $db->checkField('post','dateTime') && $db->checkField('user', 'dateTime') )
	$db_installed = 1;

/**
 * 데이터베이스가 설치되지 않았으면 설치를 한다.
 *
 */
if ( ! $db_installed )
{
	
	// 현제 버젼의 SQL 문장 실행
	$file_sql = dirRoot."/etc/install/sql/$software[version].sql";
	$sql = readfileEx($file_sql);
	lib('sql_parser');
	$ar = parse_sql_dump( $sql );
	foreach($ar as $q)
	{
		/**
		 * 옛날 데이터베이스는 문자셋을 사용하지 않는다.
		 * @see lib/db.php
		 */
		if ( isset($database_version) && $database_version == 'old' )
		{
			$q = str_replace("DEFAULT CHARSET=utf8", "", $q);
			$q = substr($q, 0, strrpos($q, ")")+1);
		}
		$db->query($q);
	}
	// 기본 데이터 입력
	$file_sql = dirRoot."/etc/install/sql/default_data.sql";
	$sql = readfileEx($file_sql);
	lib('sql_parser');
	$ar = parse_sql_dump( $sql );
	
	foreach($ar as $q)
	{
		$db->query($q);
	}
}
else
{
	alert("데이터베이스가 이미 설치된 것으로 판단이 되어, 데이터베이스 설치 과정은 생략합니다.");
}





////////////////////////////////////////////////////////////////////////////////
lib('user');

// 설정 파일에 관리자 비밀번호를 기록할 필요 없다. md5 해버린다.
$ui['admin_password'] = md5($ui['admin_password']);

$data['id']						= $ui['admin_id'];
$data['password']			= $ui['admin_password'];
$data['name']					= 'webmaster';

/**
 * @since 2007/01/12 setting super user grade
 * @todo 관리자 아이디가 존재해서 그런건지 체크를 해야한다.
 */
$data['grade']				= 30000;

/**
 * @since 2007/02/21 관리자 아이디가 존재할 경우, 삭제하고 다시 입력을 하도록 한다.
 */
if ( $user = user($data['id']) ) deleteUser($user['idx']);
if ( faultCode(insertUser($data)) ) goBack('Failed to add administrator id. please try another. 관리자 아이디를 추가하지 못했습니다. 이미 존재하는 아이디일 수도 있습니다. 다른 아이디로 지정을 해 보십시오.');



// 로그기록
$b = installlog('system', $software['version'], 'install');
if ( $b === FALSE ) alert("install::submit 인스톨 로그 파일 작성 실패");


// 데이터베이스 설치가 된 후에 설정 파일을 기록한다.
$rc = writeAsInPHPCode($pathSystem, $ui);

if ( $rc === FALSE ) goBack("install::submit 설정 파일을 기록하지 못했습니다.");




//
go("?cate=install&mode=check");





/**
 * 시스템의 설치 내역을 메인 서버로 전송
 *
 * 단순히 통계를 목적으로한다.
 * @note 아직 api 와 관련하여 에러가 발생한다는 보고를 받은 적이 없다.
 *	하지만 충분히 에러의 가능성이 있으며, 소켓 통신이라는 모양새가 좋지 못하다.
 *	좀 더 유연한 방법을 찾도록 한다.
 */
function installlogToMainServer()
{
	include_once("etc/utility/xmlrpc/api_library.php");
	
	global $software, $ui;
	
	$data['endpoint'] = $software['homepage']."/siteapi/";
	$data['id']				= "ky";
	$data['pw']				= "1234";
	$data['title']		= urlHomepage."에서 설치";
	if ( isset($_ENV['OS']) ) $os = $_ENV['OS'];
	else $os = 'unknown';
	$data['description']	= "sent by <a href='".urlHomepage."' target=_blank>".urlHomepage."</a>/module/install/submit.php".
													" version $software[version] $software[patch]".
													"<br>PHP version: " . phpversion().
													/*"MySQL version: ".database_version().*/
													"<br>SERVER_SOFTWARE: ".$_SERVER['SERVER_SOFTWARE'].
													"<br>OS: ".$os
													;
													
													
	$data['category']	= 'apilog';
	if ( isset($ui['publish']) && $ui['publish'] == "1" ) $data['publish']	= "1";
	else $data['publish'] = "0";
	
	$fc = xmlrpc_newPost($data);
	
	/**
	 * @todo XML-RPC 에 에러가 발생한 경우, GET 메소드를 통해서 직접 글을 작성할 수 있도록 시도한다.
	 */	
	if ( $fc )
	{
		$fs = $re->faultString();
		echo "XML-RPC failed. faultCode=>$fc faultString=>$fs";
	}
}

?>
