<?php
/**
 * 해당 정보 영역의 관련 스크립트에 우선하여 실행되는 스크립트
 *
 * 이 스크립트는 글 관련 모듈의 준비 작업을 한다.
 * 처리:
 * - post.idx 를 얻는다. idx 없이 id 만 넘어왔으면, 해당 idx 를 얻는다.
 * - post.idx 를 바탕으로 category 정보를 얻어서 $category 변수에 보관한다.
 *
 * @note 게시판의 설정 정보는 $category 변수에 담는다. 카테고리가 게시판 설정 정보이다. 즉 category 이름이 게시판 이름이다.
 * @defvar int $mypost if the user has login and the post belongs to the user.
 *
 * @todo begin.php 스크립트가 너무 복잡해진다.
 *	충분히 복잡해졌다. begin.php 에 많은 데이터를 넣지 않도록 수정을 해야한다.
 *	우선 인증에 대한 부분은 각 스크립트에서 하도록 천천히 변경을 한다.
 * @note 기본 변수
 *	- 자신의 글이면,$mypost 가 1
 *	- 관리자이면 $admin = 1
 *
 */




lib("post");

$category_id = $category_idx = $category_name = NULL;



/**
 * create, create_submit 등 입력값이 카테고리 아이디나 글번호가 아닌경우는 그냥 리턴한다.
 * 기본 값이나, 권한 체크를 각 스크립트에서 직접해야한다.
 */
if ( in_array($ui['mode'], array('create', 'create_submit')) ) return;


/**
 * GET 메소드로 입력되는 정보 중에 idx 값이 생략되었고, id 값이 들어올 경우, 이것은 카테고리 아이디이다.
 * @doc 이 아이디를 바탕으로 게시판 번호를 $ui['idx'] 에 넣어준다.
 * 
 * 
 * @since 07/02/22 id 값이 들어오는 경우, 카테고리 액세스를 위해서 DB 쿼리를 먼저한다. 따라서 2중으로 하지 않도록 한다.
 */
if ( empty($ui['idx']) && !empty($ui['id']) )
{
	lib('category');
	$category = category($ui['id']);
	if ( ! $category ) go("?", "The index of category you just has submitted is wrong. you will be moved to main page", wrongIndex);
	$ui['idx'] = $category['idx'];
}

/**
 * 에러 체크
 * 어떤 경우든지, idx = 0 인 경우는 없다.
 */
//if ( $ui['idx'] == '0' ) { go ("?","bbs::begin idx must be bigger than 0."); exit; }




// 기본 변수 설정
//
// 기본 변수 설정된 것을 잘 봐두어야한다. 페이지에서 이중으로 변수 처리하지 않도록 한다.
//
// 게시물 내용을 얻기 위해서 각 스크립트에서 getPost 함수를 호출할 필요 없다. $post 변수를 사용하면된다.
// 뿐만 아니라, 항목 자체를 변수로 사용이 가능하다. $post[name] 과 $name 은 같은 값이다.


/**
 * HTTP 변수 페이지 번호를 설정한다.
 */
if ( !empty($ui['pageNo']) ) $hvPageNo = "&pageNo=$ui[pageNo]";
else $hvPageNo = '';


// 자신의 글인지 표시
$mypost = 0;




//
// ==================================== 기본 변수 지정
//
// 입력된 $ui[idx] 가 글 번호를 가질 경우의 $mode 에 대한 권한 및 기본 값 처리.
// 이 경우에는 $post 변수에 글에 대한 정보를 보관해 둔다. 그리고 글 항목에 대해서 변수를 작성한다.
//
// $category 변수에는 카테고리 정보가 보관된다.
//
$modes[] = 'read';
$modes[] = 'addfile';
$modes[] = 'addfile_submit';
$modes[] = 'delete';
$modes[] = 'delete_submit';
$modes[] = 'modify';
$modes[] = 'modify_submit';
$modes[] = 'reply_submit';

/** 웹브라우저로 부터 전달된 HTTP 변수 idx 가 post.idx 일 경우 */
if ( isset($ui['idx']) && in_array($mode, $modes) )
{
	// 글이 회원 데이터의 것일 경우, 회원 정보를 사용하게한다.
	$post = getPost($ui['idx']);
	//@since 2006/12/28 글 번호가 잘못 입력된 경우, 메인화면으로 이동
	if ( empty($post) ) go('?', "글 번호가 잘못되었습니다. 메인 화면으로 이동합니다.", wrongIndex);
	
	/**
	 * @since 2007/02/17 현제 글이 하위 글이면 상위글을 보여준다.
	 * @doc 이 때, $org 변수에는 기존 글이 보관되어 있다.
	 * @todo 관리자 설정에서 옵션으로 처리할 것.
	 */
	if ( $post['idx_parent'] )
	{
		$org	= $post;
		$post = post($post['idx_parent']);
	}

	/**
	 * 게시물 정보에 대한 전처리
	 * @see 개발자노트::제목이 없는 경우의 처리
	 */
	if ( isset($post) && empty($post['title']) )	// 제목이 없는 경우,
	{
		lib('string');
		$tag = tagContent("title", $post['description']);
		if ( $tag ) $post['title'] = $tag;
		else $post['title'] = '제목이 없습니다.';
	}
	/** @todo 쌍따옴표 앞에 백슬래쉬를 처리해야한다. */
	$post['title'] = stripslashes($post['title']);
//	$post['description'] = stripslashes($post['description']);


	/** if the post has posted by registered user, */
	if ( $post['idx_user'] )
	{
		lib('user');
		$u = getUser($post['idx_user']);
		//$post['name']		= $u['name']; //@since 2007/01/12 별명으로 변경.
		$post['email']	= $u['email'];
		//$post['sex']		= $u['sex']; //@since 2007/01/12 성별이 없으면 주민번호로 대체 처리됨.
	}
	/** 데이터베이스 레코드 항목을 그대로 변수로 만든다. */
	foreach( $post as $k=>$v )
	{
		/**
		 * @since 2007/01/28 레코드 항목의 값을 변수로 만들 때, 참조를 하도록 변경했다.
		 *	따라서 이 후, $post 변수에 대한 수정은 레코드 이름의 변수에도 그대로 적용이된다.
		 *	이것은 $idx=3; 와 같이 작업을 할 경우, $post[idx]=3 의 결과를 낳는다. 따라서 주의가 필요하다.
		 */
		$$k = &$post[$k];
		//
		// 라디오 변수 checked 처리
		if ( $k == 'r' || $k == 'w' )
		{
			$vv = $k."_".$v;
			$$vv = "checked";
		}
	}
	if ( empty($category) )
	{
		lib('category');
		$category = category($post['idx_category']);
	}
}
/**
 * 입력된 $ui['idx'] 가 파일 번호인 경우,
 *
 */
else if ( $mode == 'deletefile' || $mode == 'deletefile_submit' )
{
	
	lib('filesystem');

	$file = getFile($ui['idx']);

	$post = getPost($file['idx_post']);
	
	lib('category');
	$category = getCategory($post['idx_category']);
}

/**
 * 그 외의 모듈은 모두 category.idx 입력이다.
 *
 * 이 경우에는 $category 에 카테고리 정보만 입력을 한다.
 */
else if ( isset($ui['idx']) )
{
	
	if ( empty($category) )
	{
		lib('category');
		$category = category($ui['idx']);
	}
}


// 기본 변수 세팅

if ( isset($category) )
{
	$category_id		= $category['id'];
	$category_name	= $category['name'];
	$category_idx		= $category['idx'];
}


//
if ( isset($post) )
{
	$url_read				= "?cate=bbs&mode=read&idx=$post[idx]$hvPageNo";
	$url_modify			= "?cate=bbs&mode=modify&idx=$post[idx]";
	$url_delete			= "?cate=bbs&mode=delete&idx=$post[idx]";
	$url_delete_submit			= "?cate=bbs&mode=delete_submit&idx=$post[idx]";
	$url_addfile		= "?cate=bbs&mode=addfile&idx=$post[idx]";
}
if ( isset($ui['idx']) )
{
	$url_deletefile	= "?cate=bbs&mode=deletefile&idx=$ui[idx]";
}
if ( isset($category) )
{
	$url_configure	= "?cate=bbs&mode=configure&idx=$category[idx]";
}
$url_list				= "?cate=bbs&mode=list&id=$category_id$hvPageNo";
$url_write			= "?cate=bbs&mode=write&idx=$category_idx";



// ====== 기본 변수 세팅
// 로그인을 했고, 자신의 글인 경우,
if ( isset($post['idx_user']) && login() && $post['idx_user'] == $user['idx'] ) $mypost = 1;
else $mypost = 0;




/**
 * @since 2007/01/11 읽기, 답변, 수정에서 정보의 접근 권한을 체크한다. 리스트는 해야한다.
 * @since 2007/02/16 자신의 글은 통과한다.
 */
if ( ($mypost == 0 ) && ($mode == 'read' || $mode == 'reply' || $mode == 'modify') )
{
	isset($user['grade']) ? $my['grade'] = $user['grade'] : $my['grade'] = 0;
	if ( $my['grade'] < $post['r'] ) goBack(accessDenied, "you are not allowed to access this page");
}







/**
 * 권한에 대한 인증과 상관 없이, 답변글(코멘트)이 있는 경우, 원글을 수정, 삭제하지 못하게한다.
 * @since 2007/01/28 관리자는 제외
 */
if ( isset($category) && ! subadmin($category['managers']) ) {
	if ( $mode == 'modify' || $mode == 'modify_submit' || $mode == 'delete' || $mode == 'delete_submit' )
	{
		if ( $post['children'] ) goBack(wrongAction, "bbs::begin you can not delete or modify post when some comments of the post are exist.");
	}
}







/** ============================================================================
 *
 *                            [ 권한 체크 ]
 *
 * 이렇게 begin.php 에 모든 권한 체크를 기록하는 것이 복잡해 보일지 모르지만,
 * 체계가 잡히면 아주 간단하다. 예를 들어 새로운 권한 체크가 필요하면 비교구문만
 * 수정해 주면된다.
 *
 * 
 * 카테고리의 권한 제한일 경우에는 write 부분만 제한한다.
 * @todo 필요할 경우 카테고리에 권한을 더 체크한다.
 * @since 2007/01/29 권한 체크는 각 스크립트에서 하도록 변경을 해 나간다. 예를 들면 configure.php 의 경우 자체에서 권한 체크를 한다.
 * @since 2007/02/13 글 쓰기 권한이 없는 경우, 로그인을 하지 않았다면 로그인을 하도록 변경.
 */
if ( $mode == 'write' || $mode == 'write_submit' )
{
	if ( ! grade($category['w']) )
	{
		if ( ! login() )
		{
			go(urlLoginPage());
//			go(urlLoginPage('loginFirst'));

		}
		else
		{
			goBack("accessDenied", "bbs::begin you are not allowed to post. contact to the webmaster");
		}
	}
}




// ============================================================================
//
//                            [ 수정, 첨부, 삭제 등의 권한 체크 ]
//
// 글을 쓴 후, 수정, 첨부, 삭제 등의 작업에서 권한이 있는지 체크
//

if ( $mode == 'modify_submit' || $mode == 'delete_submit' || $mode == 'addfile_submit' || $mode == 'deletefile_submit')
{

	// ================ 로그인도 안했고, 비번 입력도 안된 경우,
	if ( !login() && empty($ui['password']) ) {
		switch( $mode )
		{
			case 'delete_submit'		: go($url_delete); // (비밀 번호 입력을 위해서) 글 삭제 페이지로 이동
			case 'modify_submit'		: goBack(accessDenied, "게시물을 수정하기 위해서는 비밀번호 입력 또는 회원 로그인을 하십시오.");
			case 'deletefile_submit': go($url_deletefile);
			default :
				goBack(accessDenied, "사용자 인증을 해야 해당 기능을 이용할 수 있습니다. 사용자 인증을 위한 기능이 준비되어 있지 않습니다. 관리자에게 요청을 하십시오.");
		}
		/*
		if ( $mode == 'delete_submit' ) 
			go($url_delete);	// (비밀 번호 입력을 위해서) 글 삭제 페이지로 이동
		else if ( $mode == 'modify_submit' )
			goBack(accessDenied, "게시물을 수정하기 위해서는 비밀번호 입력 또는 회원 로그인을 하십시오.");
			*/
	}
	
	// ================ 로그인을 한 경우,
	//
	// 자신의 글인지 체크, 또는 관리자인지 체크
	if ( login() )
	{
		if ( ($post['idx_user'] == $user['idx']) || subadmin($category['managers']) ) {}
		else goBack(accessDenied, $lang['accessDenied']);
	}
	else
	{
		// ============== 로그인을 안했고, 비번을 입력한 경우,
		if ( $post['password'] == md5($ui['password']) )
		{
			// 인증 성공
		}
		else
		{
				goBack(wrongPassword, "글(또는 관련 내용) 수정(삭제)을 위한 입력된 비밀번호가 올바르지 않습니다.");
		}
	}
}



	

	

// ========================== 기본 변수 세팅
$page_title = $category_name;


// 관리자 권한이 있는 경우, subadmin 부터 관리자 권한이 있는 것이다.
if ( isset($category) && subadmin($category['managers']) ) $admin = 1;
else $admin = 0;


// ========================== 기본 작업 처리
/**
 * 스킨 변경
 */
if ( isset($category) && !empty($category['skin']) )
{
	changeSkin($category['skin']);
}
?>
