<?php
/**
 * log file module.
 *
 * Every log must be written by this module.
 * @package library
 *
 */


/**
 * log class
 */
class log
{
	function log()
	{
	}
	
	/**
	 * 로그 파일 작성
	 *
	 * 만약, $info[message] 에 값이 있으면, 따로 로그 형식을 작성하지 않고 $info[message] 만 저장한다.
	 * @param string $file 로그 파일 경로
	 * @param associative-array $info 로그 파일 정보를 담고 있는 배열. user 에 사용자 이름, id 에 아이디, message 에 메세지.
	 * @return boolean 성공적으로 로그를 기록했으면 true, 아니면 false
	 */
	function access($file, $info)
	{
		if ( empty( $info['message'] ) )
		{
			$h = $_SERVER[REMOTE_ADDR];
			$l = $info['id'];
			$u = $info['name'];
			$t = date("[d/M/Y:H:i:s O]");
			$r = "$_SERVER[REQUEST_METHOD] $_SERVER[REQUEST_URI] $_SERVER[SERVER_PROTOCOL]";
			$s = "200";							// 스크립트에서 실행되는 한, 이 값은 유효하지 않다.
			$b = "0";								// 스크립트에서 출력하는 데이터의 크기 + 헤더의 크기를 계산
			$ref	= $_SERVER['HTTP_REFERER'];
			$a	= $_SERVER['HTTP_USER_AGENT'];
			$line = "$h $l $u $t \"$r\" $s $b \"$ref\" \"$a\"\n";
		}
		else
		{
			$line = $info['message'];
		}

		// 파일이 존재하지 않으면 에러 발생. 처리를 한다.
		if ( ! @attachString($file, $line) )
		{
			if ( is_dir( log_repository ) ) return false;
			mkdirEx(log_repository);
			return attachString($file, $line);
		}
		return true;
	}
}


?>
