<?php
/**
 * php-xlmrpc 라이브러리를 사용하기 쉽게 하는 라이브러리이다.
 *
 * @note lib/ 디렉토리에 들어가기에는 범용성이나 독립성에 문제가 있다.
 * @note siteapi 디렉토리에 존재하는 라이브러리를 사용한다.
 *
 * @since 2007/03/22 siteapi 의 라이브러리 소스 스크립트를 사용하도록 했다.
 */


include_once("siteapi/xmlrpc-2.1/lib/xmlrpc.inc");

/**
 * 원격 서버에 글을 쓴다.
 *
 * @return string XML-RPC faultCode 가 리턴된다.
 */
function xmlrpc_newPost($data)
{
	$GLOBALS['xmlrpc_internalencoding'] = 'UTF-8';
	$pa[]			= xs($data['category']);
	$pa[]			= xs($data['id']);
	$pa[]			= xs($data['pw']);
	$pa[]			= xas(array('dateCreated'=>iso8601(),'title'=>$data['title'], 'description'=>$data['description']));
	$pa[]			= xb($data['publish']);
	$msg			= new xmlrpcmsg("metaWeblog.newPost", $pa);

	$client = new xmlrpc_client( $data['endpoint'] );
	$re					= $client->send( $msg );
	$fc					= $re->faultCode();

	return $fc;
}
/**
 * 입력된 값을 'string' 형 xmlrpcval 객체로 리턴한다.
 *
 * @note 모든 문자열 관련 인코딩은 이 함수를 통해서 이루어진다. 그래야 일관성을 부여할 수 있다.
 * @note 이 함수에서 문자셋 변환을 한다. $GLOALS['db_charset'] 에 표시된 값이 utf8 이 아니면 utf8 로 변환을 한다.
 * @param string $var XML 데이터에 <string> 형으로 담겨질 문자열
 * @return xmlrpcval
 * @todo 문자열 처리가 올바르지 않다. string 형의 값에 UTF-8 코드를 적용한다. 올바로 실행이 되는지 체크를 해야한다.
 */
function xs($var)
{
	$obj = new xmlrpcval($var, 'string');
	return $obj;
}
function rxs($var) { return new xmlrpcresp( xs($var) ); }
function xi ($var)
{
	return new xmlrpcval($var, 'int');
}
function xd ($var)
{
	return new xmlrpcval($var, 'dateTime.iso8601');
}
function xb ($var)
{
	return new xmlrpcval($var, 'boolean');
}
function rxb($var) { return new xmlrpcresp( xb($var) ); }


function x64($var)
{
	return new xmlrpcval($var, 'base64');
}


/**
 * XML 데이터에 <struct> 형태의 값을 넣는다.
 *
 * 입력된 연관 배열 변수 $as의 값 부분을 xmlrpcval('', 'string') 값으로 만들어 리턴한다.
 * @param associative-array $as
 * @return xmlrpcval 객체를 리턴한다.
 * @example return new xmlrpcresp( xas($result) ); 와 같이 리턴 값을 바로 객체로 사용할 수 있다.
 */
function xas ($as)
{
	foreach ($as as $k=>$v)
	{
		$ar[$k] = xs($v);
	}
	return new xmlrpcval($ar, 'struct');
}
function rxas($as) { return new xmlrpcresp( xas( $as ) ); }

/**
 * XML 데이터에 <array> 형의 값을 넣는다.
 *
 * 주의: 이 함수는 문자 배열의 경우에만 사용이 가능하다. 업데이트가 필요하다.
 * @param array $a 배열 변수
 * @return xmlrpcval
 */
function xa ($a)
{
 	$ar = array(); // @todo check 가 필요하다. 이 값이 있으면 xa(array('')); 가 아니고 xa(array()) 로 되나?
	foreach ($a as $v)
	{
		$ar[] = xs($v);
	}
	return new xmlrpcval($ar, 'array');
}
function xaas($aas)
{
	$ar = array();
	foreach ( $aas as $as )
	{
		$ar[] = xas($as);
	}
	return new xmlrpcval( $ar, 'array' );
}
/**
 * 2차원 배열(각 요소 연관 배열)을 입렵받아 array of structs 로 인코딩한 다음 xmlrpcresp 객체로 리턴.
 *
 * string 데이터 형으로 인코딩한다. 다른 형으로 인코딩하기 위해서 업데이트가 필요하다.
 *
 */
function rxaas($aas)
{
	return new xmlrpcresp( xaas($aas) );
}

?>
