/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.swrc.jhannanum.plugin.MajorPlugin.MorphAnalyzer.ChartMorphAnalyzer;

import java.util.ArrayList;
import java.util.LinkedList;
import kr.ac.kaist.swrc.jhannanum.comm.Eojeol;
import kr.ac.kaist.swrc.jhannanum.plugin.MajorPlugin.MorphAnalyzer.ChartMorphAnalyzer.Connection;
import kr.ac.kaist.swrc.jhannanum.plugin.MajorPlugin.MorphAnalyzer.ChartMorphAnalyzer.Exp;
import kr.ac.kaist.swrc.jhannanum.plugin.MajorPlugin.MorphAnalyzer.ChartMorphAnalyzer.NumberDic;
import kr.ac.kaist.swrc.jhannanum.plugin.MajorPlugin.MorphAnalyzer.ChartMorphAnalyzer.SegmentPosition;
import kr.ac.kaist.swrc.jhannanum.plugin.MajorPlugin.MorphAnalyzer.ChartMorphAnalyzer.Simti;
import kr.ac.kaist.swrc.jhannanum.plugin.MajorPlugin.MorphAnalyzer.ChartMorphAnalyzer.Trie;
import kr.ac.kaist.swrc.jhannanum.share.Code;
import kr.ac.kaist.swrc.jhannanum.share.TagSet;

public class MorphemeChart {
    private static final String CHI_REPLACE = "HAN_CHI";
    private static final String ENG_REPLACE = "HAN_ENG";
    private LinkedList<String> chiReplacementList = null;
    private LinkedList<String> engReplacementList = null;
    private int engReplaceIndex = 0;
    private int chiReplaceIndex = 0;
    private static final int MAX_MORPHEME_CONNECTION = 30;
    private static final int MAX_MORPHEME_CHART = 2046;
    private static final int MORPHEME_STATE_INCOMPLETE = 2;
    private static final int MORPHEME_STATE_SUCCESS = 1;
    private static final int MAX_CANDIDATE_NUM = 100000;
    private static final int MORPHEME_STATE_FAIL = 0;
    public Morpheme[] chart = null;
    public int chartEnd = 0;
    private TagSet tagSet = null;
    private Connection connection = null;
    private SegmentPosition sp = null;
    private String bufString = "";
    private int[] segmentPath = new int[1024];
    private Exp exp = null;
    private Trie systemDic = null;
    private Trie userDic = null;
    private NumberDic numDic = null;
    private Simti simti = null;
    private int printResultCnt = 0;
    private LinkedList<Eojeol> resEojeols = null;
    private ArrayList<String> resMorphemes = null;
    private ArrayList<String> resTags = null;

    public MorphemeChart(TagSet tagSet, Connection connection, Trie systemDic, Trie userDic, NumberDic numDic, Simti simti, LinkedList<Eojeol> resEojeolList) {
        this.chart = new Morpheme[2046];
        int i = 0;
        while (i < 2046) {
            this.chart[i] = new Morpheme();
            ++i;
        }
        this.sp = new SegmentPosition();
        this.tagSet = tagSet;
        this.connection = connection;
        this.exp = new Exp(this, tagSet);
        this.systemDic = systemDic;
        this.userDic = userDic;
        this.numDic = numDic;
        this.simti = simti;
        this.resEojeols = resEojeolList;
        this.resMorphemes = new ArrayList();
        this.resTags = new ArrayList();
        this.chiReplacementList = new LinkedList();
        this.engReplacementList = new LinkedList();
    }

    public int addMorpheme(int tag, int phoneme, int nextPosition, int nextTagType) {
        this.chart[this.chartEnd].tag = tag;
        this.chart[this.chartEnd].phoneme = phoneme;
        this.chart[this.chartEnd].nextPosition = nextPosition;
        this.chart[this.chartEnd].nextTagType = nextTagType;
        this.chart[this.chartEnd].state = 2;
        this.chart[this.chartEnd].connectionCount = 0;
        return this.chartEnd++;
    }

    public int altSegment(String str) {
        int prev = 0;
        int next = 0;
        int len = str.length();
        String rev = "";
        int i = len - 1;
        while (i >= 0) {
            rev = String.valueOf(rev) + str.charAt(i);
            --i;
        }
        char[] revStrArray = rev.toCharArray();
        int match = this.simti.search(revStrArray);
        int to = this.simti.fetch(rev.substring(0, match).toCharArray());
        int i2 = 0;
        while (i2 < str.length()) {
            if (len <= match) break;
            next = this.sp.addPosition(str.charAt(i2));
            if (prev != 0) {
                this.sp.setPositionLink(prev, next);
            }
            this.simti.insert(rev.substring(0, len).toCharArray(), next);
            prev = next;
            --len;
            ++i2;
        }
        if (prev != 0) {
            this.sp.setPositionLink(prev, to);
        }
        return this.simti.fetch(revStrArray);
    }

    public int analyze() {
        int res = 0;
        res = this.analyze(0, 0);
        if (res > 0) {
            return res;
        }
        return this.analyzeUnknown();
    }

    private int analyze(int chartIndex, int tagType) {
        int mp;
        int i;
        LinkedList<Trie.INFO> infoList = null;
        Trie.INFO info = null;
        int sidx = 1;
        int uidx = 1;
        int nidx = 1;
        SegmentPosition.Position fromPos = null;
        SegmentPosition.Position toPos = null;
        Morpheme morph = this.chart[chartIndex];
        int from = morph.nextPosition;
        fromPos = this.sp.getPosition(from);
        switch (this.sp.getPosition((int)from).state) {
            default: {
                return 0;
            }
            case 0: {
                i = 0;
                this.bufString = "";
                int to = from;
                while (to != 0) {
                    toPos = this.sp.getPosition(to);
                    char c = toPos.key;
                    if (sidx != 0) {
                        sidx = this.systemDic.node_look(c, sidx);
                    }
                    if (uidx != 0) {
                        uidx = this.userDic.node_look(c, uidx);
                    }
                    if (nidx != 0) {
                        nidx = this.numDic.node_look(c, nidx);
                    }
                    toPos.sIndex = sidx;
                    toPos.uIndex = uidx;
                    toPos.nIndex = nidx;
                    this.bufString = String.valueOf(this.bufString) + c;
                    this.segmentPath[i++] = to;
                    to = this.sp.nextPosition(to);
                }
                nidx = 0;
                while (i > 0) {
                    int nc_idx;
                    int j;
                    Trie.TNODE node;
                    to = this.segmentPath[i - 1];
                    toPos = this.sp.getPosition(to);
                    if (toPos.sIndex != 0) {
                        node = this.systemDic.get_node(toPos.sIndex);
                        infoList = node.info_list;
                        if (infoList != null) {
                            j = 0;
                            while (j < infoList.size()) {
                                info = infoList.get(j);
                                nc_idx = this.addMorpheme(info.tag, info.phoneme, this.sp.nextPosition(to), 0);
                                this.chart[nc_idx].str = this.bufString.substring(0, i);
                                fromPos.morpheme[fromPos.morphCount++] = nc_idx;
                                ++j;
                            }
                        }
                    }
                    if (toPos.uIndex != 0) {
                        node = this.userDic.get_node(toPos.uIndex);
                        infoList = node.info_list;
                        if (infoList != null) {
                            j = 0;
                            while (j < infoList.size()) {
                                info = infoList.get(j);
                                nc_idx = this.addMorpheme(info.tag, info.phoneme, this.sp.nextPosition(to), 0);
                                this.chart[nc_idx].str = this.bufString.substring(0, i);
                                fromPos.morpheme[fromPos.morphCount++] = nc_idx;
                                ++j;
                            }
                        }
                    }
                    if (nidx == 0 && toPos.nIndex != 0) {
                        if (this.numDic.isNum(toPos.nIndex)) {
                            nc_idx = this.addMorpheme(this.tagSet.numTag, 0, this.sp.nextPosition(to), 0);
                            this.chart[nc_idx].str = this.bufString.substring(0, i);
                            fromPos.morpheme[fromPos.morphCount++] = nc_idx;
                            nidx = toPos.nIndex;
                        } else {
                            nidx = 0;
                        }
                    }
                    --i;
                }
                fromPos.state = 1;
            }
            case 1: {
                this.exp.prule(from, morph.str, this.bufString, this.sp);
                this.sp.getPosition((int)from).state = 2;
            }
            case 2: {
                int x = 0;
                i = 0;
                while (i < fromPos.morphCount) {
                    mp = fromPos.morpheme[i];
                    if (this.tagSet.checkTagType(tagType, this.chart[mp].tag)) {
                        if (this.chart[mp].state == 2) {
                            int y = this.analyze(mp, this.chart[mp].nextTagType);
                            x += y;
                            this.chart[mp].state = y != 0 ? 1 : 0;
                        } else {
                            x += this.chart[mp].connectionCount;
                        }
                    }
                    ++i;
                }
                if (x == 0) {
                    if (tagType == 0) {
                        fromPos.state = 4;
                    }
                    return 0;
                }
                if (tagType != 0) break;
                fromPos.state = 3;
            }
            case 3: 
        }
        i = 0;
        while (i < fromPos.morphCount) {
            mp = fromPos.morpheme[i];
            if (this.chart[mp].state == 1 && this.connection.checkConnection(this.tagSet, morph.tag, this.chart[mp].tag, morph.str.length(), this.chart[mp].str.length(), morph.nextTagType)) {
                morph.connection[morph.connectionCount++] = mp;
            }
            ++i;
        }
        return morph.connectionCount;
    }

    public int analyzeUnknown() {
        this.bufString = "";
        SegmentPosition.Position pos_1 = this.sp.getPosition(1);
        int i = 1;
        while (i != 0) {
            SegmentPosition.Position pos = this.sp.getPosition(i);
            this.bufString = String.valueOf(this.bufString) + pos.key;
            if (!Code.isChoseong(pos.key)) {
                int nc_idx = this.addMorpheme(this.tagSet.unkTag, 0, this.sp.nextPosition(i), 0);
                this.chart[nc_idx].str = this.bufString;
                pos_1.morpheme[pos_1.morphCount++] = nc_idx;
                pos_1.state = 2;
            }
            i = this.sp.nextPosition(i);
        }
        this.chart[0].connectionCount = 0;
        return this.analyze(0, 0);
    }

    public boolean checkChart(int[] morpheme, int morphemeLen, int tag, int phoneme, int nextPosition, int nextTagType, String str) {
        int i = 0;
        while (i < morphemeLen) {
            Morpheme morph = this.chart[morpheme[i]];
            if (morph.tag == tag && morph.phoneme == phoneme && morph.nextPosition == nextPosition && morph.nextTagType == nextTagType && morph.str.equals(str)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void getResult() {
        this.printResultCnt = 0;
        this.printChart(0);
    }

    public void init(String word) {
        this.simti.init();
        word = this.preReplace(word);
        this.sp.init(Code.toTripleString(word), this.simti);
        this.chartEnd = 0;
        SegmentPosition.Position p = this.sp.getPosition(0);
        p.morpheme[p.morphCount++] = this.chartEnd;
        this.chart[this.chartEnd].tag = this.tagSet.iwgTag;
        this.chart[this.chartEnd].phoneme = 0;
        this.chart[this.chartEnd].nextPosition = 1;
        this.chart[this.chartEnd].nextTagType = 0;
        this.chart[this.chartEnd].state = 1;
        this.chart[this.chartEnd].connectionCount = 0;
        this.chart[this.chartEnd].str = "";
        ++this.chartEnd;
    }

    public void phonemeChange(int from, String front, String back, int ftag, int btag, int phoneme) {
        Trie.TNODE node = null;
        int size = 0;
        node = this.systemDic.fetch(front.toCharArray());
        if (node != null && node.info_list != null) {
            size = node.info_list.size();
        }
        SegmentPosition.Position pos = this.sp.getPosition(from);
        int i = 0;
        while (i < size) {
            Trie.INFO info = node.info_list.get(i);
            boolean x = this.tagSet.checkTagType(ftag, info.tag);
            boolean y = this.tagSet.checkPhonemeType(phoneme, info.phoneme);
            if (x && y) {
                int next = this.altSegment(back);
                if (!this.checkChart(pos.morpheme, pos.morphCount, info.tag, info.phoneme, next, btag, front)) {
                    int nc_idx = this.addMorpheme(info.tag, info.phoneme, next, btag);
                    this.chart[nc_idx].str = front;
                    pos.morpheme[pos.morphCount++] = nc_idx;
                } else {
                    System.err.println("phonemeChange: exit");
                    System.exit(0);
                }
            }
            ++i;
        }
    }

    private void printChart(int chartIndex) {
        Morpheme morph = this.chart[chartIndex];
        int engCnt = 0;
        int chiCnt = 0;
        if (chartIndex == 0) {
            int i = 0;
            while (i < morph.connectionCount) {
                this.resMorphemes.clear();
                this.resTags.clear();
                this.printChart(morph.connection[i]);
                ++i;
            }
        } else {
            String morphStr = Code.toString(morph.str.toCharArray());
            int idx = 0;
            engCnt = 0;
            chiCnt = 0;
            while (idx != -1) {
                idx = morphStr.indexOf(ENG_REPLACE);
                if (idx != -1) {
                    ++engCnt;
                    morphStr = morphStr.replaceFirst(ENG_REPLACE, this.engReplacementList.get(this.engReplaceIndex++));
                    continue;
                }
                idx = morphStr.indexOf(CHI_REPLACE);
                if (idx == -1) continue;
                ++chiCnt;
                morphStr = morphStr.replaceFirst(CHI_REPLACE, this.chiReplacementList.get(this.chiReplaceIndex++));
            }
            this.resMorphemes.add(morphStr);
            this.resTags.add(this.tagSet.getTagName(morph.tag));
            int i = 0;
            while (i < morph.connectionCount && this.printResultCnt < 100000) {
                if (morph.connection[i] == 0) {
                    String[] mArray = this.resMorphemes.toArray(new String[0]);
                    String[] tArray = this.resTags.toArray(new String[0]);
                    this.resEojeols.add(new Eojeol(mArray, tArray));
                    ++this.printResultCnt;
                } else {
                    this.printChart(morph.connection[i]);
                }
                ++i;
            }
            this.resMorphemes.remove(this.resMorphemes.size() - 1);
            this.resTags.remove(this.resTags.size() - 1);
            if (engCnt > 0) {
                this.engReplaceIndex -= engCnt;
            }
            if (chiCnt > 0) {
                this.chiReplaceIndex -= chiCnt;
            }
        }
    }

    public void printMorphemeAll() {
        System.err.println("chartEnd: " + this.chartEnd);
        int i = 0;
        while (i < this.chartEnd) {
            System.err.println("chartID: " + i);
            System.err.format("%s/%s.%s nextPosition=%c nextTagType=%s state=%d ", Code.toString(this.chart[i].str.toCharArray()), this.tagSet.getTagName(this.chart[i].tag), this.tagSet.getIrregularName(this.chart[i].phoneme), Character.valueOf(Code.toCompatibilityJamo(this.sp.getPosition((int)this.chart[i].nextPosition).key)), this.tagSet.getTagName(this.chart[i].nextTagType), this.chart[i].state);
            System.err.print("connection=");
            int j = 0;
            while (j < this.chart[i].connectionCount) {
                System.err.print(String.valueOf(this.chart[i].connection[j]) + ", ");
                ++j;
            }
            System.err.println();
            ++i;
        }
    }

    private String preReplace(String str) {
        String result = "";
        boolean engFlag = false;
        boolean chiFlag = false;
        String buf = "";
        this.engReplacementList.clear();
        this.chiReplacementList.clear();
        this.engReplaceIndex = 0;
        this.chiReplaceIndex = 0;
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                if (engFlag) {
                    buf = String.valueOf(buf) + c;
                } else {
                    if (engFlag) {
                        engFlag = false;
                        this.engReplacementList.add(buf);
                        buf = "";
                    }
                    result = String.valueOf(result) + ENG_REPLACE;
                    buf = String.valueOf(buf) + c;
                    engFlag = true;
                }
            } else if (c >= '\u2e80' && c <= '\u2eff' || c >= '\u3400' && c <= '\u4dbf' || c >= '\u4e00' && c < '\u9fbf' || c >= '\uf900' && c <= '\ufaff' && chiFlag) {
                if (chiFlag) {
                    buf = String.valueOf(buf) + c;
                } else {
                    if (chiFlag) {
                        chiFlag = false;
                        this.chiReplacementList.add(buf);
                        buf = "";
                    }
                    result = String.valueOf(result) + CHI_REPLACE;
                    buf = String.valueOf(buf) + c;
                    chiFlag = true;
                }
            } else {
                result = String.valueOf(result) + c;
                if (engFlag) {
                    engFlag = false;
                    this.engReplacementList.add(buf);
                    buf = "";
                }
                if (chiFlag) {
                    chiFlag = false;
                    this.chiReplacementList.add(buf);
                    buf = "";
                }
            }
            ++i;
        }
        if (engFlag) {
            this.engReplacementList.add(buf);
        }
        if (chiFlag) {
            this.chiReplacementList.add(buf);
        }
        return result;
    }

    public class Morpheme {
        int tag;
        int phoneme;
        int nextPosition;
        int nextTagType;
        int state;
        int connectionCount;
        int[] connection = new int[30];
        String str = "";
    }
}

