/**
 * 
 */
package kr.ac.kaist.swrc.jhannanum.demo;

import java.io.FileNotFoundException;
import java.io.IOException;

import kr.ac.kaist.swrc.jhannanum.hannanum.Workflow;
import kr.ac.kaist.swrc.jhannanum.plugin.MajorPlugin.MorphAnalyzer.ChartMorphAnalyzer.ChartMorphAnalyzer;
import kr.ac.kaist.swrc.jhannanum.plugin.MajorPlugin.PosTagger.HmmPosTagger.HMMTagger;
import kr.ac.kaist.swrc.jhannanum.plugin.SupplementPlugin.MorphemeProcessor.UnknownMorphProcessor.UnknownProcessor;
import kr.ac.kaist.swrc.jhannanum.plugin.SupplementPlugin.PlainTextProcessor.InformalSentenceFilter.InformalSentenceFilter;
import kr.ac.kaist.swrc.jhannanum.plugin.SupplementPlugin.PlainTextProcessor.SentenceSegmentor.SentenceSegmentor;

/**
 * @author Sangwon Park (hudoni@world.kaist.ac.kr), CILab, SWRC, Kaist
 *
 */
public class WorkflowWithHMMTagger {

	public static void main(String[] args) {
		Workflow workflow = new Workflow();
		
		try {
			/* Setting up the work flow */
			/* Phase1. Supplement Plug-in for analyzing the plain text */
			workflow.appendPlainTextProcessor(new SentenceSegmentor(), null);
			workflow.appendPlainTextProcessor(new InformalSentenceFilter(), null);
			
			/* Phase2. Morphological Analyzer Plug-in and Supplement Plug-in for post processing */
			workflow.setMorphAnalyzer(new ChartMorphAnalyzer(), "data/morph.conf");
			workflow.appendMorphemeProcessor(new UnknownProcessor(), null);
			
			/* Phase3. Part Of Speech Tagger Plug-in and Supplement Plug-in for post processing */
			workflow.setPosTagger(new HMMTagger(), "data/tagger.conf");

			/* Activate the workflow in the thread mode */
			workflow.activateWorkflow(true);
			
			/* Analysis using the work flow */
			String document = "Ʈ ü ȸ.\n"
				+ "ȸ   ϴ.\n"
				+ ": 2010 7 30  1\n"
				+ ": Coex Conference Room\n";
			
			workflow.analyze(document);
			System.out.println(workflow.getResult());
			
			workflow.close();
			
		} catch (FileNotFoundException e) {
			e.printStackTrace();
			System.exit(0);
		} catch (IOException e) {
			e.printStackTrace();
			System.exit(0);
		}
		
		/* Shutdown the work flow */
		workflow.close();  	
	}
}