/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.swrc.jhannanum.module.usn;

import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import kr.ac.kaist.swrc.jhannanum.module.Module;
import kr.ac.kaist.swrc.jhannanum.share.Code;

public class USNProcessor
implements Module {
    private static final String MODULE_NAME = "USNProcessor";
    private String HA = null;
    private String AR = null;
    private String A_ = null;
    private String PV = null;
    private String XEU = null;
    private String DOB = null;
    private String GOB = null;
    private String EU = null;
    private String SU = null;
    private String NU = null;
    private String word = null;
    private String data = null;
    private String line = null;
    private String[] processing = new String[1000];
    private int p_end = 0;
    private String tmpword = null;
    private String tmptag = null;
    private String tmpstr = null;
    private String prevword = null;
    private String tmpmorph = null;
    private String buff = null;
    private BufferedReader in = null;
    private PrintWriter out = null;

    private void action() {
        if (this.p_end == 0) {
            return;
        }
        this.out.write(String.valueOf(this.processing[0]) + '\n');
        int i = 1;
        while (i < this.p_end) {
            this.out.write(String.format("\t%s\n", this.processing[i]));
            ++i;
        }
        this.out.write(10);
        this.p_end = 0;
        this.out.flush();
    }

    /*
     * Unable to fully structure code
     */
    private int front_morph(String str) {
        i = 0;
        this.tmpmorph = "";
        if (str == null) {
            return -1;
        }
        if (str.length() != 0) ** GOTO lbl10
        return -1;
lbl-1000:
        // 1 sources

        {
            if (str.charAt(i) == '\\') {
                this.tmpmorph = String.valueOf(this.tmpmorph) + str.charAt(i++);
            }
            this.tmpmorph = String.valueOf(this.tmpmorph) + str.charAt(i++);
lbl10:
            // 2 sources

            ** while (i < str.length() && str.charAt((int)i) != '+')
        }
lbl11:
        // 1 sources

        if (i < str.length()) {
            ++i;
        }
        return i;
    }

    /*
     * Unable to fully structure code
     */
    private int front_wt(String str) {
        i = 0;
        this.tmpword = "";
        if (str == null) {
            return -1;
        }
        if (str.length() != 0) ** GOTO lbl10
        return -1;
lbl-1000:
        // 1 sources

        {
            if (str.charAt(i) == '\\') {
                this.tmpword = String.valueOf(this.tmpword) + str.charAt(i++);
            }
            this.tmpword = String.valueOf(this.tmpword) + str.charAt(i++);
lbl10:
            // 2 sources

            ** while (i < str.length() && str.charAt((int)i) != '/')
        }
lbl11:
        // 1 sources

        if (i < str.length()) {
            ++i;
        }
        return i;
    }

    @Override
    public String getName() {
        return MODULE_NAME;
    }

    @Override
    public void initialize(Reader in, Writer out, String configFile) throws Exception {
        this.in = in != null ? new BufferedReader(in) : null;
        this.out = out != null ? new PrintWriter(out) : null;
    }

    private boolean is_pvowel(char c) {
        int i = 0;
        while (i < this.PV.length()) {
            if (this.PV.charAt(i) == c) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean is_xeu(char c) {
        int i = 0;
        while (i < this.XEU.length()) {
            if (this.XEU.charAt(i) == c) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void morph_in(String str) throws Exception {
        int i = 0;
        if (str.length() != 0 && str.charAt(0) == '\t') {
            str = str.substring(1);
        }
        this.tmpstr = "";
        this.prevword = "";
        int p = this.front_morph(str);
        while (p != -1) {
            int q = this.front_wt(this.tmpmorph);
            this.tmptag = q != -1 && q < this.tmpmorph.length() ? this.tmpmorph.substring(q) : "";
            if (this.tmptag.length() != 0 && this.tmptag.charAt(0) == 'e') {
                int len = this.prevword.length();
                this.buff = Code.toTripleString(this.tmpword);
                if (this.strncmp(this.buff, this.A_, 2) == 0) {
                    if (len - 1 < this.prevword.length() && len >= 4 && this.prevword.charAt(len - 1) == this.EU.charAt(1) && !this.is_xeu(this.prevword.charAt(len - 2)) && (Code.isJungseong(this.prevword.charAt(len - 3)) && this.is_pvowel(this.prevword.charAt(len - 3)) || Code.isJongseong(this.prevword.charAt(len - 3)) && this.is_pvowel(this.prevword.charAt(len - 4)))) {
                        this.buff = this.AR.substring(0, 2);
                        this.tmpword = Code.toString(this.buff.toCharArray());
                    } else if ((len - 1 >= this.prevword.length() || len < 3 || this.prevword.charAt(len - 1) != this.DOB.charAt(2) || this.prevword.substring(len - 3).equals(this.DOB) && this.prevword.substring(len - 3).equals(this.GOB)) && (len - 2 >= this.prevword.length() || len < 2 || !this.prevword.substring(len - 2).equals(this.HA)) && len - 1 < this.prevword.length() && len >= 2 && (Code.isJungseong(this.prevword.charAt(len - 1)) && this.is_pvowel(this.prevword.charAt(len - 1)) || Code.isJongseong(this.prevword.charAt(len - 1)) && this.is_pvowel(this.prevword.charAt(len - 2)))) {
                        this.buff = this.AR.substring(0, 2);
                        this.tmpword = Code.toString(this.buff.toCharArray());
                    }
                } else if ((this.buff.startsWith(this.EU.substring(0, 2)) || this.buff.startsWith(this.SU.substring(0, 4)) || this.buff.startsWith(this.NU.substring(0, 4))) && len - 1 < this.prevword.length() && len >= 2 && (Code.isJungseong(this.prevword.charAt(len - 1)) || this.prevword.charAt(len - 1) == '\u11af')) {
                    this.tmpword = Code.toString(this.buff.substring(2).toCharArray());
                }
            }
            this.tmpstr = String.valueOf(this.tmpstr) + this.tmpword + "/" + this.tmptag + "+";
            i = this.tmpstr.length();
            this.prevword = Code.toTripleString(this.tmpword);
            if (p < str.length()) {
                p += this.front_morph(str.substring(p));
                continue;
            }
            p = -1;
        }
        this.tmpstr = this.tmpstr.substring(0, this.tmpstr.length() - 1);
        i = 1;
        while (i < this.p_end) {
            if (this.processing[i].equals(this.tmpstr)) break;
            ++i;
        }
        if (i >= this.p_end) {
            if (this.p_end == 1000) {
                throw new Exception("USNProcessor: out of index problem");
            }
            this.processing[this.p_end] = this.tmpstr;
            ++this.p_end;
        }
    }

    @Override
    public void run() throws Exception {
        this.p_end = 0;
        this.HA = Code.toTripleString("\ud558");
        this.AR = Code.toTripleString("\uc544");
        this.A_ = Code.toTripleString("\uc5b4");
        this.PV = Code.toTripleString("\u314f\u3151\u3157");
        this.XEU = Code.toTripleString("\ub044\ub728\uc4f0\ud06c\ud2b8");
        this.DOB = Code.toTripleString("\ub3d5");
        this.GOB = Code.toTripleString("\uacf1");
        this.EU = Code.toTripleString("\uc73c");
        this.SU = Code.toTripleString("\uc2b5\ub2c8");
        this.NU = Code.toTripleString("\ub294\ub2e4");
        String line = null;
        while ((line = this.in.readLine()) != null) {
            try {
                if (line.length() == 0) {
                    this.action();
                    continue;
                }
                if (line.charAt(0) == '\t') {
                    this.morph_in(line);
                    continue;
                }
                this.word_in(line);
            }
            catch (Exception e) {
                System.err.println("USNProcessor: Passed Sentence: " + line.replaceAll("EOS|BOS", ""));
            }
        }
        this.action();
    }

    @Override
    public void setReader(Reader in) {
        this.in = in != null ? new BufferedReader(in) : null;
    }

    @Override
    public void setWriter(Writer out) {
        this.out = out != null ? new PrintWriter(out) : null;
    }

    @Override
    public void shutdown() {
    }

    private int strncmp(String s1, String s2, int len) {
        if (s1.length() < len) {
            return 1;
        }
        if (s2.length() < len) {
            return -1;
        }
        int i1 = 0;
        int i2 = 0;
        while (len-- > 0) {
            if (s1.charAt(i1++) != s2.charAt(i2++)) break;
        }
        return s1.charAt(i1 - 1) - s2.charAt(i2 - 1);
    }

    private void word_in(String str) {
        if (this.p_end != 0) {
            this.action();
        }
        this.processing[0] = str;
        this.p_end = 1;
    }
}

