/**
 * 
 */
package kr.ac.kaist.swrc.jhannanum.demo;

import kr.ac.kaist.swrc.jhannanum.hannanum.HanNanum;
import kr.ac.kaist.swrc.jhannanum.module.ma.MorphAnalyzer;
import kr.ac.kaist.swrc.jhannanum.module.sentence.SentenceSplitter;
import kr.ac.kaist.swrc.jhannanum.module.tagger.HMMTagger;
import kr.ac.kaist.swrc.jhannanum.module.unknown.UnknownProcessor;
import kr.ac.kaist.swrc.jhannanum.module.usn.USNProcessor;

/**
 * @author Sangwon Park (hudoni@world.kaist.ac.kr), CILab, SWRC, Kaist
 *
 */
public class WorkflowWithHMMTagger {

	public static void main(String[] args) {
		HanNanum han = new HanNanum();
    	
    	try {
    		/* Setting up the work flow */
    		han.addModule(new SentenceSplitter(), null);
			han.addModule(new MorphAnalyzer(), "data/morph.conf");
			han.addModule(new UnknownProcessor(), null);
			han.addModule(new USNProcessor(), null);
			han.addModule(new HMMTagger(), null);
			
			/* Activating the work flow */
			han.activateWorkflow();
			
			/* Analysis using the work flow */
			String test = null;

			test = "Ʈ ü ȸ\n"
				 + "ȸ   ϴ.\n";
			System.out.println(han.analyze(test));
			
			test = ": 2010 7 30  1\n"
				 + ": Coex Conference Room\n";
			System.out.println(han.analyze(test));
			
		} catch (Exception e) {
			e.printStackTrace();
			System.exit(0);
		}
		
		/* Shutdown the work flow */
		han.close();  	
	}
}
