/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.swrc.jhannanum.module.ma;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.LinkedList;
import java.util.StringTokenizer;
import kr.ac.kaist.swrc.jhannanum.module.Module;
import kr.ac.kaist.swrc.jhannanum.module.ma.AnalyzedDic;
import kr.ac.kaist.swrc.jhannanum.module.ma.Connection;
import kr.ac.kaist.swrc.jhannanum.module.ma.ConnectionNot;
import kr.ac.kaist.swrc.jhannanum.module.ma.MorphemeChart;
import kr.ac.kaist.swrc.jhannanum.module.ma.NumberDic;
import kr.ac.kaist.swrc.jhannanum.module.ma.Simti;
import kr.ac.kaist.swrc.jhannanum.module.ma.Trie;
import kr.ac.kaist.swrc.jhannanum.share.Code;
import kr.ac.kaist.swrc.jhannanum.share.TagSet;

public class MorphAnalyzer
implements Module {
    private static final String CHI_REPLACE = "HHHHH";
    private static final String ENG_REPLACE = "AAAAA";
    private static final String MODULE_NAME = "MorphAnalyzer";
    private AnalyzedDic analyzedDic = null;
    private Trie systemDic = null;
    private Trie userDic = null;
    private NumberDic numDic = null;
    private TagSet tagSet = null;
    private Connection connection = null;
    private ConnectionNot connectionNot = null;
    private MorphemeChart chart = null;
    private Simti simti = null;
    private BufferedReader in = null;
    private PrintWriter out = null;
    private LinkedList<String> chiReplacementList = null;
    private LinkedList<String> engReplacementList = null;
    private String fileConnectionsNot = "";
    private String fileConnections = "";
    private String fileDicAnalyzed = "";
    private String fileDicSystem = "";
    private String fileDicUser = "";
    private String fileTagSet = "";

    @Override
    public String getName() {
        return MODULE_NAME;
    }

    @Override
    public void initialize(Reader in, Writer out, String configFile) throws IOException {
        BufferedReader brConfig = new BufferedReader(new InputStreamReader(new FileInputStream(configFile)));
        String str = "";
        while ((str = brConfig.readLine()) != null) {
            if (str.contains("dic_system=")) {
                this.fileDicSystem = str.substring(11);
                continue;
            }
            if (str.contains("dic_user=")) {
                this.fileDicUser = str.substring(9);
                continue;
            }
            if (str.contains("connections=")) {
                this.fileConnections = str.substring(12);
                continue;
            }
            if (str.contains("connections_not=")) {
                this.fileConnectionsNot = str.substring(16);
                continue;
            }
            if (str.contains("dic_analyzed=")) {
                this.fileDicAnalyzed = str.substring(13);
                continue;
            }
            if (!str.contains("tagset=")) continue;
            this.fileTagSet = str.substring(7);
        }
        this.tagSet = new TagSet();
        this.tagSet.init(this.fileTagSet, 0);
        this.connection = new Connection();
        this.connection.init(this.fileConnections, this.tagSet.getTagCount(), this.tagSet);
        this.connectionNot = new ConnectionNot();
        this.connectionNot.init(this.fileConnectionsNot, this.tagSet);
        this.analyzedDic = new AnalyzedDic();
        this.analyzedDic.readDic(this.fileDicAnalyzed);
        this.systemDic = new Trie(1060000);
        this.systemDic.read_dic(this.fileDicSystem, this.tagSet);
        this.systemDic.print_result(this.tagSet);
        this.userDic = new Trie(120);
        this.userDic.read_dic(this.fileDicUser, this.tagSet);
        this.numDic = new NumberDic();
        this.simti = new Simti();
        this.simti.init();
        this.chart = new MorphemeChart(this.tagSet, this.connection, this.systemDic, this.userDic, this.numDic, this.simti);
        this.chiReplacementList = new LinkedList();
        this.engReplacementList = new LinkedList();
        this.in = in != null ? new BufferedReader(in) : null;
        this.out = out != null ? new PrintWriter(out) : null;
    }

    private String postReplace(String str) {
        int idx = -1;
        String replace = null;
        int i = 0;
        while ((idx = str.indexOf(ENG_REPLACE)) != -1) {
            if (i == this.engReplacementList.size()) {
                i = 0;
            }
            replace = this.engReplacementList.get(i++);
            str = String.valueOf(str.substring(0, idx)) + replace + str.substring(idx + 5);
        }
        i = 0;
        while ((idx = str.indexOf(CHI_REPLACE)) != -1) {
            if (i == this.chiReplacementList.size()) {
                i = 0;
            }
            replace = this.chiReplacementList.get(i++);
            str = String.valueOf(str.substring(0, idx)) + replace + str.substring(idx + 5);
        }
        this.engReplacementList.clear();
        this.chiReplacementList.clear();
        return str;
    }

    private String preReplace(String str) {
        String result = "";
        boolean engFlag = false;
        boolean chiFlag = false;
        String buf = "";
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                if (engFlag) {
                    buf = String.valueOf(buf) + c;
                } else {
                    if (chiFlag) {
                        chiFlag = false;
                        this.chiReplacementList.add(buf);
                        buf = "";
                    }
                    result = String.valueOf(result) + ENG_REPLACE;
                    buf = String.valueOf(buf) + c;
                    engFlag = true;
                }
            } else if (c >= '\u2e80' && c <= '\u2eff' || c >= '\u3400' && c <= '\u4dbf' || c >= '\u4e00' && c < '\u9fbf' || c >= '\uf900' && c <= '\ufaff' && chiFlag) {
                if (chiFlag) {
                    buf = String.valueOf(buf) + c;
                } else {
                    if (engFlag) {
                        engFlag = false;
                        this.engReplacementList.add(buf);
                        buf = "";
                    }
                    result = String.valueOf(result) + CHI_REPLACE;
                    buf = String.valueOf(buf) + c;
                    chiFlag = true;
                }
            } else {
                result = String.valueOf(result) + c;
                if (engFlag) {
                    engFlag = false;
                    this.engReplacementList.add(buf);
                    buf = "";
                }
                if (chiFlag) {
                    chiFlag = false;
                    this.chiReplacementList.add(buf);
                    buf = "";
                }
            }
            ++i;
        }
        if (engFlag) {
            this.engReplacementList.add(buf);
        }
        if (chiFlag) {
            this.chiReplacementList.add(buf);
        }
        return result;
    }

    private void processWord(String word) {
        if (word.indexOf("BOS") != -1) {
            this.out.write("BOS\n\n");
        } else if (word.indexOf("EOS") != -1) {
            this.out.write("EOS\n\n");
        } else if (word.indexOf("EOF") != -1) {
            this.out.write("EOF\n\n");
        } else {
            String analysis = this.analyzedDic.get(word);
            if (analysis != null) {
                this.out.write("#" + word + '\n');
                StringTokenizer st = new StringTokenizer(analysis, "^");
                while (st.hasMoreTokens()) {
                    this.out.write("\t" + st.nextToken() + '\n');
                }
            } else {
                this.out.write(" " + word + '\n');
                word = this.preReplace(word);
                if (word.indexOf(40) == -1) {
                    this.chart.init(Code.toTripleString(word));
                    this.chart.analyze();
                    this.out.write(this.postReplace(String.valueOf(this.chart.getResult()) + '\n'));
                }
            }
        }
    }

    @Override
    public void run() throws Exception {
        String line = null;
        while ((line = this.in.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(line, " \t");
            while (st.hasMoreTokens()) {
                this.processWord(st.nextToken());
                this.out.flush();
            }
        }
    }

    @Override
    public void setReader(Reader in) {
        this.in = in != null ? new BufferedReader(in) : null;
    }

    @Override
    public void setWriter(Writer out) {
        this.out = out != null ? new PrintWriter(out) : null;
    }

    @Override
    public void shutdown() {
    }
}

