/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.swrc.jhannanum.hannanum;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import kr.ac.kaist.swrc.jhannanum.module.Module;
import kr.ac.kaist.swrc.jhannanum.module.ModuleThread;

public class HanNanum {
    private static final int MODE_LOCAL = 0;
    private static final int MODE_NETWORK = 1;
    private static final String HANNANUM_EOF = "EOF";
    public static final int DEFAULT_PORT = 6000;
    public static final String DEFAULT_HOST = "hudoni.kaist.ac.kr";
    private int port = 0;
    private String host = null;
    private Socket socket = null;
    private PrintWriter out = null;
    private BufferedReader in = null;
    private int mode = 0;
    private ArrayList<Module> workflow = null;
    private ArrayList<Thread> moduleThreads = null;

    public HanNanum() {
        this.mode = 0;
        this.workflow = new ArrayList();
        this.moduleThreads = new ArrayList();
    }

    public HanNanum(String host, int port) throws UnknownHostException, IOException {
        this.mode = 1;
        this.host = host;
        this.port = port;
        this.connect(host, port);
    }

    public void activateWorkflow() throws Exception {
        PipedWriter pipeOut = new PipedWriter();
        PipedReader pipeIn = new PipedReader(pipeOut);
        this.workflow.get(this.workflow.size() - 1).setWriter(pipeOut);
        this.in = new BufferedReader(pipeIn);
        this.moduleThreads.clear();
        for (Module module : this.workflow) {
            ModuleThread th = new ModuleThread(module);
            this.moduleThreads.add(th);
            th.start();
        }
    }

    public void addModule(Module module, String configFile) throws Exception {
        PipedWriter pipeOut = new PipedWriter();
        PipedReader pipeIn = new PipedReader(pipeOut);
        if (this.workflow.size() == 0) {
            module.initialize(pipeIn, null, configFile);
            this.workflow.add(module);
            this.out = new PrintWriter(pipeOut);
            return;
        }
        Module prevModule = this.workflow.get(this.workflow.size() - 1);
        prevModule.setWriter(pipeOut);
        module.initialize(pipeIn, null, configFile);
        this.workflow.add(module);
    }

    public String analyze(String str) throws Exception {
        switch (this.mode) {
            case 0: {
                return this.processOnLocal(str);
            }
            case 1: {
                return this.processOnNetwork(str);
            }
        }
        return null;
    }

    public void close() {
        switch (this.mode) {
            case 0: {
                for (Thread th : this.moduleThreads) {
                    th.interrupt();
                }
                this.moduleThreads.clear();
                break;
            }
            case 1: {
                try {
                    this.out.close();
                    this.in.close();
                    this.socket.close();
                    break;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void connect(String host, int port) throws UnknownHostException, IOException {
        this.socket = new Socket(host, port);
        this.out = new PrintWriter(this.socket.getOutputStream(), true);
        this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
    }

    private String processOnLocal(String str) throws Exception {
        String result = "";
        this.out.write(str);
        this.out.write("\nEOF\n");
        this.out.flush();
        String line = null;
        while ((line = this.in.readLine()) != null) {
            if (line.equals(HANNANUM_EOF)) {
                while (this.in.ready()) {
                    this.in.readLine();
                }
                break;
            }
            result = String.valueOf(result) + line + '\n';
        }
        return result;
    }

    private String processOnNetwork(String str) throws UnknownHostException, IOException {
        String line = null;
        String result = "";
        this.out.write(str);
        this.out.println("EOF.");
        this.out.flush();
        while ((line = this.in.readLine()) != null) {
            if (line.startsWith("@EOF")) {
                this.in.readLine();
                this.in.readLine();
                this.in.readLine();
                this.in.readLine();
                this.in.readLine();
                this.in.readLine();
                break;
            }
            result = String.valueOf(result) + line + "\n";
        }
        return result;
    }

    public void shutdownWorkflow() throws Exception {
        for (Module module : this.workflow) {
            module.shutdown();
        }
    }
}

