#!/usr/bin/env python
# -*- coding: euc-kr -*-
"""
YahooDict.py by ddt<ddt@mirstyle.org>
license: GPL
"""
import urllib
import re

import DictResult
from Utils import listUniq, ConnectException

class YahooDict:
    def __init__(self):
        pass
    
    def search(self, word, lang='en'):
        if lang == 'en':
            url = "http://kr.engdic.yahoo.com/search/engdic?p="
        elif lang == 'ko':
            url = "http://kr.kordic.yahoo.com/search/kordic?p="
        
        try:
            data = urllib.urlopen(url+urllib.quote(word)).read()
        except:
            raise ConnectException()

        result = DictResult.DictResult()
        # stupid search -,.-;;
        if lang == 'en':
            start = data.find(' ')
            end = data.find("ܾǮ ")
            p = re.compile("("+word.split()[0]+" [0-9]+)")
            sameWords = p.findall(data)
            if sameWords:
                result.setSameWords(listUniq(sameWords))
        elif lang == 'ko':
            start = data.find('ܾ ')
            end = data.find('ܾ ˻  ')
        data = data[start:end]
        s = data.find('<t')
        e = data.find('<!')
        result.setResult(data[s:e])
        return result
