/* License : GPL
 * Author  : Lee Jeong Ho
 * Notice  : If you want to modify this source or take part in this 
 *           project, contact me. Thanks!
 * Contact : fp33@naver.com
 */
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.*;

class Management_Sub extends JFrame implements ActionListener{
	private Container con;
	private CardLayout card = new CardLayout();
	private JPanel jp_main = new JPanel();
	private JPanel jp_arrange = new JPanel();
	private JPanel jp_set = new JPanel();
	
	private ManageMent_arr ma = new ManageMent_arr();
	private ManageMent_set ms = new ManageMent_set();
	
	private JButton arrangement = new JButton(new ImageIcon("first_image.gif"));
	private JButton setting = new JButton(new ImageIcon("second_image.gif"));
	private JButton exit_pr = new JButton(new ImageIcon("third_image.gif"));
	
	private JButton back_to_main1 = new JButton();
	private JButton back_to_main2 = new JButton();
	//private Image img = Toolkit.getDefaultToolkit().getImage("mainicon.gif");
	
	
	public Management_Sub(){
		super("File Deploy Manager 0.1");
	//	setIconImage(img);
		this.init();
		this.start();

	}
	public void init(){
		
		con = this.getContentPane();
		con.setLayout(card);           // ̾ƿ ī巹̾ƿ 
		
		
		
		jp_main.setLayout(new BoxLayout(jp_main, BoxLayout.Y_AXIS));
		
		jp_main.add(arrangement);      //3 ư
		jp_main.add(setting);
		jp_main.add(exit_pr); 
		
		
		jp_arrange = ma.getPanel();   // г 
		jp_set = ms.getPanel();
		
		con.add("main_menu", jp_main);       // 3 ޴ 
		con.add("arrange_menu",jp_arrange);
		con.add("setting_menu", jp_set);
		
		
	}
	
	public void start(){

		arrangement.addActionListener(this);    //޴̵
		setting.addActionListener(this);
		
		
		back_to_main1 = ma.getBack_bt();          // ޴ƿ
		back_to_main1.addActionListener(this);
		
		back_to_main2 = ms.getBack_bt();          // ޴ƿ
		back_to_main2.addActionListener(this);
		exit_pr.addActionListener(this);          // α׷ ϱ
		
		this.setSize(300,230);
		//this.pack();
		if(this.getX() ==0 && this.getY()==0){
			this.setLocation(200,200);
		}
		

/*
 *                x ư  ̺Ʈ
 * 
 * */
		
		addWindowListener(new WindowAdapter(){
			public void windowClosing(WindowEvent e){
				
				int answer = JOptionPane.showConfirmDialog(jp_main
						, "Ͻðڽϱ?"
                        , ""
                        , JOptionPane.YES_NO_OPTION);
		
				if (answer==JOptionPane.YES_OPTION) {
					setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
				} 
				else if(answer==JOptionPane.NO_OPTION){
					setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
				
				}
			}
		});
	}
/* 
 *                 ڽ ư  ̺Ʈ
 * 
 */
	
	public void actionPerformed(ActionEvent e){
		if(e.getSource() == arrangement){       //  ޴
			card.show(con, "arrange_menu");

		}
		else if(e.getSource() == setting){      //  ޴
			card.show(con, "setting_menu");
			ms.getJFrame(this);
		}
		else if(e.getSource() == back_to_main1){ //޴ ư
			card.show(con,"main_menu");
		}
		else if(e.getSource() == back_to_main2){  // ޴ ư
			card.show(con,"main_menu");
		}
		else if(e.getSource() == exit_pr){        // α׷ ϱ
			int answer = JOptionPane.showConfirmDialog(jp_main
					, "Ͻðڽϱ?"
                    , ""
                    , JOptionPane.YES_NO_OPTION);
	
			if (answer==JOptionPane.YES_OPTION) {
				System.exit(0);
			} 
			else if(answer==JOptionPane.NO_OPTION){
				setVisible(true);
				
			}
		}
	}
	

}
public class ManageMent{
	public static void main(String [] args){
		
		try{                        //    
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		}catch(Exception ee){}
	
		Management_Sub es = new Management_Sub();
		es.setVisible(true);
	}
}
