﻿/* foo_me2day : me2api support classes

Never contain any obfuscated/encrypted strings. :-)

Licensed under zlib/libpng license.

Copyright (c) 2007 Shin Jong hun (LunApapa, http://me2day.net/lunapapa)

Feel free to email me: luna.jetch _at_ gmail.com

This software is provided 'as-is', without any express or implied
warranty. In no event will the authors be held liable for any damages
arising from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not
claim that you wrote the original software. If you use this software
in a product, an acknowledgment in the product documentation would be
appreciated but is not required.

2. Altered source versions must be plainly marked as such, and must not be
misrepresented as being the original software.

3. This notice may not be removed or altered from any source
distribution.

*/

#include <time.h>
#include <process.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <atlbase.h>

#include "foo_me2day.h"
#include "foo_me2day_webconn.h"
#include "md5.h"

#include "foo_me2day_me2api_supportor.h"
#include "foo_me2day_preferences.h"

int me2api_supportor::url_encode (const char *src, char *dest, int src_len, int dest_len) {
	int dest_pos = 0;

	// dest_len은 반드시 src_len 보다 커야함.
	if (src_len >= dest_len) {
		return -1;
	}

	for (int i = 0; i < src_len; i++) {
		switch (*(src+i)) {
			case '!':
				memcpy ((dest+dest_pos), "%21", sizeof (char) * 3);
				dest_pos = dest_pos + (sizeof (char) * 3);
				break;
			case '#':
				memcpy ((dest+dest_pos), "%23", sizeof (char) * 3);
				dest_pos = dest_pos + (sizeof (char) * 3);
				break;
			case '$':
				memcpy ((dest+dest_pos), "%24", sizeof (char) * 3);
				dest_pos = dest_pos + (sizeof (char) * 3);
				break;
			case '%':
				memcpy ((dest+dest_pos), "%25", sizeof (char) * 3);
				dest_pos = dest_pos + (sizeof (char) * 3);
				break;
			case '&':
				memcpy ((dest+dest_pos), "%26", sizeof (char) * 3);
				dest_pos = dest_pos + (sizeof (char) * 3);
				break;
			case '\'':
				memcpy ((dest+dest_pos), "%27", sizeof (char) * 3);
				dest_pos = dest_pos + (sizeof (char) * 3);
				break;
			case '(':
				memcpy ((dest+dest_pos), "%28", sizeof (char) * 3);
				dest_pos = dest_pos + (sizeof (char) * 3);
				break;
			case ')':
				memcpy ((dest+dest_pos), "%29", sizeof (char) * 3);
				dest_pos = dest_pos + (sizeof (char) * 3);
				break;
			case '*':
				memcpy ((dest+dest_pos), "%2A", sizeof (char) * 3);
				dest_pos = dest_pos + (sizeof (char) * 3);
				break;
			case '+':
				memcpy ((dest+dest_pos), "%2B", sizeof (char) * 3);
				dest_pos = dest_pos + (sizeof (char) * 3);
				break;
			case ',':
				memcpy ((dest+dest_pos), "%2C", sizeof (char) * 3);
				dest_pos = dest_pos + (sizeof (char) * 3);
				break;
			case '/':
				memcpy ((dest+dest_pos), "%2F", sizeof (char) * 3);
				dest_pos = dest_pos + (sizeof (char) * 3);
				break;
			case ':':
				memcpy ((dest+dest_pos), "%3A", sizeof (char) * 3);
				dest_pos = dest_pos + (sizeof (char) * 3);
				break;
			case ';':
				memcpy ((dest+dest_pos), "%3B", sizeof (char) * 3);
				dest_pos = dest_pos + (sizeof (char) * 3);
				break;
			case '=':
				memcpy ((dest+dest_pos), "%3D", sizeof (char) * 3);
				dest_pos = dest_pos + (sizeof (char) * 3);
				break;
			case '?':
				memcpy ((dest+dest_pos), "%3F", sizeof (char) * 3);
				dest_pos = dest_pos + (sizeof (char) * 3);
				break;
			case '@':
				memcpy ((dest+dest_pos), "%40", sizeof (char) * 3);
				dest_pos = dest_pos + (sizeof (char) * 3);
				break;
			case '[':
				memcpy ((dest+dest_pos), "%5B", sizeof (char) * 3);
				dest_pos = dest_pos + (sizeof (char) * 3);
				break;
			case '\\':
				memcpy ((dest+dest_pos), "%5C", sizeof (char) * 3);
				dest_pos = dest_pos + (sizeof (char) * 3);
				break;
			case ']':
				memcpy ((dest+dest_pos), "%5D", sizeof (char) * 3);
				dest_pos = dest_pos + (sizeof (char) * 3);
				break;
			default:
				memcpy ((dest+dest_pos), (src+i), sizeof (char));
				dest_pos++;
				break;
		}
	}

	return 0;
}

/* base64 encoder. HTTP Basic Auth 인증을 위해 사용된다.
* input {
dst : encoding된 base64 코드가 들어갈 버퍼 (null-terminated 문자열 리턴)
src : USERNAME:PASSWORD 형태의 리터럴. (non-null terminated 상관 없음)
len : 리터럴의 길이.
}
* output : 없음
*/
void me2api_supportor::base64_encode(char *dst, const char *src, unsigned int len)
{

	char base64_table[] = {"ABCDEFGHIJKLMNOPQRSTUVWXYZ""abcdefghijklmnopqrstuvwxyz""0123456789+/"};
	unsigned int x, y = 0, i, flag=0, m=0;
	unsigned int n = 3;
	char triple[3], quad[4];
	static char encode[1024]={0};
	const int MAXLINE = 76;				// base64 encoder를 위한 길이제한 상수

	for(x = 0; x < len; x = x + 3)
	{
		if((len - x) / 3 == 0) n = (len - x) % 3;

		for(i=0; i < 3; i++) triple[i] = '0';
		for(i=0; i < n; i++) triple[i] = src[x + i];
		quad[0] = base64_table[(triple[0] & 0xFC) >> 2]; // FC = 11111100
		quad[1] = base64_table[((triple[0] & 0x03) << 4) | ((triple[1] & 0xF0) >> 4)]; // 03 = 11
		quad[2] = base64_table[((triple[1] & 0x0F) << 2) | ((triple[2] & 0xC0) >> 6)]; // 0F = 1111, C0=11110
		quad[3] = base64_table[triple[2] & 0x3F]; // 3F = 111111
		if(n < 3) quad[3] = '=';
		if(n < 2) quad[2] = '=';
		for(i=0; i < 4; i++) dst[y + i] = quad[i];
		y = y + 4;
		m = m + 4;
		if((m != 0)&&((m % MAXLINE) == 0))
		{
			dst[y] = '\r';
			dst[y+1] = '\n';
			flag++;
			y += 2;
			m = 0;
		}
	}
	dst[y] = '\0';

	return;
} 

/* description:
	nonce 코드 생성루틴 : 16진수(0~f)로 구성된 8자리 문자열을 리턴.
*/
const char * me2api_supportor::get_nonce () {
	time_t nTime;
	int i = 0;
	static char nOnce[9];
	memset (nOnce, 0, sizeof(char) * 9);

	time (&nTime);
	srand ((unsigned int) nTime);

	_snprintf_s (nOnce, 9, _TRUNCATE, "%04x%04x", rand(), rand());

	return nOnce;
}

/* description :
*	nonce+(MD5(nonce+사용자키)) 형태의 코드를 생성하는 루틴.
*	m_nOnce, m_me2userkey 의 값을 가져온 뒤 최종 결과를 m_auth에 넣는다.
*
* Output : 정상 종료시 0 리턴.
*/
int me2api_supportor::authcode_gen() {
	md5_state_t state;
	md5_byte_t digest[16];
	char md5[32+1] = "";
	char temp[16+1] = "";
	int di;

	char tmp_nonce[9];
	memset (tmp_nonce, 0, sizeof (char) * 9);

	_snprintf_s (tmp_nonce, 9, 9, "%s", get_nonce());

	_snprintf_s (temp, 17, 17, "%s%s", tmp_nonce, (const char *) get_me2day_userkey());

	md5_init (&state);
	md5_append (&state, (const md5_byte_t *)temp, 16);
	md5_finish (&state, digest);

	for (di = 0; di < 16; ++di)
		_snprintf_s (md5 + di * 2, 33, 2, "%02x", digest[di]);

	_snprintf_s (m_auth, 44, _TRUNCATE, "%s%s", tmp_nonce, md5);

	return 0;
}

/* base64 encoded 값을 얻는 메서드: HTTP basic Auth에 사용됨 */
int me2api_supportor::make_authentication() {
	char temp[84];
	memset (temp, 0, sizeof (char) * 84);

	// generate authcode, now.
	authcode_gen ();

	_snprintf_s (temp, 84, _TRUNCATE, "%s:%s", (const char *) get_me2day_id(), m_auth);

	base64_encode (m_b64ed_auth, temp, (unsigned int) strlen (temp));

	return 0;
}

// 전송할 음악 설명을 입력하기 위한 public interface.
void me2api_supportor::set_trackinfo (const char *desc, int length) {
	if (length <= 0)
		return;

	char tmp[512];
	memset (tmp, 0, sizeof (char) * 512);

	if (0 == url_encode (desc, tmp, length, 512)) {
		// 설명 쓰기
		_snprintf_s (m_trackinfo, 510, _TRUNCATE, "description=%s", tmp);
		m_trackinfo_set = true;
	}	

	return;
}

/* 구성된 트랙 정보를 me2day로 쏘는 함수
*
* Output : 정상 완료시 0 리턴
*/
int me2api_supportor::send_description (bool thread_wait, DWORD limit_msec) {
	if ((false == get_plugin_enabled()) || (false == m_trackinfo_set))
		return -1;

	char *buff = (char *) malloc (sizeof(char) * 1280);
	memset (buff, 0, sizeof (char) * 1280);

	_snprintf_s (buff, 1280, _TRUNCATE, "POST /api/set_description/%s.xml HTTP/1.0\r\n"
		"Host: me2day.net\r\nAuthorization: Basic %s\r\n"
		"User-Agent: foo_me2day/1.0\r\n"
		"me2_application_key: 7953ab6b5824a031e1e199ebbb37648c\r\n"
		"Content-Length: %d\r\n"
		"Content-Type: application/x-www-form-urlencoded\r\n\r\n"
		"%s\r\n",
		(const char *) get_me2day_id(), m_b64ed_auth, strlen(m_trackinfo), m_trackinfo);

	/* Call SendThread(), Don't Wait him. */
	HANDLE handle;
	handle = (HANDLE) _beginthread (SendThread, 0, buff);
	
	if (true == thread_wait) {
		WaitForSingleObject (handle, limit_msec);
	}

	return 0;
}

// Just One-shot(TM) calling convention for title_grabber class.
void me2api_supportor::call_me (const char *desc, int length, bool thread_wait, DWORD limit_msec) {
	int i = length;
	const char *data = (const char *) desc;

	set_trackinfo (data, i);
	make_authentication ();
	send_description (thread_wait, limit_msec);

	return;
}