/*
 * Decompiled with CFR 0.152.
 */
package org.archi.tools.excatj.expr;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.BooleanType;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.Field;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.LongValue;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StackFrame;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.archi.tools.excatj.expr.ExpressionParser;
import org.archi.tools.excatj.expr.ParseException;
import org.archi.tools.excatj.expr.Token;

abstract class LValue {
    protected Value jdiValue;
    static final int STATIC = 0;
    static final int INSTANCE = 1;
    static List primitiveTypeNames = new ArrayList();
    static final int SAME = 0;
    static final int ASSIGNABLE = 1;
    static final int DIFFERENT = 2;

    static {
        primitiveTypeNames.add("boolean");
        primitiveTypeNames.add("byte");
        primitiveTypeNames.add("char");
        primitiveTypeNames.add("short");
        primitiveTypeNames.add("int");
        primitiveTypeNames.add("long");
        primitiveTypeNames.add("float");
        primitiveTypeNames.add("double");
    }

    LValue() {
    }

    abstract Value getValue() throws InvocationException, IncompatibleThreadStateException, InvalidTypeException, ClassNotLoadedException, ParseException;

    abstract void setValue0(Value var1) throws ParseException, InvalidTypeException, ClassNotLoadedException;

    abstract void invokeWith(List var1) throws ParseException;

    void setValue(Value value) throws ParseException {
        try {
            this.setValue0(value);
        }
        catch (InvalidTypeException exc) {
            throw new ParseException("Attempt to set value of incorrect type" + exc);
        }
        catch (ClassNotLoadedException exc) {
            throw new ParseException("Attempt to set value before " + exc.className() + " was loaded" + exc);
        }
    }

    void setValue(LValue lval) throws ParseException {
        this.setValue(lval.interiorGetValue());
    }

    LValue memberLValue(ExpressionParser.GetFrame frameGetter, String fieldName) throws ParseException {
        try {
            return this.memberLValue(fieldName, frameGetter.get().thread());
        }
        catch (IncompatibleThreadStateException exc) {
            throw new ParseException("Thread not suspended");
        }
    }

    LValue memberLValue(String fieldName, ThreadReference thread) throws ParseException {
        Value val = this.interiorGetValue();
        if (val instanceof ArrayReference && "length".equals(fieldName)) {
            return new LValueArrayLength((ArrayReference)val);
        }
        return new LValueInstanceMember(val, fieldName, thread);
    }

    Value getMassagedValue(ExpressionParser.GetFrame frameGetter) throws ParseException {
        Value vv = this.interiorGetValue();
        if (vv instanceof ObjectReference && !(vv instanceof StringReference) && !(vv instanceof ArrayReference)) {
            StackFrame frame;
            try {
                frame = frameGetter.get();
            }
            catch (IncompatibleThreadStateException exc) {
                throw new ParseException("Thread not suspended");
            }
            ThreadReference thread = frame.thread();
            LValue toStringMember = this.memberLValue("toString", thread);
            toStringMember.invokeWith(new ArrayList());
            return toStringMember.interiorGetValue();
        }
        return vv;
    }

    Value interiorGetValue() throws ParseException {
        Value value;
        try {
            value = this.getValue();
        }
        catch (InvocationException e) {
            throw new ParseException("Unable to complete expression. Exception " + e.exception() + " thrown");
        }
        catch (IncompatibleThreadStateException itse) {
            throw new ParseException("Unable to complete expression. Thread not suspended for method invoke");
        }
        catch (InvalidTypeException ite) {
            throw new ParseException("Unable to complete expression. Method argument type mismatch");
        }
        catch (ClassNotLoadedException tnle) {
            throw new ParseException("Unable to complete expression. Method argument type " + tnle.className() + " not yet loaded");
        }
        return value;
    }

    LValue arrayElementLValue(LValue lval) throws ParseException {
        Value indexValue = lval.interiorGetValue();
        if (!(indexValue instanceof IntegerValue || indexValue instanceof ShortValue || indexValue instanceof ByteValue || indexValue instanceof CharValue)) {
            throw new ParseException("Array index must be a integer type");
        }
        int index = ((PrimitiveValue)indexValue).intValue();
        return new LValueArrayElement(this.interiorGetValue(), index);
    }

    public String toString() {
        try {
            return this.interiorGetValue().toString();
        }
        catch (ParseException e) {
            return "<Parse Exception>";
        }
    }

    static Field fieldByName(ReferenceType refType, String name, int kind) {
        Field field = refType.fieldByName(name);
        if (field != null) {
            boolean isStatic = field.isStatic();
            if (kind == 0 && !isStatic || kind == 1 && isStatic) {
                field = null;
            }
        }
        return field;
    }

    static List methodsByName(ReferenceType refType, String name, int kind) {
        List<Method> list = refType.methodsByName(name);
        Iterator<Method> iter = list.iterator();
        while (iter.hasNext()) {
            Method method = iter.next();
            boolean isStatic = method.isStatic();
            if ((kind != 0 || isStatic) && (kind != 1 || !isStatic)) continue;
            iter.remove();
        }
        return list;
    }

    static int argumentsMatch(List argTypes, List arguments) {
        if (argTypes.size() != arguments.size()) {
            return 2;
        }
        Iterator typeIter = argTypes.iterator();
        Iterator valIter = arguments.iterator();
        int result = 0;
        while (typeIter.hasNext()) {
            Type argType = (Type)typeIter.next();
            Value value = (Value)valIter.next();
            if (value == null && primitiveTypeNames.contains(argType.name())) {
                return 2;
            }
            if (value.type().equals(argType)) continue;
            if (LValue.isAssignableTo(value.type(), argType)) {
                result = 1;
                continue;
            }
            return 2;
        }
        return result;
    }

    static boolean isComponentAssignable(Type fromType, Type toType) {
        if (fromType instanceof PrimitiveType) {
            return fromType.equals(toType);
        }
        if (toType instanceof PrimitiveType) {
            return false;
        }
        return LValue.isAssignableTo(fromType, toType);
    }

    static boolean isArrayAssignableTo(ArrayType fromType, Type toType) {
        if (toType instanceof ArrayType) {
            try {
                Type toComponentType = ((ArrayType)toType).componentType();
                return LValue.isComponentAssignable(fromType.componentType(), toComponentType);
            }
            catch (ClassNotLoadedException e) {
                return false;
            }
        }
        if (toType instanceof InterfaceType) {
            return toType.name().equals("java.lang.Cloneable");
        }
        return toType.name().equals("java.lang.Object");
    }

    static boolean isAssignableTo(Type fromType, Type toType) {
        List<InterfaceType> interfaces;
        if (fromType.equals(toType)) {
            return true;
        }
        if (fromType instanceof BooleanType) {
            return toType instanceof BooleanType;
        }
        if (toType instanceof BooleanType) {
            return false;
        }
        if (fromType instanceof PrimitiveType) {
            return toType instanceof PrimitiveType;
        }
        if (toType instanceof PrimitiveType) {
            return false;
        }
        if (fromType instanceof ArrayType) {
            return LValue.isArrayAssignableTo((ArrayType)fromType, toType);
        }
        if (fromType instanceof ClassType) {
            ClassType superclazz = ((ClassType)fromType).superclass();
            if (superclazz != null && LValue.isAssignableTo(superclazz, toType)) {
                return true;
            }
            interfaces = ((ClassType)fromType).interfaces();
        } else {
            interfaces = ((InterfaceType)fromType).superinterfaces();
        }
        for (InterfaceType interfaze : interfaces) {
            if (!LValue.isAssignableTo(interfaze, toType)) continue;
            return true;
        }
        return false;
    }

    static Method resolveOverload(List overloads, List arguments) throws ParseException {
        if (overloads.size() == 1) {
            return (Method)overloads.get(0);
        }
        Iterator iter = overloads.iterator();
        Method retVal = null;
        int assignableCount = 0;
        while (iter.hasNext()) {
            List<Type> argTypes;
            Method mm = (Method)iter.next();
            try {
                argTypes = mm.argumentTypes();
            }
            catch (ClassNotLoadedException ee) {
                continue;
            }
            int compare = LValue.argumentsMatch(argTypes, arguments);
            if (compare == 0) {
                return mm;
            }
            if (compare == 2) continue;
            retVal = mm;
            ++assignableCount;
        }
        if (retVal != null) {
            if (assignableCount == 1) {
                return retVal;
            }
            throw new ParseException("Arguments match multiple methods");
        }
        throw new ParseException("Arguments match no method");
    }

    static LValue make(VirtualMachine vm, boolean val) {
        return new LValueConstant(vm.mirrorOf(val));
    }

    static LValue make(VirtualMachine vm, byte val) {
        return new LValueConstant(vm.mirrorOf(val));
    }

    static LValue make(VirtualMachine vm, char val) {
        return new LValueConstant(vm.mirrorOf(val));
    }

    static LValue make(VirtualMachine vm, short val) {
        return new LValueConstant(vm.mirrorOf(val));
    }

    static LValue make(VirtualMachine vm, int val) {
        return new LValueConstant(vm.mirrorOf(val));
    }

    static LValue make(VirtualMachine vm, long val) {
        return new LValueConstant(vm.mirrorOf(val));
    }

    static LValue make(VirtualMachine vm, float val) {
        return new LValueConstant(vm.mirrorOf(val));
    }

    static LValue make(VirtualMachine vm, double val) {
        return new LValueConstant(vm.mirrorOf(val));
    }

    static LValue make(VirtualMachine vm, String val) throws ParseException {
        return new LValueConstant(vm.mirrorOf(val));
    }

    static LValue makeBoolean(VirtualMachine vm, Token token) {
        return LValue.make(vm, token.image.charAt(0) == 't');
    }

    static LValue makeCharacter(VirtualMachine vm, Token token) {
        return LValue.make(vm, token.image.charAt(1));
    }

    static LValue makeFloat(VirtualMachine vm, Token token) {
        return LValue.make(vm, Float.valueOf(token.image).floatValue());
    }

    static LValue makeDouble(VirtualMachine vm, Token token) {
        return LValue.make(vm, Double.valueOf(token.image));
    }

    static LValue makeInteger(VirtualMachine vm, Token token) {
        return LValue.make(vm, Integer.parseInt(token.image));
    }

    static LValue makeShort(VirtualMachine vm, Token token) {
        return LValue.make(vm, Short.parseShort(token.image));
    }

    static LValue makeLong(VirtualMachine vm, Token token) {
        return LValue.make(vm, Long.parseLong(token.image));
    }

    static LValue makeByte(VirtualMachine vm, Token token) {
        return LValue.make(vm, Byte.parseByte(token.image));
    }

    static LValue makeString(VirtualMachine vm, Token token) throws ParseException {
        int len = token.image.length();
        return LValue.make(vm, token.image.substring(1, len - 1));
    }

    static LValue makeNull(VirtualMachine vm, Token token) throws ParseException {
        return new LValueConstant(null);
    }

    static LValue makeThisObject(VirtualMachine vm, ExpressionParser.GetFrame frameGetter, Token token) throws ParseException {
        if (frameGetter == null) {
            throw new ParseException("No current thread");
        }
        try {
            StackFrame frame = frameGetter.get();
            ObjectReference thisObject = frame.thisObject();
            if (thisObject == null) {
                throw new ParseException("No 'this'.  In native or static method");
            }
            return new LValueConstant(thisObject);
        }
        catch (IncompatibleThreadStateException exc) {
            throw new ParseException("Thread not suspended");
        }
    }

    static LValue makeNewObject(VirtualMachine vm, ExpressionParser.GetFrame frameGetter, String className, List arguments) throws ParseException {
        ObjectReference newObject;
        List<ReferenceType> classes = vm.classesByName(className);
        if (classes.size() == 0) {
            throw new ParseException("No class named: " + className);
        }
        if (classes.size() > 1) {
            throw new ParseException("More than one class named: " + className);
        }
        ReferenceType refType = classes.get(0);
        if (!(refType instanceof ClassType)) {
            throw new ParseException("Cannot create instance of interface " + className);
        }
        ClassType classType = (ClassType)refType;
        ArrayList<Method> methods = new ArrayList<Method>(classType.methods());
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            Method method = (Method)iter.next();
            if (method.isConstructor()) continue;
            iter.remove();
        }
        Method constructor = LValue.resolveOverload(methods, arguments);
        try {
            ThreadReference thread = frameGetter.get().thread();
            newObject = classType.newInstance(thread, constructor, arguments, 0);
        }
        catch (InvocationException ie) {
            throw new ParseException("Exception in " + className + " constructor: " + ie.exception().referenceType().name());
        }
        catch (IncompatibleThreadStateException exc) {
            throw new ParseException("Thread not suspended");
        }
        catch (Exception e) {
            throw new ParseException("Unable to create " + className + " instance");
        }
        return new LValueConstant(newObject);
    }

    private static LValue nFields(LValue lval, StringTokenizer izer, ThreadReference thread) throws ParseException {
        if (!izer.hasMoreTokens()) {
            return lval;
        }
        return LValue.nFields(lval.memberLValue(izer.nextToken(), thread), izer, thread);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static LValue makeName(VirtualMachine vm, ExpressionParser.GetFrame frameGetter, String name) throws ParseException {
        StringTokenizer izer = new StringTokenizer(name, ".");
        String first = izer.nextToken();
        if (frameGetter == null) throw new ParseException("Name unknown: " + name);
        try {
            LocalVariable var;
            StackFrame frame = frameGetter.get();
            ThreadReference thread = frame.thread();
            try {
                var = frame.visibleVariableByName(first);
            }
            catch (AbsentInformationException e) {
                var = null;
            }
            if (var != null) {
                return LValue.nFields(new LValueLocal(frame, var), izer, thread);
            }
            ObjectReference thisObject = frame.thisObject();
            if (thisObject != null) {
                LValue fv;
                LValueConstant thisLValue = new LValueConstant(thisObject);
                try {
                    fv = thisLValue.memberLValue(first, thread);
                }
                catch (ParseException exc) {
                    fv = null;
                }
                if (fv != null) {
                    return LValue.nFields(fv, izer, thread);
                }
            }
            while (true) {
                if (!izer.hasMoreTokens()) {
                    throw new ParseException("Name unknown: " + name);
                }
                List<ReferenceType> classes = vm.classesByName(first);
                if (classes.size() > 0) {
                    if (classes.size() > 1) {
                        throw new ParseException("More than one class named: " + first);
                    }
                    ReferenceType refType = classes.get(0);
                    LValueStaticMember lval = new LValueStaticMember(refType, izer.nextToken(), thread);
                    return LValue.nFields(lval, izer, thread);
                }
                first = String.valueOf(first) + '.' + izer.nextToken();
            }
        }
        catch (IncompatibleThreadStateException exc) {
            throw new ParseException("Thread not suspended");
        }
    }

    static String stringValue(LValue lval, ExpressionParser.GetFrame frameGetter) throws ParseException {
        Value val = lval.getMassagedValue(frameGetter);
        if (val == null) {
            return "null";
        }
        if (val instanceof StringReference) {
            return ((StringReference)val).value();
        }
        return val.toString();
    }

    static LValue booleanOperation(VirtualMachine vm, Token token, LValue rightL, LValue leftL) throws ParseException {
        boolean res;
        String op = token.image;
        Value right = rightL.interiorGetValue();
        Value left = leftL.interiorGetValue();
        if (!(right instanceof PrimitiveValue) || !(left instanceof PrimitiveValue)) {
            if (op.equals("==")) {
                return LValue.make(vm, right.equals(left));
            }
            if (op.equals("!=")) {
                return LValue.make(vm, !right.equals(left));
            }
            throw new ParseException("Operands or '" + op + "' must be primitive");
        }
        double rr = ((PrimitiveValue)right).doubleValue();
        double ll = ((PrimitiveValue)left).doubleValue();
        if (op.equals("<")) {
            res = rr < ll;
        } else if (op.equals(">")) {
            res = rr > ll;
        } else if (op.equals("<=")) {
            res = rr <= ll;
        } else if (op.equals(">=")) {
            res = rr >= ll;
        } else if (op.equals("==")) {
            res = rr == ll;
        } else if (op.equals("!=")) {
            res = rr != ll;
        } else {
            throw new ParseException("Unknown operation: " + op);
        }
        return LValue.make(vm, res);
    }

    static LValue operation(VirtualMachine vm, Token token, LValue rightL, LValue leftL, ExpressionParser.GetFrame frameGetter) throws ParseException {
        int res;
        String op = token.image;
        Value right = rightL.interiorGetValue();
        Value left = leftL.interiorGetValue();
        if ((right instanceof StringReference || left instanceof StringReference) && op.equals("+")) {
            return LValue.make(vm, String.valueOf(LValue.stringValue(rightL, frameGetter)) + LValue.stringValue(leftL, frameGetter));
        }
        if (right instanceof ObjectReference || left instanceof ObjectReference) {
            if (op.equals("==")) {
                return LValue.make(vm, right.equals(left));
            }
            if (op.equals("!=")) {
                return LValue.make(vm, !right.equals(left));
            }
            throw new ParseException("Invalid operation '" + op + "' on an Object");
        }
        if (right instanceof BooleanValue || left instanceof BooleanValue) {
            throw new ParseException("Invalid operation '" + op + "' on a Boolean");
        }
        PrimitiveValue primRight = (PrimitiveValue)right;
        PrimitiveValue primLeft = (PrimitiveValue)left;
        if (primRight instanceof DoubleValue || primLeft instanceof DoubleValue) {
            double res2;
            double rr = primRight.doubleValue();
            double ll = primLeft.doubleValue();
            if (op.equals("+")) {
                res2 = rr + ll;
            } else if (op.equals("-")) {
                res2 = rr - ll;
            } else if (op.equals("*")) {
                res2 = rr * ll;
            } else if (op.equals("/")) {
                res2 = rr / ll;
            } else {
                throw new ParseException("Unknown operation: " + op);
            }
            return LValue.make(vm, res2);
        }
        if (primRight instanceof FloatValue || primLeft instanceof FloatValue) {
            float res3;
            float rr = primRight.floatValue();
            float ll = primLeft.floatValue();
            if (op.equals("+")) {
                res3 = rr + ll;
            } else if (op.equals("-")) {
                res3 = rr - ll;
            } else if (op.equals("*")) {
                res3 = rr * ll;
            } else if (op.equals("/")) {
                res3 = rr / ll;
            } else {
                throw new ParseException("Unknown operation: " + op);
            }
            return LValue.make(vm, res3);
        }
        if (primRight instanceof LongValue || primLeft instanceof LongValue) {
            long res4;
            long rr = primRight.longValue();
            long ll = primLeft.longValue();
            if (op.equals("+")) {
                res4 = rr + ll;
            } else if (op.equals("-")) {
                res4 = rr - ll;
            } else if (op.equals("*")) {
                res4 = rr * ll;
            } else if (op.equals("/")) {
                res4 = rr / ll;
            } else {
                throw new ParseException("Unknown operation: " + op);
            }
            return LValue.make(vm, res4);
        }
        int rr = primRight.intValue();
        int ll = primLeft.intValue();
        if (op.equals("+")) {
            res = rr + ll;
        } else if (op.equals("-")) {
            res = rr - ll;
        } else if (op.equals("*")) {
            res = rr * ll;
        } else if (op.equals("/")) {
            res = rr / ll;
        } else {
            throw new ParseException("Unknown operation: " + op);
        }
        return LValue.make(vm, res);
    }

    private static class LValueArrayElement
    extends LValue {
        final ArrayReference array;
        final int index;

        LValueArrayElement(Value value, int index) throws ParseException {
            if (!(value instanceof ArrayReference)) {
                throw new ParseException("Must be array type: " + value);
            }
            this.array = (ArrayReference)value;
            this.index = index;
        }

        Value getValue() {
            if (this.jdiValue == null) {
                this.jdiValue = this.array.getValue(this.index);
            }
            return this.jdiValue;
        }

        void setValue0(Value val) throws InvalidTypeException, ClassNotLoadedException {
            this.array.setValue(this.index, val);
            this.jdiValue = val;
        }

        void invokeWith(List arguments) throws ParseException {
            throw new ParseException("Array element is not a method");
        }
    }

    private static class LValueArrayLength
    extends LValue {
        final ArrayReference arrayRef;

        LValueArrayLength(ArrayReference value) {
            this.arrayRef = value;
        }

        Value getValue() {
            if (this.jdiValue == null) {
                this.jdiValue = this.arrayRef.virtualMachine().mirrorOf(this.arrayRef.length());
            }
            return this.jdiValue;
        }

        void setValue0(Value value) throws ParseException {
            throw new ParseException("Cannot set constant: " + value);
        }

        void invokeWith(List arguments) throws ParseException {
            throw new ParseException("Array element is not a method");
        }
    }

    private static class LValueConstant
    extends LValue {
        final Value value;

        LValueConstant(Value value) {
            this.value = value;
        }

        Value getValue() {
            if (this.jdiValue == null) {
                this.jdiValue = this.value;
            }
            return this.jdiValue;
        }

        void setValue0(Value val) throws ParseException {
            throw new ParseException("Cannot set constant: " + this.value);
        }

        void invokeWith(List arguments) throws ParseException {
            throw new ParseException("Constant is not a method");
        }
    }

    private static class LValueInstanceMember
    extends LValue {
        final ObjectReference obj;
        final ThreadReference thread;
        final Field matchingField;
        final List overloads;
        Method matchingMethod = null;
        List methodArguments = null;

        LValueInstanceMember(Value value, String memberName, ThreadReference thread) throws ParseException {
            if (!(value instanceof ObjectReference)) {
                throw new ParseException("Cannot access field of primitive type: " + value);
            }
            this.obj = (ObjectReference)value;
            this.thread = thread;
            ReferenceType refType = this.obj.referenceType();
            this.matchingField = LValue.fieldByName(refType, memberName, 1);
            this.overloads = LValue.methodsByName(refType, memberName, 1);
            if (this.matchingField == null && this.overloads.size() == 0) {
                throw new ParseException("No instance field or method with the name " + memberName + " in " + refType.name());
            }
        }

        Value getValue() throws InvocationException, InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, ParseException {
            if (this.jdiValue != null) {
                return this.jdiValue;
            }
            if (this.matchingMethod == null) {
                if (this.matchingField == null) {
                    throw new ParseException("No such field in " + this.obj.referenceType().name());
                }
                this.jdiValue = this.obj.getValue(this.matchingField);
                return this.jdiValue;
            }
            this.jdiValue = this.obj.invokeMethod(this.thread, this.matchingMethod, this.methodArguments, 0);
            return this.jdiValue;
        }

        void setValue0(Value val) throws ParseException, InvalidTypeException, ClassNotLoadedException {
            if (this.matchingMethod != null) {
                throw new ParseException("Cannot assign to a method invocation");
            }
            this.obj.setValue(this.matchingField, val);
            this.jdiValue = val;
        }

        void invokeWith(List arguments) throws ParseException {
            if (this.matchingMethod != null) {
                throw new ParseException("Invalid consecutive invocations");
            }
            this.methodArguments = arguments;
            this.matchingMethod = LValue.resolveOverload(this.overloads, arguments);
        }
    }

    private static class LValueLocal
    extends LValue {
        final StackFrame frame;
        final LocalVariable var;

        LValueLocal(StackFrame frame, LocalVariable var) {
            this.frame = frame;
            this.var = var;
        }

        Value getValue() {
            if (this.jdiValue == null) {
                this.jdiValue = this.frame.getValue(this.var);
            }
            return this.jdiValue;
        }

        void setValue0(Value val) throws InvalidTypeException, ClassNotLoadedException {
            this.frame.setValue(this.var, val);
            this.jdiValue = val;
        }

        void invokeWith(List arguments) throws ParseException {
            throw new ParseException(String.valueOf(this.var.name()) + " is not a method");
        }
    }

    private static class LValueStaticMember
    extends LValue {
        final ReferenceType refType;
        final ThreadReference thread;
        final Field matchingField;
        final List overloads;
        Method matchingMethod = null;
        List methodArguments = null;

        LValueStaticMember(ReferenceType refType, String memberName, ThreadReference thread) throws ParseException {
            this.refType = refType;
            this.thread = thread;
            this.matchingField = LValue.fieldByName(refType, memberName, 0);
            this.overloads = LValue.methodsByName(refType, memberName, 0);
            if (this.matchingField == null && this.overloads.size() == 0) {
                throw new ParseException("No static field or method with the name " + memberName + " in " + refType.name());
            }
        }

        Value getValue() throws InvocationException, InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, ParseException {
            if (this.jdiValue != null) {
                return this.jdiValue;
            }
            if (this.matchingMethod == null) {
                this.jdiValue = this.refType.getValue(this.matchingField);
                return this.jdiValue;
            }
            if (this.refType instanceof ClassType) {
                ClassType clazz = (ClassType)this.refType;
                this.jdiValue = clazz.invokeMethod(this.thread, this.matchingMethod, this.methodArguments, 0);
                return this.jdiValue;
            }
            throw new InvalidTypeException("Cannot invoke static method on " + this.refType.name());
        }

        void setValue0(Value val) throws ParseException, InvalidTypeException, ClassNotLoadedException {
            if (this.matchingMethod != null) {
                throw new ParseException("Cannot assign to a method invocation");
            }
            if (!(this.refType instanceof ClassType)) {
                throw new ParseException("Cannot set interface field: " + this.refType);
            }
            ((ClassType)this.refType).setValue(this.matchingField, val);
            this.jdiValue = val;
        }

        void invokeWith(List arguments) throws ParseException {
            if (this.matchingMethod != null) {
                throw new ParseException("Invalid consecutive invocations");
            }
            this.methodArguments = arguments;
            this.matchingMethod = LValue.resolveOverload(this.overloads, arguments);
        }
    }
}

