/*
 * Decompiled with CFR 0.152.
 */
package org.archi.tools.excatj.eventspec;

import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.ExceptionRequest;
import java.util.ArrayList;
import org.archi.tools.excatj.Env;
import org.archi.tools.excatj.MessageOutput;
import org.archi.tools.excatj.eventspec.PatternReferenceTypeSpec;
import org.archi.tools.excatj.eventspec.ReferenceTypeSpec;
import org.archi.tools.excatj.exception.VMNotConnectedException;

public abstract class EventRequestSpec {
    final ReferenceTypeSpec refSpec;
    public int suspendPolicy = 2;
    EventRequest resolved = null;
    ClassPrepareRequest prepareRequest = null;

    public EventRequestSpec(ReferenceTypeSpec refSpec) {
        this.refSpec = refSpec;
    }

    public abstract EventRequest resolveEventRequest(ReferenceType var1) throws Exception;

    public synchronized EventRequest resolve(ClassPrepareEvent event) throws Exception {
        if (this.resolved == null && this.prepareRequest != null && this.prepareRequest.equals(event.request())) {
            PatternReferenceTypeSpec prs;
            this.resolved = this.resolveEventRequest(event.referenceType());
            this.prepareRequest.disable();
            Env.vm().eventRequestManager().deleteEventRequest(this.prepareRequest);
            this.prepareRequest = null;
            if (this.refSpec instanceof PatternReferenceTypeSpec && !(prs = (PatternReferenceTypeSpec)this.refSpec).isUnique()) {
                this.resolved = null;
                this.prepareRequest = this.refSpec.createPrepareRequest();
                this.prepareRequest.enable();
            }
        }
        return this.resolved;
    }

    public synchronized void remove() {
        PatternReferenceTypeSpec prs;
        if (this.isResolved()) {
            Env.vm().eventRequestManager().deleteEventRequest(this.resolved());
        }
        if (this.refSpec instanceof PatternReferenceTypeSpec && !(prs = (PatternReferenceTypeSpec)this.refSpec).isUnique()) {
            ArrayList<ExceptionRequest> deleteList = new ArrayList<ExceptionRequest>();
            for (ExceptionRequest er : Env.vm().eventRequestManager().exceptionRequests()) {
                if (!prs.matches(er.exception())) continue;
                deleteList.add(er);
            }
            Env.vm().eventRequestManager().deleteEventRequests(deleteList);
        }
    }

    private EventRequest resolveAgainstPreparedClasses() throws Exception {
        for (ReferenceType refType : Env.vm().allClasses()) {
            if (!refType.isPrepared() || !this.refSpec.matches(refType)) continue;
            this.resolved = this.resolveEventRequest(refType);
        }
        return this.resolved;
    }

    public synchronized EventRequest resolveEagerly() throws Exception {
        try {
            PatternReferenceTypeSpec prs;
            if (this.resolved == null) {
                this.prepareRequest = this.refSpec.createPrepareRequest();
                this.prepareRequest.enable();
                this.resolveAgainstPreparedClasses();
                if (this.resolved != null) {
                    this.prepareRequest.disable();
                    Env.vm().eventRequestManager().deleteEventRequest(this.prepareRequest);
                    this.prepareRequest = null;
                }
            }
            if (this.refSpec instanceof PatternReferenceTypeSpec && !(prs = (PatternReferenceTypeSpec)this.refSpec).isUnique()) {
                this.resolved = null;
                if (this.prepareRequest == null) {
                    this.prepareRequest = this.refSpec.createPrepareRequest();
                    this.prepareRequest.enable();
                }
            }
        }
        catch (VMNotConnectedException vMNotConnectedException) {
            // empty catch block
        }
        return this.resolved;
    }

    public EventRequest resolved() {
        return this.resolved;
    }

    public boolean isResolved() {
        return this.resolved != null;
    }

    protected boolean isJavaIdentifier(String s) {
        if (s.length() == 0) {
            return false;
        }
        int cp = s.codePointAt(0);
        if (!Character.isJavaIdentifierStart(cp)) {
            return false;
        }
        int i = Character.charCount(cp);
        while (i < s.length()) {
            cp = s.codePointAt(i);
            if (!Character.isJavaIdentifierPart(cp)) {
                return false;
            }
            i += Character.charCount(cp);
        }
        return true;
    }

    public String errorMessageFor(Exception e) {
        if (e instanceof IllegalArgumentException) {
            return MessageOutput.format("Invalid command syntax");
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        return MessageOutput.format("Internal error; unable to set", this.refSpec.toString());
    }
}

