/*
 * Decompiled with CFR 0.152.
 */
package org.archi.tools.excatj;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InvocationException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.Mirror;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.WatchpointEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import org.archi.tools.excatj.Env;
import org.archi.tools.excatj.MessageOutput;
import org.archi.tools.excatj.ThreadInfo;
import org.archi.tools.excatj.TraceOutput;
import org.archi.tools.excatj.expr.ExpressionParser;
import org.archi.tools.excatj.expr.ParseException;

class ThreadTrace {
    static final String threadDelta = "                     ";
    final TraceOutput appTraceLog;
    final String baseIndent;
    final boolean dumpObject = false;
    StringBuffer indent;
    final int catchDepth;
    final ThreadReference thread;
    static int execepCount = 0;

    public ThreadTrace(ThreadReference thread, String nextBaseIndent, TraceOutput appTraceLog) {
        this.thread = thread;
        this.baseIndent = nextBaseIndent;
        this.appTraceLog = appTraceLog;
        this.indent = new StringBuffer(this.baseIndent);
        nextBaseIndent = String.valueOf(nextBaseIndent) + threadDelta;
        this.catchDepth = Env.getCatchDepth();
    }

    void breakpointEvent(BreakpointEvent event) {
        MessageOutput.printDevTrace("breakpointEvent(BreakpointEvent event) called");
        this.printCurrentVariables(event);
    }

    /*
     * Unable to fully structure code
     */
    void doPrint(StringTokenizer t, boolean dumpObject) {
        if (t.hasMoreTokens()) ** GOTO lbl19
        this.println("No objects specified.");
        return;
lbl-1000:
        // 1 sources

        {
            expr = t.nextToken("");
            val = this.evaluate(expr);
            if (val == null) {
                this.println("expr is null", expr.toString());
                continue;
            }
            if (dumpObject && val instanceof ObjectReference && !(val instanceof StringReference)) {
                obj = (ObjectReference)val;
                refType = obj.referenceType();
                this.println("expr is value", new Object[]{expr.toString(), MessageOutput.format("grouping begin character")});
                this.dump(obj, refType, refType);
                this.println("grouping end character", "");
                continue;
            }
            strVal = this.getStringValue();
            if (strVal == null) continue;
            this.println("expr is value", new Object[]{expr.toString(), strVal});
lbl19:
            // 5 sources

            ** while (t.hasMoreTokens())
        }
lbl20:
        // 1 sources

    }

    private void dump(ObjectReference obj, ReferenceType refType, ReferenceType refTypeBase) {
        Iterator<Mirror> it;
        Iterator<Field> it2 = refType.fields().iterator();
        while (it2.hasNext()) {
            StringBuffer o = new StringBuffer();
            Field field = it2.next();
            o.append("    ");
            if (!refType.equals(refTypeBase)) {
                o.append(refType.name());
                o.append(".");
            }
            o.append(field.name());
            o.append(MessageOutput.format("colon space"));
            o.append(obj.getValue(field));
            this.println(o.toString());
        }
        if (refType instanceof ClassType) {
            ClassType sup = ((ClassType)refType).superclass();
            if (sup != null) {
                this.dump(obj, sup, refTypeBase);
            }
        } else if (refType instanceof InterfaceType) {
            List<InterfaceType> sups = ((InterfaceType)refType).superinterfaces();
            it = sups.iterator();
            while (it.hasNext()) {
                this.dump(obj, (ReferenceType)it.next(), refTypeBase);
            }
        } else if (obj instanceof ArrayReference) {
            StringBuffer out = new StringBuffer();
            it = ((ArrayReference)obj).getValues().iterator();
            while (it.hasNext()) {
                out.append(((Object)it.next()).toString());
                if (!it.hasNext()) continue;
                out.append(", ");
            }
            this.println(out.toString());
        }
    }

    private void dumpFrame(int frameNumber, boolean showPC, StackFrame frame) {
        Location loc = frame.location();
        long pc = -1L;
        if (showPC) {
            pc = loc.codeIndex();
        }
        Method meth = loc.method();
        long lineNumber = loc.lineNumber();
        String methodInfo = null;
        if (meth instanceof Method && meth.isNative()) {
            methodInfo = MessageOutput.format("native method");
        } else if (lineNumber != -1L) {
            try {
                methodInfo = String.valueOf(loc.sourceName()) + MessageOutput.format("line number", new Object[]{new Long(lineNumber)});
            }
            catch (AbsentInformationException e) {
                methodInfo = MessageOutput.format("unknown");
            }
        }
        if (pc != -1L) {
            this.println("stack frame dump with pc", new Object[]{new Integer(frameNumber + 1), meth.declaringType().name(), meth.name(), methodInfo, new Long(pc)});
        } else {
            this.println("stack frame dump", new Object[]{new Integer(frameNumber + 1), meth.declaringType().name(), meth.name(), methodInfo});
        }
    }

    private void dumpStack(ThreadInfo threadInfo, boolean showPC) {
        List stack = null;
        try {
            stack = threadInfo.getStack();
        }
        catch (IncompatibleThreadStateException e) {
            this.println("Current thread isnt suspended.");
            return;
        }
        if (stack == null) {
            this.println("Thread is not running (no stack).");
        } else {
            int nFrames = stack.size();
            int i = threadInfo.getCurrentFrameIndex();
            while (i < nFrames) {
                StackFrame frame = (StackFrame)stack.get(i);
                this.dumpFrame(i, showPC, frame);
                ++i;
            }
        }
    }

    private Value evaluate(String expr) {
        Value result = null;
        ExpressionParser.GetFrame frameGetter = null;
        try {
            final ThreadInfo threadInfo = ThreadInfo.getCurrentThreadInfo();
            if (threadInfo != null && threadInfo.getCurrentFrame() != null) {
                frameGetter = new ExpressionParser.GetFrame(){

                    public StackFrame get() throws IncompatibleThreadStateException {
                        return threadInfo.getCurrentFrame();
                    }
                };
            }
            result = ExpressionParser.evaluate(expr, Env.vm(), frameGetter);
        }
        catch (InvocationException ie) {
            this.println("Exception in expression:", ie.exception().referenceType().name());
        }
        catch (Exception ex) {
            String s;
            String exMessage = ex.getMessage();
            if (exMessage == null) {
                MessageOutput.printException(exMessage, ex);
            }
            try {
                s = MessageOutput.format(exMessage);
            }
            catch (MissingResourceException mex) {
                s = ex.toString();
            }
            MessageOutput.printDirectln(s);
        }
        return result;
    }

    void exceptionEvent(ExceptionEvent event) {
        MessageOutput.printDevTrace("exceptionEvent(ExceptionEvent event) called");
        ++execepCount;
        if (event.thread().isSuspended()) {
            this.println("");
            this.println("");
            this.println("/******************************************************");
            this.println(" * Exception: " + event.exception());
            this.println("     location   : " + event.location());
            this.println("     catch loc. : " + event.catchLocation());
            this.println("     thread name: " + this.thread.name());
            this.println(" ******************************************************/");
            this.printCurrentVariables(event);
        } else {
            MessageOutput.printDevTrace(String.valueOf(this.thread.name()) + " is not suspended");
        }
    }

    void fieldWatchEvent(WatchpointEvent event) {
    }

    private String getStringValue() {
        Value val = null;
        String valStr = null;
        try {
            val = ExpressionParser.getMassagedValue();
            valStr = val.toString();
        }
        catch (ParseException e) {
            String s;
            String msg = e.getMessage();
            if (msg == null) {
                MessageOutput.printException(msg, e);
            }
            try {
                s = MessageOutput.format(msg);
            }
            catch (MissingResourceException mex) {
                s = e.toString();
            }
            MessageOutput.printDevTrace(s);
        }
        return valStr;
    }

    public void methodEntryEvent(MethodEntryEvent event) {
        MessageOutput.printDevTrace("methodEntryEvent(MethodEntryEvent event)");
        this.println(String.valueOf(event.method().name()) + "  --  " + event.method().declaringType().name());
        this.indent.append("| ");
    }

    public void methodExitEvent(MethodExitEvent event) {
        MessageOutput.printDevTrace("methodExitEvent(MethodExitEvent event)");
        if (this.indent.length() > 2) {
            this.indent.setLength(this.indent.length() - 2);
        }
    }

    private void printCurrentVariables(LocatableEvent event) {
        StringBuffer oldIndent = new StringBuffer(this.indent);
        ThreadInfo threadInfo = ThreadInfo.getCurrentThreadInfo();
        if (threadInfo == null) {
            MessageOutput.println("No default thread specified:");
            return;
        }
        try {
            try {
                int nLevel = event.thread().frameCount() - 1;
                if (nLevel >= this.catchDepth - 1) {
                    nLevel = this.catchDepth - 1;
                }
                while (nLevel >= 0) {
                    threadInfo.setCurrentFrameIndex(nLevel);
                    StackFrame frame = threadInfo.getCurrentFrame();
                    this.println("");
                    this.println("**** " + frame.location().method().name() + " in " + frame.location().sourceName() + ":" + frame.location().lineNumber() + " ****");
                    this.printFields(frame);
                    this.printLocals(frame);
                    this.indent.append("| ");
                    --nLevel;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.indent = new StringBuffer(oldIndent);
            }
        }
        finally {
            this.indent = new StringBuffer(oldIndent);
        }
    }

    private void printFields(StackFrame frame) {
        StringBuffer oldIndent = new StringBuffer(this.indent);
        try {
            List<Field> fieldList = frame.thisObject().referenceType().visibleFields();
            if (fieldList.size() == 0) {
                this.println("* No field variables");
                return;
            }
            try {
                this.println("* Fields");
                this.indent.append("  ");
                for (Field field : fieldList) {
                    Value value = frame.thisObject().getValue(field);
                    this.printVar(field.name(), value, frame);
                }
            }
            catch (Exception e) {
                this.println("* Field information not available");
            }
        }
        finally {
            this.indent = new StringBuffer(oldIndent);
        }
    }

    private void println(String str) {
        this.appTraceLog.printDirectln(this.indent + str);
    }

    private void println(String key, Object[] arguments) {
        this.appTraceLog.printDirectln(this.indent + this.appTraceLog.format(key, arguments));
    }

    private void println(String key, String argument) {
        this.appTraceLog.printDirectln(this.indent + this.appTraceLog.format(key, argument));
    }

    private void printLocals(StackFrame frame) {
        ThreadInfo threadInfo = ThreadInfo.getCurrentThreadInfo();
        StringBuffer oldIndent = new StringBuffer(this.indent);
        if (threadInfo == null) {
            MessageOutput.println("No default thread specified:");
            return;
        }
        try {
            frame = threadInfo.getCurrentFrame();
            if (frame == null) {
                throw new AbsentInformationException();
            }
            List<LocalVariable> vars = frame.visibleVariables();
            if (vars.size() == 0) {
                this.println("* No local variables/method arguments");
                return;
            }
            try {
                Value val;
                Map<LocalVariable, Value> values = frame.getValues(vars);
                this.println("* Method arguments");
                this.indent.append("  ");
                for (LocalVariable var : vars) {
                    if (!var.isArgument()) continue;
                    val = values.get(var);
                    this.printVar(var.name(), val, frame);
                }
                this.indent = new StringBuffer(oldIndent);
                this.println("* Local variables");
                this.indent.append("  ");
                for (LocalVariable var : vars) {
                    if (var.isArgument()) continue;
                    val = values.get(var);
                    this.printVar(var.name(), val, frame);
                }
            }
            catch (AbsentInformationException aie) {
                this.println("* Local variable information not available.");
            }
            catch (IncompatibleThreadStateException exc) {
                this.println("Current thread isnt suspended.");
            }
        }
        finally {
            this.indent = new StringBuffer(oldIndent);
        }
    }

    private void printVar(final String name, Value value, StackFrame frame) {
        try {
            if (value instanceof PrimitiveValue || value instanceof StringReference) {
                this.println("expr is value", new Object[]{name, value.toString()});
            } else {
                new AsyncExecution(){

                    void action() {
                        ThreadTrace.this.doPrint(new StringTokenizer(name), true);
                    }
                };
            }
        }
        catch (Exception e) {
            this.println("expr is NA", name);
        }
    }

    void threadDeathEvent(ThreadDeathEvent event) {
        this.indent = new StringBuffer(this.baseIndent);
        this.println("====== " + this.thread.name() + " end ======");
    }

    abstract class AsyncExecution {
        abstract void action();

        AsyncExecution() {
            this.execute();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void execute() {
            ThreadInfo threadInfo = ThreadInfo.getCurrentThreadInfo();
            int stackFrame = threadInfo == null ? 0 : threadInfo.getCurrentFrameIndex();
            try {
                this.action();
            }
            catch (UnsupportedOperationException uoe) {
                MessageOutput.println("Operation is not supported on the target VM");
                if (threadInfo == null) return;
                ThreadInfo.setCurrentThreadInfo(threadInfo);
                try {
                    threadInfo.setCurrentFrameIndex(stackFrame);
                    return;
                }
                catch (IncompatibleThreadStateException e) {
                    MessageOutput.println("Current thread isnt suspended.");
                    return;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    MessageOutput.println("Requested stack frame is no longer active:", new Object[]{new Integer(stackFrame)});
                }
                return;
            }
            catch (Exception e) {
                try {
                    MessageOutput.println("Internal exception during operation:", e.getMessage());
                    if (threadInfo == null) return;
                }
                catch (Throwable throwable) {
                    if (threadInfo == null) throw throwable;
                    ThreadInfo.setCurrentThreadInfo(threadInfo);
                    try {
                        threadInfo.setCurrentFrameIndex(stackFrame);
                        throw throwable;
                    }
                    catch (IncompatibleThreadStateException e2) {
                        MessageOutput.println("Current thread isnt suspended.");
                        throw throwable;
                    }
                    catch (ArrayIndexOutOfBoundsException e3) {
                        MessageOutput.println("Requested stack frame is no longer active:", new Object[]{new Integer(stackFrame)});
                    }
                    throw throwable;
                }
                ThreadInfo.setCurrentThreadInfo(threadInfo);
                try {
                    threadInfo.setCurrentFrameIndex(stackFrame);
                    return;
                }
                catch (IncompatibleThreadStateException e4) {
                    MessageOutput.println("Current thread isnt suspended.");
                    return;
                }
                catch (ArrayIndexOutOfBoundsException e5) {
                    MessageOutput.println("Requested stack frame is no longer active:", new Object[]{new Integer(stackFrame)});
                }
                return;
            }
            if (threadInfo == null) return;
            ThreadInfo.setCurrentThreadInfo(threadInfo);
            try {
                threadInfo.setCurrentFrameIndex(stackFrame);
                return;
            }
            catch (IncompatibleThreadStateException e) {
                MessageOutput.println("Current thread isnt suspended.");
                return;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                MessageOutput.println("Requested stack frame is no longer active:", new Object[]{new Integer(stackFrame)});
            }
        }
    }
}

