/*
 * Decompiled with CFR 0.152.
 */
package org.archi.tools.excatj;

import com.sun.jdi.ThreadGroupReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.archi.tools.excatj.Env;

class ThreadGroupIterator
implements Iterator {
    private final Stack stack = new Stack();

    ThreadGroupIterator(List tgl) {
        this.push(tgl);
    }

    ThreadGroupIterator(ThreadGroupReference tg) {
        ArrayList<ThreadGroupReference> tgl = new ArrayList<ThreadGroupReference>();
        tgl.add(tg);
        this.push(tgl);
    }

    ThreadGroupIterator() {
        this(Env.vm().topLevelThreadGroups());
    }

    private Iterator top() {
        return (Iterator)this.stack.peek();
    }

    private void push(List tgl) {
        this.stack.push(tgl.iterator());
        while (!this.stack.isEmpty() && !this.top().hasNext()) {
            this.stack.pop();
        }
    }

    public boolean hasNext() {
        return !this.stack.isEmpty();
    }

    public Object next() {
        return this.nextThreadGroup();
    }

    public ThreadGroupReference nextThreadGroup() {
        ThreadGroupReference tg = (ThreadGroupReference)this.top().next();
        this.push(tg.threadGroups());
        return tg;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    static ThreadGroupReference find(String name) {
        ThreadGroupIterator tgi = new ThreadGroupIterator();
        while (tgi.hasNext()) {
            ThreadGroupReference tg = tgi.nextThreadGroup();
            if (!tg.name().equals(name)) continue;
            return tg;
        }
        return null;
    }
}

