/*
 * Decompiled with CFR 0.152.
 */
package org.archi.tools.excatj;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import org.archi.tools.excatj.Env;

public class TextOutput {
    private StringBuffer strBuf = new StringBuffer();
    private Logger logger;
    static ResourceBundle textResources;
    private static MessageFormat messageFormat;

    private Logger getLogger() {
        return this.logger;
    }

    public TextOutput(String loggerName) {
        this.logger = Logger.getLogger((String)loggerName);
        textResources = ResourceBundle.getBundle("org.archi.tools.excatj.TTYResources", Locale.getDefault());
    }

    private void error(Object message) {
        this.getLogger().error(message);
    }

    private void fatal(Object message) {
        this.getLogger().fatal(message);
    }

    public void fatalError(String messageKey) {
        this.getLogger().fatal((Object)"");
        this.getLogger().fatal((Object)this.format("Fatal error"));
        this.getLogger().fatal((Object)this.format(messageKey));
        Env.shutdown();
    }

    public void printDevTrace(String line) {
        this.getLogger().trace((Object)line);
    }

    public String format(String key) {
        return textResources.getString(key);
    }

    public String format(String key, String argument) {
        return this.format(key, new Object[]{argument});
    }

    public synchronized String format(String key, Object[] arguments) {
        if (messageFormat == null) {
            messageFormat = new MessageFormat(textResources.getString(key));
        } else {
            messageFormat.applyPattern(textResources.getString(key));
        }
        return messageFormat.format(arguments);
    }

    public void printDirectln(String line) {
        this.getLogger().info((Object)(this.strBuf + line));
        this.strBuf = new StringBuffer();
    }

    public void printDirectln(Object message) {
        this.getLogger().info((Object)(this.strBuf + message.toString()));
        this.strBuf = new StringBuffer();
    }

    public void printDirect(String line) {
        this.strBuf.append(line);
    }

    public void printDirect(char c) {
        this.printDirectln(Character.valueOf(c));
    }

    public void println() {
        this.printDirectln("");
    }

    public void print(String key) {
        this.printDirect(this.format(key));
    }

    public void println(String key) {
        this.printDirectln(this.format(key));
    }

    public void print(String key, String argument) {
        this.printDirect(this.format(key, argument));
    }

    public void println(String key, String argument) {
        this.printDirectln(this.format(key, argument));
    }

    public void println(String key, Object[] arguments) {
        this.printDirectln(this.format(key, arguments));
    }

    public void lnprint(String key) {
        this.println();
        this.printDirect(textResources.getString(key));
    }

    public void lnprint(String key, String argument) {
        this.println();
        this.print(key, argument);
    }

    public void lnprint(String key, Object[] arguments) {
        this.println();
        this.println(key, arguments);
    }

    public void printException(String key, Exception e) {
        if (key != null) {
            try {
                this.printDirectln(key);
            }
            catch (MissingResourceException mex) {
                this.printDirectln(key);
            }
        }
        System.out.flush();
        e.printStackTrace();
    }
}

