/*
 * Decompiled with CFR 0.152.
 */
package org.archi.tools.excatj;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.VMCannotBeModifiedException;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.connect.Connector;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import org.archi.tools.excatj.ApplicationTrace;
import org.archi.tools.excatj.Commands;
import org.archi.tools.excatj.Env;
import org.archi.tools.excatj.EventHandler;
import org.archi.tools.excatj.MessageOutput;
import org.archi.tools.excatj.exception.VMNotConnectedException;

public class ExCatJ {
    EventHandler handler = null;
    static final String progname = "ExCatJ";
    static final String author = "Yi, Chai-Sung";
    static final int majorVersion = 0;
    static final int minorVersion = 3;
    private static final String[][] commandList = new String[][]{{"!!", "n", "y"}, {"?", "y", "y"}, {"bytecodes", "n", "y"}, {"catch", "y", "n"}, {"catchdepth", "y", "n"}, {"class", "n", "y"}, {"classes", "n", "y"}, {"classpath", "n", "y"}, {"clear", "y", "n"}, {"connectors", "y", "y"}, {"cont", "n", "n"}, {"disablegc", "n", "n"}, {"down", "n", "y"}, {"dump", "n", "y"}, {"enablegc", "n", "n"}, {"eval", "n", "y"}, {"exclude", "y", "n"}, {"exit", "y", "y"}, {"extension", "n", "y"}, {"fields", "n", "y"}, {"gc", "n", "n"}, {"help", "y", "y"}, {"ignore", "y", "n"}, {"interrupt", "n", "n"}, {"kill", "n", "n"}, {"lines", "n", "y"}, {"list", "n", "y"}, {"load", "n", "y"}, {"locals", "n", "y"}, {"lock", "n", "n"}, {"memory", "n", "y"}, {"methods", "n", "y"}, {"monitor", "n", "n"}, {"next", "n", "n"}, {"pop", "n", "n"}, {"print", "n", "y"}, {"quit", "y", "y"}, {"read", "y", "y"}, {"redefine", "n", "n"}, {"reenter", "n", "n"}, {"resume", "n", "n"}, {"run", "y", "n"}, {"save", "n", "n"}, {"set", "n", "n"}, {"sourcepath", "y", "y"}, {"step", "n", "n"}, {"stepi", "n", "n"}, {"stop", "y", "n"}, {"suspend", "n", "n"}, {"thread", "n", "y"}, {"threadgroup", "n", "y"}, {"threadgroups", "n", "y"}, {"threadlocks", "n", "y"}, {"threads", "n", "y"}, {"trace", "n", "n"}, {"unmonitor", "n", "n"}, {"untrace", "n", "n"}, {"unwatch", "y", "n"}, {"up", "n", "y"}, {"use", "y", "y"}, {"version", "y", "y"}, {"watch", "y", "n"}, {"where", "n", "y"}, {"wherei", "n", "y"}};

    void help() {
        MessageOutput.println("zz help text");
    }

    private int isCommand(String key) {
        int low = 0;
        int high = commandList.length - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            String midVal = commandList[mid][0];
            int compare = midVal.compareTo(key);
            if (compare < 0) {
                low = mid + 1;
                continue;
            }
            if (compare > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private boolean isDisconnectCmd(int ii) {
        if (ii < 0 || ii >= commandList.length) {
            return false;
        }
        return commandList[ii][1].equals("y");
    }

    private boolean isReadOnlyCmd(int ii) {
        if (ii < 0 || ii >= commandList.length) {
            return false;
        }
        return commandList[ii][2].equals("y");
    }

    void executeCommand(StringTokenizer t) {
        String cmd = t.nextToken().toLowerCase();
        Commands evaluator = new Commands();
        boolean showPrompt = true;
        if (Character.isDigit(cmd.charAt(0)) && t.hasMoreTokens()) {
            try {
                int repeat = Integer.parseInt(cmd);
                String subcom = t.nextToken("");
                while (repeat-- > 0) {
                    this.executeCommand(new StringTokenizer(subcom));
                    showPrompt = false;
                }
            }
            catch (NumberFormatException exc) {
                MessageOutput.println("Unrecognized command.  Try help...", cmd);
            }
        } else {
            int commandNumber = this.isCommand(cmd);
            if (commandNumber < 0) {
                MessageOutput.println("Unrecognized command.  Try help...", cmd);
            } else if (!Env.connection().isOpen() && !this.isDisconnectCmd(commandNumber)) {
                MessageOutput.println("Command not valid until the VM is started with the run command", cmd);
            } else if (Env.connection().isOpen() && !Env.vm().canBeModified() && !this.isReadOnlyCmd(commandNumber)) {
                MessageOutput.println("Command is not supported on a read-only VM connection", cmd);
            } else {
                try {
                    if (cmd.equals("print")) {
                        evaluator.commandPrint(t, false);
                        showPrompt = false;
                    } else if (cmd.equals("eval")) {
                        evaluator.commandPrint(t, false);
                        showPrompt = false;
                    } else if (cmd.equals("set")) {
                        evaluator.commandSet(t);
                        showPrompt = false;
                    } else if (cmd.equals("dump")) {
                        evaluator.commandPrint(t, true);
                        showPrompt = false;
                    } else if (cmd.equals("locals")) {
                        evaluator.commandLocals();
                    } else if (cmd.equals("classes")) {
                        evaluator.commandClasses();
                    } else if (cmd.equals("class")) {
                        evaluator.commandClass(t);
                    } else if (cmd.equals("connectors")) {
                        evaluator.commandConnectors(Bootstrap.virtualMachineManager());
                    } else if (cmd.equals("methods")) {
                        evaluator.commandMethods(t);
                    } else if (cmd.equals("fields")) {
                        evaluator.commandFields(t);
                    } else if (cmd.equals("threads")) {
                        evaluator.commandThreads(t);
                    } else if (cmd.equals("thread")) {
                        evaluator.commandThread(t);
                    } else if (cmd.equals("suspend")) {
                        evaluator.commandSuspend(t);
                    } else if (cmd.equals("resume")) {
                        evaluator.commandResume(t);
                    } else if (cmd.equals("cont")) {
                        evaluator.commandCont();
                    } else if (cmd.equals("threadgroups")) {
                        evaluator.commandThreadGroups();
                    } else if (cmd.equals("threadgroup")) {
                        evaluator.commandThreadGroup(t);
                    } else if (cmd.equals("catch")) {
                        evaluator.commandCatchException(t);
                    } else if (cmd.equals("ignore")) {
                        evaluator.commandIgnoreException(t);
                    } else if (cmd.equals("stepi")) {
                        evaluator.commandStepi();
                    } else if (cmd.equals("kill")) {
                        evaluator.commandKill(t);
                    } else if (cmd.equals("interrupt")) {
                        evaluator.commandInterrupt(t);
                    } else if (cmd.equals("trace")) {
                        evaluator.commandTrace(t);
                    } else if (cmd.equals("untrace")) {
                        evaluator.commandUntrace(t);
                    } else if (cmd.equals("load")) {
                        evaluator.commandLoad(t);
                    } else if (cmd.equals("run")) {
                        evaluator.commandRun(t);
                        if (this.handler == null && Env.connection().isOpen()) {
                            this.handler = new EventHandler(new ApplicationTrace(), false);
                        }
                    } else if (cmd.equals("stop")) {
                        evaluator.commandStop(t);
                    } else if (cmd.equals("clear")) {
                        evaluator.commandClear(t);
                    } else if (cmd.equals("watch")) {
                        evaluator.commandWatch(t);
                    } else if (cmd.equals("unwatch")) {
                        evaluator.commandUnwatch(t);
                    } else if (cmd.equals("list")) {
                        evaluator.commandList(t);
                    } else if (cmd.equals("lines")) {
                        evaluator.commandLines(t);
                    } else if (cmd.equals("classpath")) {
                        evaluator.commandClasspath(t);
                    } else if (cmd.equals("use") || cmd.equals("sourcepath")) {
                        evaluator.commandUse(t);
                    } else if (cmd.equals("lock")) {
                        evaluator.commandLock(t);
                        showPrompt = false;
                    } else if (cmd.equals("threadlocks")) {
                        evaluator.commandThreadlocks(t);
                    } else if (cmd.equals("disablegc")) {
                        evaluator.commandDisableGC(t);
                        showPrompt = false;
                    } else if (cmd.equals("enablegc")) {
                        evaluator.commandEnableGC(t);
                        showPrompt = false;
                    } else if (cmd.equals("save")) {
                        evaluator.commandSave(t);
                        showPrompt = false;
                    } else if (cmd.equals("bytecodes")) {
                        evaluator.commandBytecodes(t);
                    } else if (cmd.equals("redefine")) {
                        evaluator.commandRedefine(t);
                    } else if (cmd.equals("pop")) {
                        evaluator.commandPopFrames(t, false);
                    } else if (cmd.equals("reenter")) {
                        evaluator.commandPopFrames(t, true);
                    } else if (cmd.equals("extension")) {
                        evaluator.commandExtension(t);
                    } else if (cmd.equals("exclude")) {
                        evaluator.commandExclude(t);
                    } else if (cmd.equals("read")) {
                        this.readCommand(t);
                    } else if (cmd.equals("help") || cmd.equals("?")) {
                        this.help();
                    } else if (cmd.equals("version")) {
                        evaluator.commandVersion(progname, Bootstrap.virtualMachineManager());
                    } else if (cmd.equals("quit") || cmd.equals("exit")) {
                        if (this.handler != null) {
                            this.handler.shutdown();
                        }
                        Env.shutdown();
                    } else {
                        MessageOutput.println("Unrecognized command.  Try help...", cmd);
                    }
                }
                catch (VMCannotBeModifiedException rovm) {
                    MessageOutput.println("Command is not supported on a read-only VM connection", cmd);
                }
                catch (UnsupportedOperationException uoe) {
                    MessageOutput.println("Command is not supported on the target VM", cmd);
                }
                catch (VMNotConnectedException vmnse) {
                    MessageOutput.println("Command not valid until the VM is started with the run command", cmd);
                }
                catch (Exception e) {
                    MessageOutput.printException("Internal exception:", e);
                }
            }
        }
        if (showPrompt) {
            MessageOutput.printPrompt();
        }
    }

    void readCommand(StringTokenizer t) {
        if (t.hasMoreTokens()) {
            String cmdfname = t.nextToken();
            if (!this.readCommandFile(cmdfname)) {
                MessageOutput.println("Could not open:", cmdfname);
            }
        } else {
            MessageOutput.println("Usage: read <command-filename>");
        }
    }

    boolean readCommandFile(String filename) {
        BufferedReader inFile;
        block16: {
            File f = new File(filename);
            inFile = null;
            try {
                try {
                    if (f.canRead()) {
                        String ln;
                        MessageOutput.println("*** Reading commands from", f.getCanonicalPath());
                        inFile = new BufferedReader(new FileReader(f));
                        while ((ln = inFile.readLine()) != null) {
                            StringTokenizer t = new StringTokenizer(ln);
                            if (!t.hasMoreTokens()) continue;
                            this.executeCommand(t);
                        }
                    }
                }
                catch (IOException iOException) {
                    if (inFile != null) {
                        try {
                            inFile.close();
                        }
                        catch (Exception exception) {}
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (inFile != null) {
                    try {
                        inFile.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (inFile != null) {
                try {
                    inFile.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return inFile != null;
    }

    public ExCatJ() throws Exception {
        MessageOutput.println("Initializing progname", progname);
        try {
            if (Env.connection().isOpen()) {
                this.handler = new EventHandler(new ApplicationTrace(), false);
                this.executeCommand(new StringTokenizer("read excatj.properties"));
                while (!this.handler.completed) {
                    Thread.yield();
                }
            }
        }
        catch (VMDisconnectedException e) {
            this.handler.handleDisconnectedException();
        }
    }

    private static void usage() {
        MessageOutput.println("zz usage text", new Object[]{progname, File.pathSeparator});
        System.exit(1);
    }

    static void usageError(String messageKey) {
        MessageOutput.println(messageKey);
        MessageOutput.println();
        ExCatJ.usage();
    }

    static void usageError(String messageKey, String argument) {
        MessageOutput.println(messageKey, argument);
        MessageOutput.println();
        ExCatJ.usage();
    }

    private static Connector findConnector(String transportName, List availableConnectors) {
        for (Connector connector : availableConnectors) {
            if (!connector.transport().name().equals(transportName)) continue;
            return connector;
        }
        throw new IllegalArgumentException(MessageOutput.format("Invalid transport name:", transportName));
    }

    private static String addressToSocketArgs(String address) {
        int index = address.indexOf(58);
        if (index != -1) {
            String hostString = address.substring(0, index);
            String portString = address.substring(index + 1);
            return "hostname=" + hostString + ",port=" + portString;
        }
        return "port=" + address;
    }

    private static boolean hasWhitespace(String string) {
        int length = string.length();
        int i = 0;
        while (i < length) {
            if (Character.isWhitespace(string.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static String addArgument(String string, String argument) {
        if (ExCatJ.hasWhitespace(argument) || argument.indexOf(44) != -1) {
            StringBuffer buffer = new StringBuffer(string);
            buffer.append('\"');
            int i = 0;
            while (i < argument.length()) {
                char c = argument.charAt(i);
                if (c == '\"') {
                    buffer.append('\\');
                }
                buffer.append(c);
                ++i;
            }
            buffer.append("\" ");
            return buffer.toString();
        }
        return String.valueOf(string) + argument + ' ';
    }

    private static void printLogo() {
        MessageOutput.println("ExCatJLogo", new Object[]{progname, 0, 3, author});
    }

    public static void main(String[] argv) throws MissingResourceException {
        String cmdLine = "";
        String javaArgs = "";
        int traceFlags = 0;
        boolean launchImmediately = false;
        String connectSpec = null;
        ExCatJ.printLogo();
        int i = 0;
        while (i < argv.length) {
            String token = argv[i];
            if (token.equals("-dbgtrace")) {
                if (i == argv.length - 1 || !Character.isDigit(argv[i + 1].charAt(0))) {
                    traceFlags = 0xFFFFFF;
                } else {
                    String flagStr = "";
                    try {
                        flagStr = argv[++i];
                        traceFlags = Integer.decode(flagStr);
                    }
                    catch (NumberFormatException nfe) {
                        ExCatJ.usageError("dbgtrace flag value must be an integer:", flagStr);
                        return;
                    }
                }
            } else {
                if (token.equals("-X")) {
                    ExCatJ.usageError("Use java minus X to see");
                    return;
                }
                if (token.equals("-v") || token.startsWith("-v:") || token.startsWith("-verbose") || token.startsWith("-D") || token.startsWith("-X") || token.equals("-noasyncgc") || token.equals("-prof") || token.equals("-verify") || token.equals("-noverify") || token.equals("-verifyremote") || token.equals("-verbosegc") || token.startsWith("-ms") || token.startsWith("-mx") || token.startsWith("-ss") || token.startsWith("-oss")) {
                    javaArgs = ExCatJ.addArgument(javaArgs, token);
                } else {
                    String address;
                    if (token.equals("-tclassic")) {
                        ExCatJ.usageError("Classic VM no longer supported.");
                        return;
                    }
                    if (token.equals("-tclient")) {
                        javaArgs = "-client " + javaArgs;
                    } else if (token.equals("-tserver")) {
                        javaArgs = "-server " + javaArgs;
                    } else if (token.equals("-sourcepath")) {
                        if (i == argv.length - 1) {
                            ExCatJ.usageError("No sourcepath specified.");
                            return;
                        }
                        Env.setSourcePath(argv[++i]);
                    } else if (token.equals("-classpath")) {
                        if (i == argv.length - 1) {
                            ExCatJ.usageError("No classpath specified.");
                            return;
                        }
                        javaArgs = ExCatJ.addArgument(javaArgs, token);
                        javaArgs = ExCatJ.addArgument(javaArgs, argv[++i]);
                    } else if (token.equals("-attach")) {
                        if (connectSpec != null) {
                            ExCatJ.usageError("cannot redefine existing connection", token);
                            return;
                        }
                        if (i == argv.length - 1) {
                            ExCatJ.usageError("No attach address specified.");
                            return;
                        }
                        address = argv[++i];
                        String suboptions = ExCatJ.addressToSocketArgs(address);
                        connectSpec = "com.sun.jdi.SocketAttach:" + suboptions;
                    } else if (token.equals("-listen") || token.equals("-listenany")) {
                        if (connectSpec != null) {
                            ExCatJ.usageError("cannot redefine existing connection", token);
                            return;
                        }
                        address = null;
                        if (token.equals("-listen")) {
                            if (i == argv.length - 1) {
                                ExCatJ.usageError("No attach address specified.");
                                return;
                            }
                            address = argv[++i];
                        }
                        connectSpec = "com.sun.jdi.SocketListen:";
                        if (address != null) {
                            connectSpec = String.valueOf(connectSpec) + ExCatJ.addressToSocketArgs(address);
                        }
                    } else if (token.equals("-launch")) {
                        launchImmediately = true;
                    } else {
                        Commands evaluator;
                        if (token.equals("-listconnectors")) {
                            evaluator = new Commands();
                            evaluator.commandConnectors(Bootstrap.virtualMachineManager());
                            return;
                        }
                        if (token.equals("-connect")) {
                            if (connectSpec != null) {
                                ExCatJ.usageError("cannot redefine existing connection", token);
                                return;
                            }
                            if (i == argv.length - 1) {
                                ExCatJ.usageError("No connect specification.");
                                return;
                            }
                            connectSpec = argv[++i];
                        } else if (token.equals("-help")) {
                            ExCatJ.usage();
                        } else {
                            if (!token.equals("-version")) {
                                if (token.startsWith("-")) {
                                    ExCatJ.usageError("invalid option", token);
                                    return;
                                }
                                cmdLine = ExCatJ.addArgument("", token);
                                ++i;
                                while (i < argv.length) {
                                    cmdLine = ExCatJ.addArgument(cmdLine, argv[i]);
                                    ++i;
                                }
                                break;
                            }
                            evaluator = new Commands();
                            evaluator.commandVersion(progname, Bootstrap.virtualMachineManager());
                            System.exit(0);
                        }
                    }
                }
            }
            ++i;
        }
        if (connectSpec == null) {
            connectSpec = "com.sun.jdi.CommandLineLaunch:";
        } else if (!connectSpec.endsWith(",") && !connectSpec.endsWith(":")) {
            connectSpec = String.valueOf(connectSpec) + ",";
        }
        cmdLine = cmdLine.trim();
        javaArgs = javaArgs.trim();
        if (cmdLine.length() > 0) {
            if (!connectSpec.startsWith("com.sun.jdi.CommandLineLaunch:")) {
                ExCatJ.usageError("Cannot specify command line with connector:", connectSpec);
                return;
            }
            connectSpec = String.valueOf(connectSpec) + "main=" + cmdLine + ",";
        }
        if (javaArgs.length() > 0) {
            if (!connectSpec.startsWith("com.sun.jdi.CommandLineLaunch:")) {
                ExCatJ.usageError("Cannot specify target vm arguments with connector:", connectSpec);
                return;
            }
            connectSpec = String.valueOf(connectSpec) + "options=" + javaArgs + ",";
        }
        try {
            if (!connectSpec.endsWith(",")) {
                connectSpec = String.valueOf(connectSpec) + ",";
            }
            Env.init(connectSpec, launchImmediately, traceFlags);
            new ExCatJ();
        }
        catch (Exception e) {
            MessageOutput.printException("Internal exception:", e);
        }
    }
}

