/*
 * Decompiled with CFR 0.152.
 */
package org.archi.tools.excatj;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.request.ExceptionRequest;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import com.sun.jdi.request.StepRequest;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.archi.tools.excatj.MessageOutput;
import org.archi.tools.excatj.SourceMapper;
import org.archi.tools.excatj.VMConnection;
import org.archi.tools.excatj.eventspec.EventRequestSpecList;

public class Env {
    static EventRequestSpecList specList = new EventRequestSpecList();
    private static VMConnection connection;
    private static SourceMapper sourceMapper;
    private static List excludes;
    private static final int SOURCE_CACHE_SIZE = 5;
    private static List sourceCache;
    private static HashMap savedValues;
    private static int exceptionCatchDepth;

    static {
        sourceMapper = new SourceMapper("");
        sourceCache = new LinkedList();
        savedValues = new HashMap();
        exceptionCatchDepth = 3;
    }

    static void init(String connectSpec, boolean openNow, int flags) {
        connection = new VMConnection(connectSpec, flags);
        if (!connection.isLaunch() || openNow) {
            connection.open();
        }
    }

    static VMConnection connection() {
        return connection;
    }

    public static VirtualMachine vm() {
        return connection.vm();
    }

    static void shutdown() {
        Env.shutdown(null);
    }

    static void shutdown(String message) {
        if (connection != null) {
            try {
                connection.disposeVM();
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                // empty catch block
            }
        }
        if (message != null) {
            MessageOutput.lnprint(message);
            MessageOutput.println();
        }
        System.exit(0);
    }

    static void setCatchDepth(int catchDepth) {
        exceptionCatchDepth = catchDepth;
    }

    static int getCatchDepth() {
        return exceptionCatchDepth;
    }

    static void setSourcePath(String srcPath) {
        sourceMapper = new SourceMapper(srcPath);
        sourceCache.clear();
    }

    static void setSourcePath(List srcList) {
        sourceMapper = new SourceMapper(srcList);
        sourceCache.clear();
    }

    static String getSourcePath() {
        return sourceMapper.getSourcePath();
    }

    private static List excludes() {
        if (excludes == null) {
            Env.setExcludes("java.*, javax.*, sun.*, com.sun.*");
        }
        return excludes;
    }

    static String excludesString() {
        Iterator iter = Env.excludes().iterator();
        StringBuffer buffer = new StringBuffer();
        while (iter.hasNext()) {
            String pattern = (String)iter.next();
            buffer.append(pattern);
            buffer.append(",");
        }
        return buffer.toString();
    }

    static void addExcludes(StepRequest request) {
        for (String pattern : Env.excludes()) {
            request.addClassExclusionFilter(pattern);
        }
    }

    static void addExcludes(MethodEntryRequest request) {
        for (String pattern : Env.excludes()) {
            request.addClassExclusionFilter(pattern);
        }
    }

    public static void addExcludes(MethodExitRequest request) {
        for (String pattern : Env.excludes()) {
            request.addClassExclusionFilter(pattern);
        }
    }

    public static void addExcludes(ExceptionRequest request) {
        for (String pattern : Env.excludes()) {
            request.addClassExclusionFilter(pattern);
        }
    }

    static void setExcludes(String excludeString) {
        StringTokenizer t = new StringTokenizer(excludeString, " ,;");
        ArrayList<String> list = new ArrayList<String>();
        while (t.hasMoreTokens()) {
            list.add(t.nextToken());
        }
        excludes = list;
    }

    static BufferedReader sourceReader(Location location) {
        return sourceMapper.sourceReader(location);
    }

    static synchronized String sourceLine(Location location, int lineNumber) throws IOException {
        if (lineNumber == -1) {
            throw new IllegalArgumentException();
        }
        try {
            String fileName = location.sourceName();
            Iterator iter = sourceCache.iterator();
            SourceCode code = null;
            while (iter.hasNext()) {
                SourceCode candidate = (SourceCode)iter.next();
                if (!candidate.fileName().equals(fileName)) continue;
                code = candidate;
                iter.remove();
                break;
            }
            if (code == null) {
                BufferedReader reader = Env.sourceReader(location);
                if (reader == null) {
                    throw new FileNotFoundException(fileName);
                }
                code = new SourceCode(fileName, reader);
                if (sourceCache.size() == 5) {
                    sourceCache.remove(sourceCache.size() - 1);
                }
            }
            sourceCache.add(0, code);
            return code.sourceLine(lineNumber);
        }
        catch (AbsentInformationException e) {
            throw new IllegalArgumentException();
        }
    }

    static String description(ObjectReference ref) {
        ReferenceType clazz = ref.referenceType();
        long id = ref.uniqueID();
        if (clazz == null) {
            return Env.toHex(id);
        }
        return MessageOutput.format("object description and hex id", new Object[]{clazz.name(), Env.toHex(id)});
    }

    static String toHex(long n) {
        char[] s1 = new char[16];
        char[] s2 = new char[18];
        int i = 0;
        do {
            long d = n & 0xFL;
            s1[i++] = (char)(d < 10L ? 48L + d : 97L + d - 10L);
        } while ((n >>>= 4) > 0L);
        s2[0] = 48;
        s2[1] = 120;
        int j = 2;
        while (--i >= 0) {
            s2[j++] = s1[i];
        }
        return new String(s2, 0, j);
    }

    static long fromHex(String hexStr) {
        String str;
        String string = str = hexStr.startsWith("0x") ? hexStr.substring(2).toLowerCase() : hexStr.toLowerCase();
        if (hexStr.length() == 0) {
            throw new NumberFormatException();
        }
        long ret = 0L;
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c >= '0' && c <= '9') {
                ret = ret * 16L + (long)(c - 48);
            } else if (c >= 'a' && c <= 'f') {
                ret = ret * 16L + (long)(c - 97 + 10);
            } else {
                throw new NumberFormatException();
            }
            ++i;
        }
        return ret;
    }

    public static ReferenceType getReferenceTypeFromToken(String idToken) {
        ReferenceType cls = null;
        if (Character.isDigit(idToken.charAt(0))) {
            cls = null;
        } else if (idToken.startsWith("*.")) {
            idToken = idToken.substring(1);
            List<ReferenceType> classes = Env.vm().allClasses();
            for (ReferenceType type : classes) {
                if (!type.name().endsWith(idToken)) continue;
                cls = type;
                break;
            }
        } else {
            List<ReferenceType> classes = Env.vm().classesByName(idToken);
            if (classes.size() > 0) {
                cls = classes.get(0);
            }
        }
        return cls;
    }

    static Set getSaveKeys() {
        return savedValues.keySet();
    }

    static Value getSavedValue(String key) {
        return (Value)savedValues.get(key);
    }

    static void setSavedValue(String key, Value value) {
        savedValues.put(key, value);
    }

    static class SourceCode {
        private String fileName;
        private List sourceLines = new ArrayList();

        SourceCode(String fileName, BufferedReader reader) throws IOException {
            this.fileName = fileName;
            try {
                String line = reader.readLine();
                while (line != null) {
                    this.sourceLines.add(line);
                    line = reader.readLine();
                }
            }
            finally {
                reader.close();
            }
        }

        String fileName() {
            return this.fileName;
        }

        String sourceLine(int number) {
            int index = number - 1;
            if (index >= this.sourceLines.size()) {
                return null;
            }
            return (String)this.sourceLines.get(index);
        }
    }
}

