<?php
/* vim600: et ts=4 sts=4 sw=4 fdm=marker
 *
 * EtchiBBS UTF-8 - Gallery Web Board
 * Copyright (C) 2004 EtchiBoard Project
 * 
 * See LICENSE for license condition.
 *
 * http://etchibbs.kldp.net
 * $Id: confirmbox.php,v 1.2 2004/03/16 05:26:13 lseeker Exp $
 */

/* {{{ ConfirmBox class */
class ConfirmBox extends MessageBox {
    var $action;
    var $page  = NULL;
    var $index = NULL; 
    var $rnum  = NULL;
    var $from  = NULL;

    var $show_input = TRUE;

    function ConfirmBox() {
        $this->title = 'CONFIRM';
        $this->type  = NULL;
    }

    function hidePasswordInput() {
        $this->show_input = FALSE;
    }

    function registerAction($action) {
        $this->action =& $action;
    }

    function registerValues($page, $index, $rnum = NULL) {
        $this->page  = (int) $page;
        $this->index = (int) $index;
        $this->rnum  = (int) $rnum;
    }

    function registerFrom($from) {
        $this->from =& $from;
    }

    function printOut() {
        $this->message .= '</p><p class="center">';

        if ($this->show_input) $this->message .= '<span class="fgSpc1">비밀번호: </span><input type="password" name="password" maxlength="8" size="9" id="ConfirmPassword" /> ';

        $this->message .= '<input type="submit" value="확인" /> <input type="button" value="취소" onclick="history.back(1);" />';

        echo "<form method=\"post\" action=\"{$this->action}\"><div><input type=\"hidden\" name=\"page\" value=\"{$this->page}\" /><input type=\"hidden\" name=\"article\" value=\"{$this->index}\" /><input type=\"hidden\" name=\"num\" value=\"{$this->rnum}\" /><input type=\"hidden\" name=\"from\" value=\"{$this->from}\" /></div>";

        parent::printOut();

        if ($this->show_input) echo "<script type=\"text/javascript\">\n<!--\ndocument.getElementById('ConfirmPassword').focus();\n//-->\n</script>\n";
    }
}
/* }}} */

?>
