<?php
/* vim600: et ts=4 sts=4 sw=4 fdm=marker
 *
 * EtchiBBS UTF-8 - Gallery Web Board
 * Copyright (C) 2004 EtchiBoard Project
 * 
 * See LICENSE for license condition.
 *
 * http://etchibbs.kldp.net
 * $Id: del_article.php,v 1.29 2004/03/23 16:41:36 lseeker Exp $
 */

require 'lib/common.php';
include 'lib/layout.php';
include 'lib/article.php';

$Layout = new Layout($admin_data);
$Layout->hideInclude();

if (isset($_GET['confirm'])) {
    include 'lib/confirmbox.php';

    if (empty($_GET['article'])) error_exit('삭제할 글 번호를 입력해주세요.', TRUE);

    $ConfirmBox = new ConfirmBox;
    $ConfirmBox->registerAction('del_article.php');
    $ConfirmBox->registerValues($_GET['page'], $_GET['article']);

    if ($admin['login']) {
        $ConfirmBox->hidePasswordInput();
        $ConfirmBox->registerMessage(intval($_GET['article']) . '번 게시물을 정말로 삭제하시겠습니까?');
    } else {
        $ConfirmBox->registerMessage('게시물 작성시 넣으셨던 비밀번호를 입력하세요.');
    }

    $Layout->printHeader();
    $ConfirmBox->printOut();
    $Layout->printFooter();
    exit;
}

if (!$admin['login'] && !strcmp($_POST['password'], '')) error_exit('비밀번호가 비어 있습니다.', TRUE);

if (empty($_POST['article'])) error_exit('삭제할 게시물이 지정되지 않았습니다.', TRUE);

$article_no = (int) $_POST['article']; // 역시 메시지 function에서 쓸수있게 변경 -_-

// db 읽어들이기
$Result = new DBResult($DB->query("SELECT passwd, cfile, deleted from hboard_db_article where idx='{$article_no}'"));

if (!$Result->numrows()) error_exit('해당 게시물이 없습니다.', TRUE);

$article =& $Result->fetch();
$Image = new Image('db/img/' . $article['cfile']);
$Result->free();

if ($article['deleted'] == 't') error_exit('이미 삭제된 게시물입니다.', TRUE);

// 받은 비번 공백 날리고 암호화하고.. (털썩)
if (!$admin['login'] && strcmp($article['passwd'], crypt($_POST['password'], $article['passwd']))) error_exit('비밀번호가 올바르지 않습니다.', TRUE);

// 비밀번호가 올바르고 게시물이 지정되었다면... db 처리 *-_-*
ignore_user_abort(TRUE);
$DB->query("UPDATE hboard_db_article SET deleted='t' WHERE idx='{$article_no}'");
$DB->query('UPDATE hboard_db_admin SET app=app+100');
$Image->remove();
$DB->close();

/* completed */
$MessageBox = new MessageBox;
$MessageBox->setTypeList((int) $_POST['page'], $article_no);
$MessageBox->registerTitle('안내');
$MessageBox->registerMessage("{$article_no}번 게시물을 삭제하였습니다.");

$Layout->printHeader();
$MessageBox->printOut();
$Layout->printFooter();

?>
