<?php
/* vim600: et ts=4 sts=4 sw=4 fdm=marker
 *
 * EtchiBBS UTF-8 - Gallery Web Board
 * Copyright (C) 2004 EtchiBoard Project
 * 
 * See LICENSE for license condition.
 *
 * http://etchibbs.kldp.net
 * $Id: post_comment.php,v 1.34 2004/03/23 16:41:36 lseeker Exp $
 */

require 'lib/common.php';
include 'lib/layout.php';

// 공백 처리: ^^+
$name     = &remove_space($_POST['name']);
$homepage = &remove_space($_POST['homepage']);
$email    = &remove_space($_POST['email']);

/* {{{ */
if (get_magic_quotes_gpc()) {
    $name     = stripslashes($name);
    $email    = stripslashes($email);
    $homepage = stripslashes($homepage);
    $icon     = stripslashes($_POST['icon']);
} else {
    $_POST['ne'] = addslashes($_POST['ne']);
    $icon = $_POST['icon'];
}
/* }}} */

if($name == "" || empty($icon) || empty($_POST['ne']) || empty($_POST['passwd'])) error_exit('<b>데이터가 모두 전송되지 않았습니다.</b><br />필요한 폼에 데이터를 모두 채워주세요.', TRUE);

/* 전부 정상이라면.. */
$article_no = (int) $_POST['article']; // 메시지 function을 위한..

/* {{{ 쿠키 설정 */
$c_time = time() + 2592000;
setcookie('etchibbs_name', $name,     $c_time);
setcookie('etchibbs_mail', $email,    $c_time);
setcookie('etchibbs_home', $homepage, $c_time);
if (strcmp($icon, 'none.jpg')) {
    setcookie('etchibbs_icon', $icon, $c_time);
} else {
    setcookie('etchibbs_icon', '');
}
/* }}} */

if(!strcmp($homepage, 'http://')) {
    $homepage = ''; // http://일 경우 홈페이지 비우기
}

mt_srand(microtime() * 1e6);
$salt = chr(mt_rand(0x21, 0x7E)) . chr(mt_rand(0x21, 0x7E));
$passwd = addslashes(crypt($_POST['passwd'], $salt));
$now_date = date('Y/m/d H:i:s');

/* 커멘트 카운터 읽기/쓰기 */
ignore_user_abort(TRUE);
$DB->begin(TRUE);
$cmtcount =& $DB->iquery("SELECT reply+1 FROM hboard_db_article WHERE idx={$article_no} FOR UPDATE");

if ($cmtcount === FALSE) {
    $DB->close();
    error_exit("해당 게시물({$article_no})을 찾을 수 없습니다.<br />해당 게시물이 올바르게 등록되어 있는지 확인해 주세요.", TRUE);
}

$DB->query("UPDATE hboard_db_article SET reply=reply+1 WHERE idx={$article_no}");
$DB->commit(TRUE);

// 사용자 agent, IP 주소 구하기
$user_agent = addslashes($_SERVER['HTTP_USER_AGENT']);

$name     = addslashes($name);
$email    = addslashes($email);
$homepage = addslashes($homepage);
$icon     = addslashes($icon);

// 테이블에 처박기 (hboard_db_comment)
$DB->query("INSERT into hboard_db_comment VALUES ('{$cmtcount}', '{$article_no}',
        '{$name}', '{$email}', '{$homepage}', '{$icon}', '{$_SERVER['REMOTE_ADDR']}', '{$passwd}',
        '{$now_date}', '{$_POST['ne']}', 'f', '{$user_agent}')");
$DB->close();

$Layout = new Layout($admin_data);

$MessageBox = new MessageBox;
$MessageBox->setTypeList((int) $_POST['page'], $article_no);
$MessageBox->registerTitle('안내');
$MessageBox->registerMessage("{$article_no}번 게시물에 의견을 추가하였습니다.");

$Layout->printHeader();
$MessageBox->printOut();
$Layout->printFooter();

?>
