<?php
/* vim600: et ts=4 sts=4 sw=4 fdm=marker
 *
 * EtchiBBS UTF-8 - Gallery Web Board
 * Copyright (C) 2004 EtchiBoard Project
 * 
 * See LICENSE for license condition.
 *
 * http://etchibbs.kldp.net
 * $Id: admin.php,v 1.16 2004/03/23 16:41:36 lseeker Exp $
 */

require 'lib/common.php';
$DB->close();

if ($admin['login']) {
    setcookie('hboard_admin_login', ''); // 관리자 쿠키 지우기

    $redirect_to = empty($_GET['from']) ? 'list.php' : $_GET['from'];
    include 'lib/redirect.php';
    exit;
}

if (isset($_POST['password'])) {
    if (crypt($_POST['password'], $admin_data['passwd']) != $admin_data['passwd']) {
        include 'lib/layout.php';
        error_exit('비밀번호가 올바르지 않습니다!', TRUE);
    }

    setcookie('hboard_admin_login', $admin_data['passwd']);

    $redirect_to = empty($_POST['from']) ? 'list.php' : $_POST['from'];
    include 'lib/redirect.php';
    exit;
}

include 'lib/layout.php';
include 'lib/confirmbox.php';

$Layout = new Layout($admin_data);
$Layout->hideInclude();

$ConfirmBox = new ConfirmBox;
$ConfirmBox->registerAction('admin.php');
$ConfirmBox->registerMessage('관리자 비밀번호를 입력해주세요.');
$ConfirmBox->registerFrom(empty($_GET['from']) ? 'list.php' : $_GET['from']);

$Layout->printHeader();
$ConfirmBox->printOut();
$Layout->printFooter();

?>
