<?php
/* vim600: et ts=4 sts=4 sw=4 fdm=marker
 *
 * EtchiBBS UTF-8 - Gallery Web Board
 * Copyright (C) 2004 Yun-young Lee
 * 
 * See LICENSE for license condition.
 *
 * http://etchibbs.kldp.net
 * $Id: db.pgsql.php,v 1.28 2004/03/17 04:29:09 lseeker Exp $
 */

define('__DBMS__', 'PostgreSQL');

class DB {
    var $conn;

    function DB($host, $user, $pass, $name) {
        $connhost = empty($host) ? '' : "host='{$host}'";
        $connpass = empty($pass) ? '' : "password='{$pass}'";

        if ( ($this->conn = pg_connect("{$connhost} user='{$user}' {$connpass} dbname='{$name}'")) === FALSE) {
            trigger_error('Database Connect Error', E_USER_ERROR);
        }
    }

    function &query($command) {
        return pg_query($this->conn, $command);
    }

    function &iquery($command) {
        return pg_fetch_result(pg_query($this->conn, $command), 0, 0);
    }

    function close() {
        pg_close($this->conn);
    }

    function begin($force) {
        pg_query($this->conn, 'BEGIN');
    }

    function commit($force) {
        pg_query($this->conn, 'COMMIT');
    }

    function &getmaxidx() {
        return pg_fetch_result(pg_query($this->conn, 'SELECT last_value FROM hboard_db_article_idx_seq WHERE is_called=TRUE'), 0, 0);
    }

    function &getInsertIdx() {
        return pg_fetch_result(pg_query($this->conn, 'SELECT currval(\'hboard_db_article_idx_seq\')'), 0, 0);
    }
}

class DBResult {
    var $numrows;
    /* private var */
    var $fetched;
    var $result;
    var $rownum = 0;

    function DBResult(&$result) {
        if ($result === FALSE) trigger_error('Query Error', E_USER_ERROR);
        $this->numrows = pg_num_rows($result);
        $this->result =& $result;
    }

    function &fetch() {
        return pg_fetch_assoc($this->result);
    }

    function fetchNext() {
        if ($this->rownum++ < $this->numrows) {
            $this->fetched = pg_fetch_object($this->result);
            return TRUE;
        } else return FALSE;
    }

    function &numrows() {
        return pg_num_rows($this->result);
    }

    function free() {
        pg_free_result($this->result);
    }
}

?>
