<?php
/* vim600: et ts=4 sts=4 sw=4 fdm=marker
 *
 * EtchiBBS UTF-8 - Gallery Web Board
 * Copyright (C) 2004 EtchiBoard Project
 * 
 * See LICENSE for license condition.
 *
 * http://etchibbs.kldp.net
 * $Id: install_3.php,v 1.16.2.1 2004/02/24 11:13:53 lseeker Exp $
 */

header('Content-Type: text/html; charset=UTF-8');
session_start();
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
 <title>EtchiBBS Installation Wizard - Complete</title> 
 <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
 <link href="internal.css" rel="stylesheet" type="text/css">
</head>

<body>
<?php
if (!isset($_SESSION['install_step']) || $_SESSION['install_step'] != 3 ||
        strcmp($_SERVER['REQUEST_METHOD'], 'POST')) {
    echo <<<ERR_STEP
 <p>정상적인 방법으로 설치를 진행해주십시오. (Please follow installation step)<br />
 [ <a href="install.php">설치 처음으로 (Step 0)</a> ]</p>
</body>
</html>
ERR_STEP;
    exit;
}

if (file_exists('db/dbconn.php')) {
    echo " <p class=\"red\">이미 설치가 완료된 상태입니다. (Already installed)</p>
</body>\n</html>";
    exit;
}

/* DB 접속 */
require "lib/db.{$_SESSION['db_dbms']}.php";
$dbconn = &DB::connect($_SESSION['db_host'], $_SESSION['db_user'], $_SESSION['db_pass'], $_SESSION['db_name']);

/* 테이블 만들기 */
require "lib/db.{$_SESSION['db_dbms']}.sql";
DB::query($db_admin_t, $dbconn);
DB::query($db_article_t, $dbconn);
DB::query($db_comment_t, $dbconn);

/* 데이터베이스 설정파일 (dbconn.php) 쓰기 */
umask(0111);
$fp = fopen('db/dbconn.php', 'w');
fwrite($fp, "<?php\n");
fwrite($fp, $_SESSION['db_dbms'] . "\n");
fwrite($fp, $_SESSION['db_host'] . "\n");
fwrite($fp, $_SESSION['db_user'] . "\n");
fwrite($fp, $_SESSION['db_pass'] . "\n");
fwrite($fp, $_SESSION['db_name'] . "\n");
fwrite($fp, '?>');
fclose($fp);

mt_srand(microtime() * 1e6);
$salt = chr(mt_rand(0x21, 0x7E)) . chr(mt_rand(0x21, 0x7E)); /* DB 넣을때 오류 방지 */
$admin_passwd = addslashes(crypt($_POST['password'], $salt));
$now_date = date('Y/m/d H:i:s');
DB::query("INSERT INTO hboard_db_admin VALUES (
        '{$admin_passwd}', 'frog_yellow', 5, 512000, 'f', '', '',
        '<h1>Welcome to EtchiBBS!</h1>', '', '0', 'ko', '0', '', 't', 't')", $dbconn);

DB::close($dbconn);

// 디렉토리/파일 구조 만들기
umask(0); /* 디렉토리용 umask */
mkdir("db/ico");
mkdir("db/img");

// 빈 index.html 로 디렉토리 목록 차단
umask(0111); /* 파일용 umask */
copy('db/index.html', 'db/ico/index.html');
copy('db/index.html', 'db/img/index.html');

// db 크기파일 생성
$fp = fopen('db/img/dbinfo', 'w');
fwrite($fp, "[size]\n0");
fclose($fp);

/* 완료! */
?>
 <div id="install">
  <h1>Setup Completed</h1>
  <div id="insthead">
   <p>축하합니다, 게시판 설치가 완료되었습니다.<br />
   원활한 게시판 관리를 위해, 아래 정보를 참고하여 주세요.</p>
   <p>EtchiBBS를 선택하여 주셔서 감사합니다.<br />
   (Thanks for using EtchiBBS)</p>
  </div>
  <div>
   <p class="small">다음과 같은 DB 테이블이 데이터베이스에 생성되었습니다:<br />
   <ul>
    <li>hboard_db_article (게시물 데이터)</li>
    <li>hboard_db_comment (의견글 데이터)</li>
    <li>hboard_db_admin (관리자 설정 데이터)</li>
   </ul></p>
   <p class="small">아래 <em>설치 완료</em> 버튼을 누르시면 게시판으로 이동합니다.
   게시판으로 이동한 후, 주소 입력줄에 표시되는 주소를 그대로 홈 페이지에
   링크하시면 됩니다. (Click next link image)</p>
   <p class="center"><a href="list.php"><img src="img/install_complete.jpg"
    width="85" height="35" alt="Complete" title="Complete"></a></p>
  </div>
  <hr />
  <address>
   EtchiBBS Spiral-1 &copy; 2004 <a href="http://etchibbs.kldp.net">EtchiBoard Project</a>
  </address>
 </div>
 <div id="instimg">
  <img src="img/install_char.jpg" width="279" height="480" alt="Welcome to EtchiBBS~" />
 </div>
</body>
</html>
