<?php
/* vim600: et ts=4 sts=4 sw=4 fdm=marker
 *
 * EtchiBBS UTF-8 - Gallery Web Board
 * Copyright (C) 2004 EtchiBoard Project
 * 
 * See LICENSE for license condition.
 *
 * http://etchibbs.kldp.net
 * $Id: delete_icon.php,v 1.5 2004/01/21 11:29:13 lseeker Exp $
 */

require 'lib/admin.inc'; // 관리자 환경설정
DB::close($dbconn);

include "skin/{$admin_data['skin']}/style.php"; // 스킨
include 'lib/message.inc'; // 메시지 function

/* {{{ 오류 처리 */
if (!$admin['login']) {
    // 로그인 상태가 아니라면
    PrintMessage("<br>관리자 쿠키를 찾을 수 없습니다.", "error");
    exit;
} elseif (empty($_GET['file'])) {
    PrintMessage("삭제될 아이콘 파일명이 지정되지 않았습니다.", "error");
    exit;
} elseif (!file_exists('db/ico/' . $_GET['file'])) {
    PrintMessage("지정한 파일이 존재하지 않습니다.", "error");
    exit;
}
/* }}} */

unlink('db/ico/' . $_GET['file']) or die(PrintMessage("오류 발생: 파일을 삭제하지 못했습니다.<br>해당 파일의 권한을 확인해 주세요.", "error"));

$path = substr($_SERVER['PHP_SELF'], 0, strrpos($_SERVER['PHP_SELF'], '/'));

header('Location: http://' . $_SERVER['HTTP_HOST'] . $path . '/iconman.php');
header('Content-Type: text/html; charset=UTF-8');
?>
<!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
<html>
<head>
 <title>Redirection</title>
 <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
 <meta http-equiv="refresh" content="0; url=iconman.php">
</head>
<body>
 <p>
 이 화면이 보인다면, <a href="iconman.php">여기</a>를 클릭하십시오.<br />
 Please click <a href="iconman.php">here</a>.
 </p>
</body>
</html>
