<?php
/* vim600: et ts=4 sts=4 sw=4 fdm=marker
 *
 * EtchiBBS UTF-8 - Gallery Web Board
 * Copyright (C) 2004 EtchiBoard Project
 * 
 * See LICENSE for license condition.
 *
 * http://etchibbs.kldp.net
 * $Id: comment.php,v 1.24.2.2 2004/03/14 10:48:53 lseeker Exp $
 */

require 'lib/admin.inc'; // 관리자 환경설정

include 'lib/headfoot.inc'; // 페이지 상/하단
include 'lib/list.inc'; // 글 목록 function
include 'lib/message.inc'; // 메시지 function

PrintHeader();

if(!isset($_GET['article'])) {
    PrintMessage("<b>게시물 정보가 없습니다.</b><br>comment.php?article=[번호] 식으로 입력하세요.", "error");
    PrintFooter();
    exit;
}

$_GET['article'] = (int) $_GET['article'];

/* 없는 글일 경우 처리 */
if ( ($result = &DB::query("SELECT idx, name, email, home, ipaddr, date, cfile, subject, ment, deleted, reply, agent FROM hboard_db_article WHERE idx={$_GET['article']}", $dbconn)) === FALSE) {
    PrintMessage('<b>존재하지 않는 게시물입니다.</b>', 'error');
    PrintFooter();
    exit;
}

/* {{{ 쿠키값 받기 */
$cookie_name = isset($_COOKIE['etchibbs_name']) ? $_COOKIE['etchibbs_name'] : '';
$cookie_mail = isset($_COOKIE['etchibbs_mail']) ? $_COOKIE['etchibbs_mail'] : '';
$cookie_home = isset($_COOKIE['etchibbs_home']) ? $_COOKIE['etchibbs_home'] : '';
$cookie_icon = isset($_COOKIE['etchibbs_icon']) ? $_COOKIE['etchibbs_icon'] : '';
if (get_magic_quotes_gpc()) {
    $cookie_name = stripslashes($cookie_name);
    $cookie_mail = stripslashes($cookie_mail);
    $cookie_home = stripslashes($cookie_home);
    $cookie_icon = stripslashes($cookie_icon);
}
/* 쿠키 가지고 장난 치는것 방지 */
$cookie_icon = str_replace('/', '_', $cookie_icon);
/* }}} */
?>
<!-- {{{ 글쓰기 부분 -->
<form method="post" action="post_comment.php" onsubmit="return checkfrom_comment(this);">
<table align="center" cellpadding="1" cellspacing="0">
 <tr>
  <td colspan="2" style="background-image: url('skin/<?php echo $admin_data['skin']; ?>/title_bg.gif'); border: 2px outset; color: <?php echo $skin['sfont2_color']; ?>; font-weight: bold">
   <input type="hidden" name="article" value="<?php echo (int) $_GET['article']; ?>" />
   <input type="hidden" name="page" value="<?php echo (int) $_GET['page']; ?>" />
   <img src="skin/<?php echo $admin_data['skin']; ?>/write.gif" width="14" height="20" alt="write.gif" style="border: 0px; vertical-align: middle" />
   <?php echo $_GET['article']; ?>번 게시물에 의견 남기기
  </td>
 </tr>
 <tr>
  <td style="background-color: <?php echo $skin['image_table_bgcolor']; ?>; border-style: outset; border-width: 0px 1px 1px 1px; padding: 2px 4px">
   <table cellpadding="1" cellspacing="0">
    <tr>
     <td>Name</td>
     <td><input type="text" name="name" size="20" maxlength="30" value="<?php echo htmlspecialchars($cookie_name); ?>" /></td>
    </tr>
    <tr>
     <td>Mail</td>
     <td><input type="text" name="email" size="32" maxlength="100" value="<?php echo htmlspecialchars($cookie_mail); ?>" /></td>
    </tr>
    <tr>
     <td>URL(*)</td>
     <td><input type="text" name="homepage" size="32" maxlength="255" value="<?php echo strcmp($cookie_home, '') ? htmlspecialchars($cookie_home) : 'http://'; ?>" /></td>
    </tr>
    <tr>
     <td>Password</td>
     <td><input type="password" name="passwd" size="9" maxlength="30" /></td>
    </tr>
    <tr>
     <td>Icon</td>
     <td>
      <select name="icon" onchange="preview_icon(this.value, document.getElementById('iconp'));">
       <option value="none.jpg">(아이콘 없음)</option>
       <option value="none.jpg">--------------------</option>
<?php
// 아이콘 목록 긁어오기.. (..php.net에서 긁어옴. 히죽.)
if ($handle = opendir('db/ico/')) {
    while (false !== ($file = readdir($handle))) { 
        if ($file != '.' && $file != '..' && $file != 'none.jpg' && $file != 'index.html') { 
            $selected = strcmp($file, $cookie_icon) ? '' : ' selected="selected"';
            $file = htmlspecialchars($file); /* 아이콘 파일명 처리 */
            echo "<option value=\"{$file}\"{$selected}>{$file}</option>\n"; 
        }
    }
    closedir($handle);
}

?>
      </select>
     </td>
    </tr>
    <tr>
     <td colspan="2"><textarea name="ne" rows="6" cols="45"></textarea></td>
    </tr>
    <tr>
     <td colspan="2" align="center">
      <input name="submit_btn" type="submit" value="Submit" accesskey="s" />
      <input type="reset" value="Reset" />
      [<a href="list.php?page=<?php echo $_GET['page'] .'#' .$_GET['article']?>">되돌아가기</a>]
     </td>
    </tr>
   </table>
  </td>
  <td align="center" valign="middle" style="background-color: <?php echo $skin['image_table_bgcolor']; ?>; border-style: outset; border-width: 0px 1px 1px 1px; padding: 2px 4px; width: 268px">
   <img border="0" id="iconp" src="<?php
echo strcmp($cookie_icon, '') && file_exists('db/ico/'. $cookie_icon) ? 'db/ico/' . rawurlencode($cookie_icon) : "skin/{$admin_data['skin']}/none.jpg";
?>" alt="Icon Preview" />
  </td>
 </tr>
</table>
</form>
<!-- }}}-->

<?php
PrintArticle(DB::fetch($result), FALSE);
DB::close($dbconn);
PrintFooter();
?>
