<?php
/* vim600: et ts=4 sts=4 sw=4 fdm=marker
 *
 * EtchiBBS UTF-8 - Gallery Web Board
 * Copyright (C) 2004 EtchiBoard Project
 * 
 * See LICENSE for license condition.
 *
 * http://etchibbs.kldp.net
 * $Id: rename_icon_ok.php,v 1.10 2004/01/22 18:06:35 lseeker Exp $
 */

require 'lib/admin.inc'; // 관리자 환경설정
include "skin/{$admin_data['skin']}/style.php"; // 스킨
include 'lib/message.inc'; // 메시지 function

if(isset($_POST['rename_to'])) {
    // 파일명으로 부적절한 부분은 변경.. (1.0.5)
    $rename_to = get_magic_quotes_gpc() ? stripslashes($_POST['rename_to']) : $_POST['rename_to'];
    $rename_to = str_replace("\\", "_", $rename_to);
    $rename_to = str_replace("?", "_", $rename_to);
    $rename_to = str_replace("\"", "_", $rename_to);
    $rename_to = str_replace("/", "_", $rename_to);
    $rename_to = str_replace(":", "_", $rename_to);
    $rename_to = str_replace("*", "_", $rename_to);
    $rename_to = str_replace("<", "_", $rename_to);
    $rename_to = str_replace(">", "_", $rename_to);
    $rename_to = str_replace("|", "_", $rename_to);
    $rename_to = str_replace("#", "_", $rename_to); // ?
    $rename_to = str_replace("%", "_", $rename_to); // ??
}

/* {{{ 오류 처리 */
if (!$admin['login']) {
    // 로그인 상태가 아니라면
    PrintMessage("<br>관리자 쿠키를 찾을 수 없습니다.", "error");
    exit;
}

if (empty($_POST['file'])) {
    PrintMessage("변경할 아이콘의 이름을 전달받지 못하였습니다.", "error");
    exit;
}

if (empty($rename_to)) {
    PrintMessage("바꿀 아이콘의 이름을 전달받지 못하였습니다.", "error");
    exit;
}

if (file_exists("db/ico/" .$rename_to) || !strcmp($rename_to, 'none.jpg')) {
    PrintMessage("이미 같은 이름의 아이콘이 존재합니다.<br>중복을 막기 위해, 다른 이름으로 변경하여 주십시오.", "error");
    exit;
}
/* }}} */

$file = get_magic_quotes_gpc() ? stripslashes($_POST['file']) : $_POST['file'];

// 파일명 바꾸기..
rename("db/ico/{$file}", "db/ico/{$rename_to}") or die("<br>오류 발생: 파일의 이름을 바꿀 수 없습니다.<br>해당 파일의 권한이 올바르게 설정되었는지 확인해 주세요.<br><a href=\"javascript:history.back(1)\">[되돌아가기]</a>");;

// db의 파일명 업데이트..
$file      = addslashes($file);
$rename_to = addslashes($rename_to);
DB::query("UPDATE hboard_db_comment SET icon='{$rename_to}' WHERE icon='{$file}'", $dbconn) or DB::error('query ERROR!', '업데이트 실패.');
DB::close($dbconn);

$path = substr($_SERVER['PHP_SELF'], 0, strrpos($_SERVER['PHP_SELF'], '/'));

header('HTTP/1.1 303 See Other');
header('Location: http://' . $_SERVER['HTTP_HOST'] . $path . '/iconman.php');
header('Content-Type: text/html; charset=UTF-8');
?>
<!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
<html>
<head>
 <title>Redirection</title>
 <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
 <meta http-equiv="refresh" content="0; url=iconman.php">
</head>
<body>
 <p>
 이 화면이 보인다면, <a href="iconman.php">여기</a>를 클릭하십시오.<br />
 Please click <a href="iconman.php">here</a>.
 </p>
</body>
</html>
