<?php
/* vim600: et ts=4 sts=4 sw=4 fdm=marker
 *
 * EtchiBBS UTF-8 - Gallery Web Board
 * Copyright (C) 2004 EtchiBoard Project
 * 
 * See LICENSE for license condition.
 *
 * http://etchibbs.kldp.net
 * $Id: list.php,v 1.47.2.1 2004/02/24 12:17:33 lseeker Exp $
 */

require 'lib/admin.inc'; // 관리자 환경설정 include
include 'lib/headfoot.inc'; // 페이지 상/하단부 출력
include 'lib/list.inc'; // 글 목록 function
include 'lib/message.inc'; // 메시지 function

PrintHeader(); // 헤더 출력, ...

/* {{{ 쿠키값 받기 */
$cookie_name = isset($_COOKIE['etchibbs_name']) ? $_COOKIE['etchibbs_name'] : '';
$cookie_mail = isset($_COOKIE['etchibbs_mail']) ? $_COOKIE['etchibbs_mail'] : '';
$cookie_home = isset($_COOKIE['etchibbs_home']) ? $_COOKIE['etchibbs_home'] : '';
$cookie_icon = isset($_COOKIE['etchibbs_icon']) ? $_COOKIE['etchibbs_icon'] : '';
if (get_magic_quotes_gpc()) {
    $cookie_name = stripslashes($cookie_name);
    $cookie_mail = stripslashes($cookie_mail);
    $cookie_home = stripslashes($cookie_home);
    $cookie_icon = stripslashes($cookie_icon);
}
/* 쿠키 가지고 장난 치는것 방지 */
$cookie_icon = str_replace('/', '_', $cookie_icon);
/* }}} */

/* {{{ 전처리 */
# 현재 페이지 구하기 (넘겨진 변수 포함)
$page_this = isset($_SERVER["REQUEST_URI"]) ? $_SERVER['REQUEST_URI'] : $_SERVER['PHP_SELF'] . '?' . $_SERVER['QUERY_STRING'];

$page_this = rawurlencode(rawurlencode($page_this));

# 이미지 파일 총 용량 읽어오기
$file_open = file("db/img/dbinfo");
$db_size = trim($file_open[1]);

if($db_size <= 1048576) {
    $db_size = (float)($db_size/1024);
    $db_size = sprintf("%01.2f", $db_size) ." KB";
}
else if($db_size >= 1048577) {
    $db_size = (float)($db_size/1024/1024);
    $db_size = sprintf("%01.2f", $db_size) ." MB";
}

// 전체 게시물 갯수 구하기
$fileidx = &DB::getmaxidx($dbconn);

// 삭제된 게시물 구하기
/* FIXME DB에 대고 count(*) WHERE deleted='t'? ... 살려주세요. 부하가 너무 커요.
 * admin 테이블에서 조작할 수 있는 부분을 뒤적여야 할듯.
 * 가능성 있는건 현재 미지원인 article_max의 활용,
 * 혹은 비교적 범위가 작은 app를 활용. (*100? 2^31까지니 무리는 없을듯?)
 */
$deleted_fileidx = &DB::result(DB::query('SELECT count(*) FROM hboard_db_article WHERE deleted=\'t\'', $dbconn), 0, 0);

/* 페이지 확인 부분
 * 입력받지 않았으면, 자동으로 1로 설정하기 */
$page = empty($_REQUEST['page']) || !is_numeric($_REQUEST['page']) ? 1 : (int) $_REQUEST['page'];

# 읽어들인 인덱스를 이용해 페이지 넘기기
$startpage = intval($fileidx / $admin_data['app'] + 0.99);
if ($startpage < 1) $startpage = 1;

if ($page < 0) {
    PrintMessage("페이지가 지정된 범위를 초과했습니다.", "error");
    exit;
} elseif ($page > $startpage) {
    PrintMessage("페이지가 지정된 범위를 초과했습니다.", "error");
    exit;
}

$footart = $fileidx - $admin_data['app'] * $page; // 현재 페이지의 최하단 게시물
$headart = $footart + $admin_data['app']; // 현재 페이지의 최상단 게시물
/* }}} */
?>
<!-- {{{ JS -->
<script type="text/javascript">
<!--
var page = <?php echo $page; ?>;
var cookie_name = "<?php echo htmlspecialchars($cookie_name) ?>";
var cookie_mail = "<?php echo htmlspecialchars($cookie_mail) ?>";
var cookie_home = "<?php echo strcmp($cookie_home, '') ? htmlspecialchars($cookie_home) : 'http://'; ?>";
var icon_list = "<?php
if ($handle = opendir('db/ico/')) {
    while (false !== ($file = readdir($handle))) { 
        if ($file != '.' && $file != '..' && $file != 'none.jpg' && $file != 'index.html') { 
            $selected = strcmp($file, $cookie_icon) ? '' : ' selected=\\"selected\\"';
            $file = htmlspecialchars($file); /* 아이콘 파일명 처리 */
            echo "<option value=\\\"{$file}\\\"{$selected}>{$file}</option>"; 
        }
    }
    closedir($handle);
}
?>";
var icon_preview = '<?php echo strcmp($cookie_icon, '') && file_exists('db/ico/'. $cookie_icon) ? 'db/ico/' . rawurlencode($cookie_icon) : "skin/{$admin_data['skin']}/none.jpg"; ?>';
-->
</script>
<script type="text/javascript" src="commentform.js"></script>
<!-- }}} -->

<!-- {{{ 글쓰기 부분 -->
<form method="post" action="post_article.php" enctype="multipart/form-data" onsubmit="return checkform_article(this, 1);">
<table align="center" cellpadding="1" cellspacing="0">
 <tr>
  <td colspan="2" style="background-image: url('skin/<?php echo $admin_data['skin']; ?>/title_bg.gif'); border: 2px outset; color: <?php echo $skin['sfont2_color']; ?>; font-weight: bold">
   <img src="skin/<?php echo $admin_data['skin']; ?>/write.gif" width="14" height="20" alt="write.gif" style="border: 0px; vertical-align: middle" />
   새 게시물 작성..
  </td>
 </tr>
 <tr>
  <td style="background-color: <?php echo $skin['image_table_bgcolor']; ?>; border-style: outset; border-width: 0px 1px 1px 1px; padding: 2px 4px">
   <table cellpadding="1" cellspacing="0">
    <tr>
     <td>Name</td>
     <td><input type="text" name="name" size="20" maxlength="30" value="<?php echo htmlspecialchars($cookie_name); ?>" /></td>
    </tr>
    <tr>
     <td>Mail</td>
     <td><input type="text" name="email" size="32" maxlength="100" value="<?php echo htmlspecialchars($cookie_mail); ?>" /></td>
    </tr>
    <tr>
     <td>URL(*)</td>
     <td><input type="text" name="homepage" size="32" maxlength="255" value="<?php echo strcmp($cookie_home, '') ? htmlspecialchars($cookie_home) : 'http://'; ?>" /></td>
    </tr>
    <tr>
     <td>File</td>
     <td>
      <input type="file" name="picture" size="20" maxlength="255" onchange="preview_upload(this.value);" onblur="preview_upload(this.value);" />
      <span style="font-size: xx-small;">
<?php
if (!$admin_data['fileup_max']) {
    // 파일 업로드 제한이 있을 경우: KB, MB 단위로 변환해서 뿌리기
    if ($admin_data['fileup_max'] <= 1023999) $fileup_max = intval($admin_data['fileup_max'] / 1024 + 0.5) . 'KB';
    else $fileup_max = sprintf('%0.2f', $admin_data['fileup_max'] / 1024 / 1024) . 'MB';

    echo "({$fileup_max}<span style=\"color: red\">MAX</span>)";
} else {
    echo '<span style="color: red">(Unlimited)</font>';
}
?>
      </span>
     </td>
    </tr>
    <tr>
     <td>Password</td>
     <td><input type="password" name="passwd" size="9" maxlength="30" /></td>
    </tr>
    <tr>
     <td>Title</td>
     <td><input type="text" name="title" size="32" maxlength="255" /></td>
    </td>
    <tr>
     <td colspan="2"><textarea name="ne" rows="7" cols="45"></textarea></td>
    </tr>
    <tr>
     <td colspan="2" align="center">
      <input name="submit_btn" type="submit" value="Submit" accesskey="s" />
      <input type="reset" value="Reset" />
     </td>
    </tr>
   </table>
  </td>
  <td valign="middle" style="background-color: <?php echo $skin['image_table_bgcolor']; ?>; border-style: outset; border-width: 0px 1px 1px 1px; padding: 2px 4px">
   <div id="d_pic" style="width: 320px; height: 240px; overflow: hidden; text-align: center">
    <img id="pic" src="skin/<?php echo $admin_data['skin']?>/preview.jpg" alt="Preview" style="border: 0px" />
   </div>
  </td>
 </tr>
</table>
</form>
<!-- }}}-->

<!-- {{{ 게시물 등록 안내 -->
<div style="padding: 0px 5%">
<table width="100%" cellpadding="0" cellspacing="2" style="background-color: <?php echo $skin['image_table_bgcolor']; ?>; border: 1px outset <?php echo $skin['image_table_bgcolor']; ?>">
 <tr>
  <td style="line-height: 1.25em">
   <img src="skin/<?php echo $admin_data['skin']; ?>/info.jpg" width="32" height="32"
     alt="Info" style="border: 0px; float: left" />
   총 <?php echo $fileidx - $deleted_fileidx; ?>개의 게시물이 등록되어 있습니다. (삭제된 게시물 <?php echo $deleted_fileidx; ?>개)<br />
   현재 <?php echo $page; ?> 페이지 / 전체 <?php echo $startpage; ?> 페이지 (페이지당 <?php echo $admin_data['app']; ?>개씩 출력, 이미지 DB: <?php echo $db_size; ?>)
  </td>
  <td align="right">
   <a href="#search" title="검색"><img src="skin/<?php echo $admin_data['skin']?>/search.jpg"
     width="32" height="32" alt="검색" border="0" /></a>
<?php
/* {{{ 관리자 로그인 상태 처리부분 */ 
if ($admin['login']) {
?>
   <a href="javascript: Openwindow('hb_config', 'config.php?from=<?php echo $page_this; ?>', 30, 30, 700, 610, 0, 0, 0, 1, 1)" title="게시판 환경 설정"><img
     src="skin/<?php echo $admin_data['skin']?>/config.jpg" width="32" height="32"
     alt="게시판 환경 설정" border="0" /></a>
   <a href="javascript:Openwindow('hb_iconman', 'iconman.php', 60, 60, 610, 400, 0, 0, 0, 1, 1)" title="아이콘 관리자"><img
     src="skin/<?php echo $admin_data['skin']; ?>/addicon.jpg" width="32" height="32"
     alt="아이콘 관리자" border="0" /></a>
   <a href="admin_logout.php?from=<?php echo rawurldecode($page_this); ?>" title="관리자 로그아웃"><img
     src="skin/<?php echo $admin_data['skin']?>/logout.jpg" width="32" height="32"
     alt="관리자 로그아웃" border="0"></a>
<?php
} else {
?>
   <a href="javascript:Openwindow('hb_login', 'admin.php?from=<?php echo $page_this; ?>', 50, 50, 360, 140, 0, 0, 0, 0, 0);" title="관리자 로그인"><img
     src="skin/<?php echo $admin_data['skin'];?>/login.jpg" width="32" height="32"
     alt="관리자 로그인" border="0"></a>
<?php
}
/* }}} */ 
?>
  </td>
 </tr>
</table>
</div>
<!-- }}} -->
<br />
<?php
/* {{{ 출력부 */
if ($fileidx <= 0) {
    echo "<div style=\"text-align: center\"><font size=5>데이터가 없습니다!</font><br><font size=3>상단의 입력폼에서 게시물을 작성하여 주십시오.</font><br><br><hr color=\"{$skin['hr_color']}\" width=\"90%\"></div>\n";
    DB::close($dbconn);
} else {
    /* PrintArticle에서 내부 루프문 제거 */
    $result = &DB::query("SELECT idx, name, email, home, ipaddr, date, cfile, subject, ment, deleted, reply, agent FROM hboard_db_article WHERE idx>{$footart} AND idx<={$headart} ORDER BY idx DESC", $dbconn);

    while ($data = &DB::fetch($result)) PrintArticle($data, TRUE);

    DB::free($result);
    DB::close($dbconn);
}

echo "<div style=\"text-align: center\">현재 <b><font color=blue>" .$page ."</font></b> 페이지 <font color=green>/</font> 전체 <b><font color=red>" .$startpage ."</font></b> 페이지</div>\n<div style=\"text-align: center\">";

if($page>1) {
    echo "<a href=\"list.php?page=1\" title=\"첫 페이지\">|</a>&nbsp;<a href=\"list.php?page=" .($page-1) ."\" title=\"이전 페이지\">◁</a>&nbsp;&nbsp;";
} else {
    echo "<font color=\"{$skin['image_table_bgcolor']}\"><a title=\"첫 페이지\">|</a>&nbsp;<a title=\"이전 페이지\">◁</a></font>&nbsp;&nbsp;";
} // 이전 페이지랑 첫 페이지 버튼

// 미친 for문 부분 시작
for($pagecnt=($page-4);; $pagecnt++) {
    if($pagecnt<=0) { }
    else if($pagecnt>=$page) {
        break; }
        else {
            echo "<a href=\"list.php?page=" .$pagecnt ."\">[" .$pagecnt ."]</a>&nbsp;"; }
        }

        echo "[<b>" .$page ."</b>]&nbsp;";

        for($pagecnt=($page+1);; $pagecnt++) {

            if($page<=4) { // 첫 페이지라면?
            if($pagecnt>$startpage) { break; } // 끝에 닿으면 정지
            else if($pagecnt>=(($page+10)-$page)) { break; }
            else { echo "<a href=\"list.php?page=" .$pagecnt ."\">[" .$pagecnt ."]</a>&nbsp;"; }
        }

        else { // 아님 말구 ㅡㅡ..
        if($pagecnt>$startpage) { break; } // 끝에 닿으면 정지
        else if($pagecnt>=($page+5)) { break; } // +5 도 정지
        else { echo "<a href=\"list.php?page=" .$pagecnt ."\">[" .$pagecnt ."]</a>&nbsp;"; }
    }
}

// 미친 for문 부분 끝

if(($footart+1)<=1) {
    echo "&nbsp;<font color=\"{$skin['image_table_bgcolor']}\"><a title=\"다음 페이지\">▷</a>&nbsp;<a title=\"마지막 페이지\">|</a></font>";
}

else {
    echo "&nbsp;<a href=\"list.php?page=" .($page+1) ."\" title=\"다음 페이지\">▷</a>&nbsp;<a href=\"list.php?page=" .$startpage ."\" title=\"마지막 페이지\">|</a>";
} // 다음 페이지랑 마지막 페이지 버튼..ㅡㅡ

/* }}} */
?>
</div>
<br />
<!-- {{{ 검색폼 -->
<form action="search.php" onsubmit="return checkform_search(this);">
<div id="search">
<table align="center" cellpadding="2" cellspacing="2" style="background-color: <?php echo $skin['image_table_bgcolor']; ?>; padding: 0px 24px">
 <tr>
  <td align="right"><img src="skin/<?php echo $admin_data['skin']; ?>/search.jpg" width="32" height="32" alt="검색" border="0" /></td>
  <td>
   <select name="search_type" size="1">
    <option value="name">작성자</option>
    <option value="subject">글 제목</option>
    <option value="ment">글 내용</option>
    <option value="cfile">파일 이름</option>
   </select>
   <input type="text" name="search_word" maxlength="50" size="15" />
   <input type="submit" value="검색" />
  </td>
 </tr>
</table>
</div>
</form>
<!-- }}} -->
<?php
PrintFooter();
?>
