<?php
/* vim600: et ts=4 sts=4 sw=4 fdm=marker
 *
 * EtchiBBS UTF-8 - Gallery Web Board
 * Copyright (C) 2004 EtchiBoard Project
 * 
 * See LICENSE for license condition.
 *
 * http://etchibbs.kldp.net
 * $Id: post_modify.php,v 1.13 2004/01/23 02:18:09 lseeker Exp $
 */

require 'lib/admin.inc'; // 관리자 환경설정
include 'lib/headfoot.inc'; // 상/하단부
include 'lib/message.inc'; // 메시지 function


// 공백 처리: ^^+
$name     = &remove_space($_POST['name']);
$homepage = &remove_space($_POST['homepage']);
$email    = &remove_space($_POST['email']);

$article_no = (int) $_POST['article_no'];

if (get_magic_quotes_gpc()) {
    $name     = stripslashes($name);
    $email    = stripslashes($email);
    $homepage = stripslashes($homepage);
} else {
    $_POST['title'] = addslashes($_POST['title']);
    $_POST['ne']    = addslashes($_POST['ne']);
}

/* {{{ 오류 처리 */
/* 그림 크기가 관리자가 제한한 크기보다 클 경우 (0은 무제한 의미이므로 생략..) */
if(!empty($_FILES['picture']['tmp_name']) && $admin_data['fileup_max'] != "0" && $_FILES['picture']['size'] > $admin_data['fileup_max']) {
    $fileup_max_in_kb = (int)(($admin_data['fileup_max']/1024+0.5));
    PrintMessage("<b>파일의 크기가 너무 큽니다!</b><br>※ 파일의 크기는 최대 {$fileup_max_in_kb}KB로 제한됩니다.", "error");
    exit;
}

/* 이름, 타이틀, 내용, 비밀번호 등이 등록되지 않았을 때.. */
if($name == "" || empty($_POST['ne']) || empty($article_no)) {
    PrintMessage("<b>데이터가 모두 전송되지 않았습니다.</b><br>폼에 필요한 데이터를 모두 채워주세요.", "error");
    exit;
}
/* }}} */

/* {{{ 쿠키 설정 */
if (!$admin['login']) {
    $c_time = time() + 2592000;
    setcookie('etchibbs_name', $name,     $c_time);
    setcookie('etchibbs_mail', $email,    $c_time);
    setcookie('etchibbs_home', $homepage, $c_time);
}
/* }}} */

PrintHeader();

/* 정상이라면.. */
if($homepage == "http://") {
    $homepage = ""; // http://일 경우 홈페이지 비우기
}

$article = DB::fetch(DB::query("SELECT passwd, date, deleted, cfile, md5 FROM hboard_db_article
        WHERE idx='{$article_no}'", $dbconn));

/* {{{ 비밀번호나 관리자 쿠키 확인 */
if(isset($_POST['passwd']) && crypt($_POST['passwd'], $article['passwd']) != $article['passwd']) {
    PrintMessage("비밀번호가 올바르지 않습니다.", "error");
    PrintFooter();
    exit;
} elseif (!$admin['login'] && !strcmp($_POST['passwd'], '')) {
    PrintMessage("<br>비밀번호가 비어 있습니다.", "error");
    PrintFooter();
    exit;
} elseif ($article['deleted'] == "t") {
    PrintMessage("게시물이 이미 삭제된 상태입니다.", "error");
    PrintFooter();
    exit;
}
/* }}} */

// 모두 정상이라면.
$article['date'] = $article['date'] ."*"; // 수정시에는 날짜에 *이 하나씩 붙는 0.x대의 표기법..ㅡㅡ

if(!empty($_FILES['picture']['tmp_name'])) {
    /* 그림파일 처리부분 (업로드가 있을 경우만) */
    $picture_md5 = md5_file($_FILES['picture']['tmp_name']);

    // 파일 중복 체크기능: v1.0.1 ~
    if ($admin_data['backdrum'] == 't') {

        $result = &DB::query("SELECT idx, cfile FROM hboard_db_article WHERE md5='{$picture_md5}' AND deleted='f'", $dbconn);

        if (DB::numrows($result) != 0) {
            // 글이 중뷁이면
            $backdrum = &DB::fetch($result);

            PrintMessage("<b>{$backdrum['idx']}번 글에서 같은 파일이 발견되었습니다.</b><br>\n<a href=\"search.php?search_word={$backdrum['cfile']}&amp;search_type=cfile#{$backdrum['idx']}\" target=\"_blank\">[여기를 클릭하시면 {$backdrum['idx']}번 글을 확인합니다. (검색모드)]</a><br>", "error"); // 중복시 에러발생

            PrintFooter();
            unlink($_FILES['picture']['tmp_name']);
            exit; // 죽어랏 -_-
        }
    }

    // 이미지 db 정보에 용량 변경하기
    $file_open = file("db/img/dbinfo");
    $db_size = trim($file_open[1]);

    $cfile_size = filesize("db/img/" . $article['cfile']);
    $db_size = (($db_size-$cfile_size) + $_FILES['picture']['size']);
    $file_open = fopen("db/img/dbinfo", "w");
    flock($file_open, LOCK_EX);
    fwrite($file_open, "[size]\n${db_size}");
    fclose($file_open);

    // 업로드한 파일 처리(cfile삭제/링크/원본삭제)부분..
    umask(0111);
    move_uploaded_file($_FILES['picture']['tmp_name'], "db/img/" . $article['cfile']);
} else {
    $picture_md5 = $article['md5'];
}

$name     = addslashes($name);
$email    = addslashes($email);
$homepage = addslashes($homepage);

DB::query("UPDATE hboard_db_article SET
        name='{$name}', email='{$email}', home='{$homepage}', date='{$article['date']}',
        subject='{$_POST['title']}', ment='{$_POST['ne']}', md5='{$picture_md5}'
        WHERE idx='{$article_no}'", $dbconn)
        or die(PrintMessage("데이터베이스 오류 발생!", "error")); 

// 메시지 출력
$page = $_POST['page'];
PrintMessage("{$article_no}번 게시물의 수정작업을 완료했습니다.", "notice");

DB::close($dbconn);

PrintFooter();
?>
