<?php
/* vim600: et ts=4 sts=4 sw=4 fdm=marker
 *
 * EtchiBBS UTF-8 - Gallery Web Board
 * Copyright (C) 2004 EtchiBoard Project
 * 
 * See LICENSE for license condition.
 *
 * http://etchibbs.kldp.net
 * $Id: list.inc,v 1.17.2.6 2004/02/11 23:03:15 lseeker Exp $
 */

function AutoLink($ment) {
    // 주소 자동링크 function
    /* FIXME UTF-8 코드에 맞게 처리해야;; */
    /* URL reference: RFC 1738 */
    $ment = eregi_replace("([[:alnum:]]+)://([a-z0-9\200-\377\\_\./#~@:?=%&\-]+)", "<a href=\"\\1://\\2\" target=\"_blank\">\\1://\\2</a>", $ment);
    return $ment;
}

function UnHtml($ment) {
    // html 코드 분리 function (잘 돌아가려나?)
    /*
    $ment = str_replace("<", "&lt;", $ment);
    $ment = str_replace(">", "&gt;", $ment);
    */

    return htmlspecialchars($ment);
}

function PrintArticle($article_start, $article_end, $print_button) {
    // 글 목록 출력 function
    /* {{{ global,s */
    global $admin_data; // 관리자 설정
    global $admin;
    global $skin; // 스킨 처박질
    global $page; // 페이지 처박질
    global $search_word, $search_type; // 검색어 처박질 (검색모드일때만..)
    global $db; /* DB CONNECT INFO */
    /* }}} */

    $dbconn = &DB::connect($db['host'], $db['user'], $db['pass'], $db['name']);

    // 먼저 처리를 잘못해줘서 -1 같은게 넘어오는 경우가 있음 -.-
    if ($article_end <= 0) $article_end = 1;

    for ($i = $article_start; $i >= $article_end; $i--) {

        $result = &DB::query("SELECT * FROM hboard_db_article WHERE idx='{$i}'", $dbconn);

        $article = &DB::fetch($result);

        // html 태그 없애기 (..)
        if ($admin_data['html_tag'] == "f") $article['ment'] = UnHtml($article['ment']); // 멘트 내용은 설정이 있는 상태에만..
        $article['writer'] = UnHtml($article['name']);
        $article['mailz'] = UnHtml($article['email']);
        $article['homepy'] = UnHtml($article['home']);
        $article['title'] = UnHtml($article['subject']);

        $article['ment'] = str_replace("\n", "<br>", $article['ment']);

        // 검색모드일 경우 검색어 강조처리 (...삽질)
        if($search_word && $search_type) { // 검색어랑 타잎이 있을 경우..
            if($search_type == 'name') $article['writer'] = str_replace($search_word, "<font color=\"{$skin['sfont1_color']}\"><b>{$search_word}</b></font>", $article['writer']);
            elseif($search_type == 'subject') $article['title'] = str_replace($search_word, "<font color=\"{$skin['sfont1_color']}\"><b>{$search_word}</b></font>", $article['title']);
            elseif($search_type == 'ment') $article['ment'] = str_replace($search_word, "<font color=\"{$skin['sfont1_color']}\"><b>{$search_word}</b></font>", $article['ment']);
        }

        // 메인 출력부 시작

        /** 게시물이 삭제되었을 경우, 타이틀 바꾸기 **/
        if ($article['deleted'] == "t") $article['title'] = "삭제된 게시물입니다.";

        /** 게시물 제목이 없을 경우 자동으로 [제목없음] 처리 **/
        if (!strcmp($article['title'], '')) $article['title'] = "(제목 없음)";

        /** 계속 진행.. **/
        echo "<a name=\"${i}\"></a>\n" . 
        "<table border=1 cellspacing=0 cellpadding=5 width=\"90%\"><tr>\n" .
        "<td width=\"100%\" height=\"10\" background=\"skin/{$admin_data['skin']}/title_bg.gif\" align=\"left\">\n" .
        "<font color=\"{$skin['sfont2_color']}\">No. {$i} - <b>{$article['title']}</b></font> " .
        "<font color=\"{$skin['sfont1_color']}\">[by ";

        if($article['mailz'] != '') echo "<a href=\"mailto:{$article['mailz']}.NOSPAM\"><font color=\"{$skin['sfont1_color']}\">{$article['writer']}</font></a>";
        else echo $article['writer'];

        if($article['homepy']!="") echo "&nbsp;<a href=\"{$article['homepy']}\" target=\"_blank\" title=\"홈 페이지\"><img src=\"skin/{$admin_data['skin']}/home.gif\" border=0 alt=\"홈 페이지\"></a>";

        if(isset($_COOKIE['hboard_admin_login']) && $_COOKIE['hboard_admin_login'] == $admin_data['passwd']) echo "&nbsp;(from {$article['ipaddr']})";

        if($article['deleted'] == "t") {
            /* {{{ 게시물이 삭제된 상태일 경우 */
            echo "&nbsp;-&nbsp;{$article['date']}]\n</td>\n"
            ."</tr><tr><td width=\"100%\" height=\"107\" style=\"padding-top:5; padding-left:5;\" align=\"left\" bgcolor=\"{$skin['image_table_bgcolor']}\">\n"
            ."<p align=\"center\"><img src=\"skin/{$admin_data['skin']}/deleted.jpg\" border=\"0\" alt=\"deleted.jpg\"></p>\n"
            ."<p align=\"center\"><b>이 게시물은 작성자 혹은 관리자에 의해 삭제되었습니다.<br>\n"
            ."</b></p>\n";
            /* }}} */
        } else {
            /* {{{ 게시물이 삭제된 상태가 아닐 경우 */

            // 그림 가로/세로 크기 긁어오기
            $image = @getimagesize("db/img/${article[cfile]}");
            if($admin_data['width_max'] != "0" && $image[0] > $admin_data['width_max']) {
                // 그림크기가 제한되고 그 크기가 지정된 가로크기보다 클 경우 (?)
                $imagewidth = $admin_data['width_max'];
                $imageheight = (int) (($image[1]/$image[0]) * $admin_data['width_max']);
                $resized = true;
            }

            else {
                // 말짱하다면 -3-
                $imagewidth = $image[0];
                $imageheight = $image[1];
                $resized = false;
            }

            // URL 자동링크
            if ($admin_data['autolink'] == 't') $article['ment'] = AutoLink($article['ment']);

            // 파일 크기 구하기..
            $cfilesize['b'] = @filesize("db/img/" .$article['cfile']);
            $cfilesize['kb'] = sprintf('%.2f', $cfilesize['b'] / 1024);

            echo "&nbsp;-&nbsp;{$article['date']}]</font>\n"
            ."</td></tr><tr>\n"
            ."<td width=\"100%\" height=\"100\" style=\"padding-top:5; padding-left:5; text-align: left\" bgcolor=\"{$skin['image_table_bgcolor']}\">\n";

            if($resized) {
                // ... alt만 쓰자니 모질라가 울고-_- title만 쓰자니 익스가 울고 -_-;;;;;
                echo "<a href=\"db/img/{$article['cfile']}\" target=\"_blank\" title=\"{$article['cfile']}: {$imagewidth}x{$imageheight}(으)로 크기 조정됨 (원래크기 {$image[0]}x{$image[1]}) - 클릭하시면 새 창으로 원래 크기의 그림을 표시합니다.\"><img src=\"db/img/{$article['cfile']}\" width=\"{$imagewidth}\" height=\"{$imageheight}\" border=\"0\" alt=\"{$article['cfile']}: {$imagewidth}x{$imageheight}(으)로 크기 조정됨 (원래크기 {$image[0]}x{$image[1]}) - 클릭하시면 새 창으로 원래 크기의 그림을 표시합니다.\" style=\"margin-bottom: 0.4em\" /></a>\n";
            } else {
                echo "<a href=\"db/img/{$article['cfile']}\" target=\"_blank\" title=\"{$article['cfile']} ({$image[0]}x{$image[1]}) - 클릭하시면 새 창으로 그림을 표시합니다.\"><img src=\"db/img/{$article['cfile']}\" width=\"{$imagewidth}\" height=\"{$imageheight}\" border=\"0\" alt=\"{$article['cfile']} ({$image[0]}x{$image[1]}) - 클릭하시면 새 창으로 그림을 표시합니다.\" style=\"margin-bottom: 0.4em\" /></a>\n";
            }

            echo "<table border=0 width=\"98%\" bgcolor=\"{$skin['text_table_bgcolor']}\">\n"
            ."<tr><td width=\"90%\" height=\"20\">\n"
            ."<br>{$article['ment']}<br><br>\n"
            ."</td></tr>\n</table><small>* <b>User-agent:</b> {$article['agent']}<br><b>&nbsp;&nbsp;&nbsp;File Size:</b> {$cfilesize['b']} Byte(s) ({$cfilesize['kb']} KB) <a href=\"downadd.php?file={$article['cfile']}\"><b>[DOWNLOAD]</b></a></small><br>\n";

            /* }}} */
        }

        if ($article['reply']) {
            $result = &DB::query("SELECT idx, name, email, home, icon, ipaddr, date, ment, agent FROM hboard_db_comment WHERE article={$i} AND deleted<>'t' ORDER BY article, idx", $dbconn);
            /* {{{ 커멘트 출력부분 */
            while ( ($comment = &DB::fetch($result)) !== FALSE) {
                // html 태그 없애기 (..)
                if($admin_data['html_tag'] == 'f') $comment['ment'] = UnHtml($comment['ment']); // 멘트 내용은 설정이 있는 상태에만..
                $comment['mail_addr'] = UnHtml($comment['email']);
                $comment['homepage'] = UnHtml($comment['home']);
                $comment['name'] = UnHtml($comment['name']);

                // 개행부분 <br>로 바꿔주기 =_=
                $comment['ment'] = str_replace("\n", "\n<br>", $comment['ment']);

                // URL 자동링크
                if($admin_data['autolink'] == "t") $comment['ment'] = AutoLink($comment['ment']); 

                echo "<table border=0 cellpadding=0 cellspacing=0 width=\"90%\" align=CENTER bgcolor=\"{$skin['image_table_bgcolor']}\">\n"
                ."<tr><td width=\"100%\" height=\"10\">"
                ."<HR noshade size=1 width=\"100%\" color=\"{$skin['hr_color']}\">"
                ."No. {$comment['idx']} [by ";

                if ($comment['mail_addr'] != '') echo "<a href=\"mailto:{$comment['mail_addr']}.NOSPAM\" title=\"Agent: {$comment['agent']}\n(클릭하시면 작성자에게 메일을 전송합니다)\">{$comment['name']}</a>";
                else echo "<a title=\"Agent: {$comment['agent']} (클릭하시면 작성자에게 메일을 전송합니다)\">{$comment['name']}</a>";

                if($comment['homepage']!="") echo "&nbsp;<a href=\"{$comment['homepage']}\" target=\"_blank\" title=\"홈 페이지\"><img src=\"skin/{$admin_data['skin']}/home.gif\" border=0 alt=\"홈 페이지\"></a>";

                if ($admin['login']) echo "&nbsp;(from {$comment['ipaddr']})";

                echo "]&nbsp;{$comment['date']}&nbsp;&nbsp;<a href=\"del_comment.php?confirm=true&amp;article={$i}&amp;num={$comment['idx']}&amp;page={$page}\" title=\"의견글 삭제\"><img src=\"skin/{$admin_data['skin']}/del_cmt.gif\" border=0 alt=\"의견글 삭제\"></a>\n<span style=\"font-size:4pt;\"><br><br></span>";
                echo "<table cellpadding=\"0\" cellspacing=\"0\">\n<tr>\n<td width=\"1\" height=\"1\" valign=\"top\" align=\"center\">";

                if ($comment['icon'] == "none.jpg" || !file_exists("db/ico/{$comment['icon']}")) {
                    echo "<img src=\"skin/{$admin_data['skin']}/none.jpg\" alt=\"No Icon\" border=\"0\">\n";
                } else {
                    echo '<img src="db/ico/' . rawurlencode($comment['icon']) . "\" alt=\"{$comment['icon']}\" border=\"0\">\n";
                }

                echo "</td>\n<td width=\"100%\" height=\"1\" valign=\"top\" style=\"padding-left: 5px;\">\n" .
                "{$comment['ment']}\n</td></tr></table>\n</td></tr></table>";
            }
            /* }}} */
        }

        // 하단부 명령버튼 (Modify, Del, ...) 출력 (있을시만)
        if($print_button == true && $article['deleted'] != "t") {
            echo <<<BUTTONS
<br />
<a href="modify.php?article_no={$i}&amp;page={$page}" title="글 수정"><img
 src="skin/{$admin_data['skin']}/modify.gif" border="0" alt="글 수정" /></a>
<a href="del_article.php?article={$i}&amp;confirm=true&amp;page={$page}" title="글 삭제"><img
 src="skin/{$admin_data['skin']}/delete.gif" border="0" alt="글 삭제" /></a>
<a href="comment.php?article={$i}&amp;page={$page}" title="의견 달기"><img
 src="skin/{$admin_data['skin']}/reply.gif" border="0" alt="의견 달기"></a>
BUTTONS;
        }

        echo "</td></tr></table>\n<br />";
    }

    DB::close($dbconn);
}
?>
