<?php
/* vim600: et ts=4 sts=4 sw=4 fdm=marker
 *
 * EtchiBBS UTF-8 - Gallery Web Board
 * Copyright (C) 2004 EtchiBoard Project
 * 
 * See LICENSE for license condition.
 *
 * http://etchibbs.kldp.net
 * $Id: install_1.php,v 1.9.2.2 2004/01/25 06:08:27 lseeker Exp $
 */

header('Content-Type: text/html; charset=UTF-8');
session_start();
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
 <title>EtchiBBS Installation Wizard - Step 1</title>
 <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
 <link href="internal.css" rel="stylesheet" type="text/css">
 <script type="text/javascript">
<!--
function checkform(form) {
    if (form.user.value == '') {
        alert('사용자명을 입력하세요. (Fill username)');
        form.user.focus();
        return false;
    }

    if (form.dbname.value == '') {
        alert('데이터베이스명을 입력하세요. (Fill database)');
        form.dbname.focus();
        return false;
    }

    return true;
}
//-->
 </script>
</head>

<body>
<?php
if (!isset($_SESSION['install_step']) || $_SESSION['install_step'] < 1) {
    echo <<<ERR_STEP
 <p>정상적인 방법으로 설치를 진행해주십시오. (Please follow installation step)<br />
 [ <a href="install.php">설치 처음으로 (Step 0)</a> ]</p>
</body>
</html>
ERR_STEP;
    exit;
}

if (file_exists('db/dbconn.php')) {
    echo "<p class=\"red\">이미 설치가 완료된 상태입니다. (Already installed)</p>
</body>\n</html>";
    exit;
}

$_SESSION['install_step'] = 2; /* 문제가 없으므로 설치 단계 증가 */
?>
 <div id="install">
  <h1>Welcome/Database Configuration</h1>
  <div id="insthead">
   <p>EtchiBBS 설치 마법사에 오신 것을 환영합니다!<br />
   이 마법사는 여러분이 홈 페이지에 쉽고 빠르게 EtchiBBS를 설치하실 수 있도록
   도와주는 역할을 합니다.</p>
   <p>아래에 관리자에서 안내받거나, 혹은 여러분이 설정하신 데이터베이스 연결에
   관한 정보를 기입해 주십시오.<br />(Fill the database connect information)</p>
  </div>
  <form method="post" action="install_2.php" onsubmit="return checkform(this);">
   <div>
    <table id="instable" width="100%" cellpadding="2" cellspacing="1">
     <tr>
      <td>데이터베이스 종류 (DBMS)</td>
      <td>
       <select name="dbms">
<?php
/* DB 종류 선택지 */
$db_count = 0;
if (extension_loaded('mysql'))  echo "<option value=\"mysql\">MySQL</option>";
if (extension_loaded('pgsql'))  echo "<option value=\"pgsql\">PostgreSQL</option>";
?>
       </select>
      </td>
     </tr>
     <tr>
      <td>데이터베이스 서버 (hostname)</td>
      <td><input type="text" name="host" value="localhost" /></td>
     </tr>
     <tr>
      <td>사용자 ID (username)</td>
      <td><input type="text" name="user" /></td>
     </tr>
     <tr>
      <td>비밀번호 (password)</td>
      <td><input type="password" name="pass" /></td>
     </tr>
     <tr>
      <td>데이터베이스 이름 (database)</td>
      <td><input type="text" name="dbname" /></td>
     </tr>
     <tr>
      <td colspan="2">
       <button type="submit"><img src="img/install_ok.jpg" width="85" height="35"
        alt="OK" title="OK" /></button>
       <button type="reset"><img src="img/install_reset.jpg" width="85" height="35"
        alt="Reset" title="Reset" /></button>
      </td>
     </tr>
    </table>
   </div>
  </form>
  <hr />
  <address>
   EtchiBBS Spiral-0 &copy; 2004 <a href="http://etchibbs.kldp.net">EtchiBoard Project</a>
  </address>
 </div>
 <div id="instimg">
  <img src="img/install_char.jpg" width="279" height="480" alt="Welcome to EtchiBBS~" />
 </div>
</body>
</html>
