/*  -
   Copyright (C) 2006 Weongyo Jeong (weongyo@gmail.com)

This file is part of ROVM.

ROVM is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation; either version 2, or (at your option) any later
version.

ROVM is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with GCC; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA
02111-1307, USA.  */

#ifndef _ROVM_LISTEN_H
#define _ROVM_LISTEN_H

typedef struct rc_listen_rec rc_listen_rec;
typedef rc_status_t (*accept_function) (void **csd, rc_listen_rec *lr, rc_pool_t *ptrans);

/**
   ROVM  listeners record.
   
   These are used in the Multi-Processing Modules
   to setup all of the sockets for the MPM to listen to and accept on.
*/
struct rc_listen_rec 
{
  /** The next listener in the list */
  rc_listen_rec *next;
  /** The actual socket  */
  rc_socket_t *sd;
  /** The sockaddr the socket should bind to  */
  rc_sockaddr_t *bind_addr;
  /** The accept function for this socket  */
  accept_function accept_func;
  /** Is this socket currently active  */
  int active;
  /** The default protocol for this listening socket.  */
  const char *protocol;
};

/**
   ROVM  listening port    ʱȭѴ.

   @param r     ROVM ü
   @param p      ޸ pool
*/
extern int init_rovm_listen (struct rovm *, rc_pool_t *);
extern char *alloc_listener (struct rovm *r, char *addr, rc_port_t port, const char* proto);

#endif
