/*  -
   Copyright (C) 2006 Weongyo Jeong (weongyo@gmail.com)

This file is part of ROVM.

ROVM is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation; either version 2, or (at your option) any later
version.

ROVM is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with GCC; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA
02111-1307, USA.  */

#ifndef _ROVM_CONNECTION_H
#define _ROVM_CONNECTION_H

#define CONN_TS(NODE)                   ((NODE)->ts)
#define CONN_LOCAL_ADDR(NODE)             ((NODE)->local_addr)

/**
   @brief Structure to store things which are per connection
 */
struct conn_rec 
{
  int aborted;

  /** Pool associated with this connection */
  rc_pool_t *pool;

  /**   socket.  */
  rc_socket_t *sock;

  /**  ῡ  thread   ROVM ü .  */
  thread_starter *ts;

  /* Information about the connection itself */
  /** local address */
  rc_sockaddr_t *local_addr;
  /** remote address */
  rc_sockaddr_t *remote_addr;

  /** Client's IP address */
  char *remote_ip;
  /** Client's DNS name, if known.  NULL if DNS hasn't been checked,
   *  "" if it has and no address was found.  N.B. Only access this though
   * get_remote_host() */
  char *remote_host;

  /** server IP address */
  char *local_ip;
  /** used for ap_get_server_name when UseCanonicalName is set to DNS
   *  (ignores setting of HostnameLookups) */
  char *local_host;

  /** Notes on *this* connection: send note from one module to
   *  another. must remain valid for all requests on this conn */
  rc_table_t *notes;

  SSLConnRec *sslconn;
  void *filter_ctx;
};

typedef struct conn_rec conn_rec;

extern void rc_close_connection (conn_rec *);
extern conn_rec * rc_create_connection (thread_starter *, rc_pool_t *, rc_socket_t *);
extern int rc_process_connection (conn_rec *);

#endif
