#include "types.h"
#include "mpool.h"
#include "tktree.h"
#include "clstree.h"
#include "sha1.h"
#include "listen.h"
#include "ssl_conf.h"
#include "rovm.h"

#include "thread.h"
#include "thread_mutex.h"
#include "thread_cond.h"

#include "mpm_worker_fdqueue.h"
#include "mpm_worker_pod.h"
#include "mpm_worker.h"

#include "connection.h"
#include "request.h"
#include "proc_rc.h"

#include "log.h"
#include "common.h"
#include "ticket.h"
#include "utils.h"

#include "file.h"
#include "gc.h"
#include "el.h"

/**
   Class Tree  key  value  (PATH, CLS)  node  մϴ.

   @param r     ROVM ü
   @param path  Class  
   @param cls   ε Class 
   @return       ϵǾ , RC_SUCCESS  ȯϰ Ǹ,
                ׷  , -1  ȯϰ ˴ϴ.
*/
rc_status_t
rc_register_class (r, path, cls)
     struct rovm *r;
     char *path;
     RvClass *cls;
{
  if (!clstree_lookup (ROVM_CLSTREE (r), path))
    {
      char *dupstr = rc_strdup (path);

      /* Insert ̹Ƿ ̿  serialize ( )  ʿϴ.

         ???  tktree  clstree   mutex  Ͽ locking 
             ϰ ִµ, ̵   ٸ mutex  ϵ ִ
             ͵    .    ġ Ҵ 
             ʴ´.  */
      rc_thread_mutex_lock (ROVM_MUTEX (r));

      if (clstree_insert (ROVM_CLSTREE (r), dupstr, (void *) cls))
        {
          rc_thread_mutex_unlock (ROVM_MUTEX (r));
          return -1;
        }

      rc_thread_mutex_unlock (ROVM_MUTEX (r));
    }

  return RC_SUCCESS;
}

/**
   PATH  ϴ class   εϿ Class Tree  մϴ.

   @param r     ROVM ü
   @param path  ã Class 
   @return       εϿ , ش Class ͸ ׷  ,
                NULL_CLASS  ȯմϴ.
*/
RvClass *
rc_load_class (r, path)
     struct rovm *r;
     char *path;
{
  rc_status_t rv;
  RvClass *cls;

  if (!r || !path)
    return NULL_CLASS;

  cls = rc_load_classfile (r, path);
  if (!cls)
    return NULL_CLASS;

  rv = rc_register_class (r, path, cls);
  if (rv != RC_SUCCESS)
    return NULL_CLASS;

  return cls;
}

/**
   ü R  ϴ Class Tree  PATH  شϴ Class  ã, ׿
   ´ RvClass ü ȯմϴ.

    Class Tree  ش Class  ã Ͽٸ, ش path   
   loading  ϰ ˴ϴ.

   @param r     ROVM ü
   @param path  ã Class 
   @return      ش Class  ã εǾٸ ش Ŭ ͸ ȯմϴ.
                ׷  , NULL_CLASS  ȯմϴ.
 */
RvClass *
rc_lookup_class (r, path)
     struct rovm *r;
     char *path;
{
  RvClass *cls;

  if (!r || !path)
    return NULL_CLASS;

  cls = (RvClass *) clstree_lookup (ROVM_CLSTREE (r), path);
  if (cls)
    return cls;

  return rc_load_class (r, path);
}

/**
   IPTYPE  HOSTNAME, PORT, PATH  ̿Ͽ ׿  class  
   ´.   HOSTNAME   ӽ IP (Ȥ hostname)  ,
    ش class  εϿ ׿   ȯѴ.

   @param r             request_rec ü
   @param iptype        IPv4  IPv6  Ų.  IPv6   
                         ʴ´.
   @param hostname      Host ̸
   @param port          Host Ʈ ȣ
   @param path          ãϴ class .
   @return               class    , NULL_CLASS 
                        ȯϰ,  ٸ host  û  , 
                        REMOTE_CLASS  ȯѴ.  ׷   load 
                        class  Ͱ ȯѴ.
*/
RvClass *
rc_getclassbyhost (r, iptype, hostname, port, path)
     request_rec *r;
     int iptype;
     char *hostname, *path;
     unsigned short port;
{
  rc_status_t rv;
  rc_sockaddr_t *sa;

  if (strcmp (hostname, "localhost"))
    {
      rv = rv_sockaddr_info_get (&sa, hostname, RC_INET, 
                                 port ? port : DEFAULT_ROVM_LISTENING_PORT,
                                 0, REQUEST_POOL (r));
      if (rv != RC_SUCCESS)
        return NULL_CLASS;

      if (!rc_sockaddr_equal (CONN_LOCAL_ADDR (REQUEST_CONN (r)), sa))
        return REMOTE_CLASS;
    }

  return rc_lookup_class (REQUEST_ROVM (r), path);
}

/**
   Class CLS  ޽ ̸ Ÿ NAME ̰, TYPE  ޽带 ã
   ׿  ͸ ȯѴ.
 */
RvMethod *
rc_findmethod (cls, name, type)
     RvClass *cls;
     char *name, *type;
{
  RvMethod *m;

  if (!cls || !name || !type)
    return NULL_METHOD;

  m = CLASS_METHOD (cls);

  while (m)
    {
      if (!strcmp (name, METHOD_NAME (m))
          && !strcmp (type, MTYPE_STR (METHOD_TYPE (m))))
        return m;

      m = METHOD_NEXT (m);
    }

  return NULL_METHOD;
}

/**
   SELF Object   ʿ ҵ鿡   ̷ ˴ϴ.   
   , request_rec * ü    Դϴ.

   @param self  SELF ü
   @param r     request_rec ü
 */
int
selfobj_beforecall (self, r)
     RvObject *self;
     request_rec *r;
{
  OBJECT_REQUEST (self) = r;

  return 0;
}

/**
   Ŭ Method  ȣѴ.

   @return        ߻Ͽ , -1  ׷ ʴٸ 0  ȯѴ.
 */
int
rc_callmethod (r, tk, name, type, argc, argv)
     request_rec *r;
     struct ticket *tk;
     char *name, *type;
     u2 argc, *argv;
{
  RvObject *obj;

  obj = GET_STACK_VALUE (OBJREF, &(TICKET_SP (tk)[-(argc - 1)]));

  if (OBJECT_TYPE (obj) == LOCAL_OBJECT)
    {
      RvClass *cls = OBJECTL_CLASS (obj);
      RvMethod *m;

      m = rc_findmethod (cls, name, type);
      if (!m)
        {
          if (r)
            request_add_error (r, ERRLOG_ERR, ERRLOG_MARK,
                               "Can't find such method.");
          return -1;
        }

      /* ޽带 ȣϱ , ʿ ticket    ֵ Ѵ.  */
      if (ticket_beforecall (tk, m, argc, argv))
        return -1;

      /*  ȣϰ ϴ method  native  , ش Լ ȣ 
         ֵ   Ѵ.  */
      if (METHOD_FLAG (m) & ACCESS_NATIVE)
        {
          if (!(STACK_TYPE (TICKET_LOCAL (tk)) == STACK_TYPE_OBJREF
                || STACK_TYPE (TICKET_LOCAL (tk)) == STACK_TYPE_STRINGREF
                || STACK_TYPE (TICKET_LOCAL (tk)) == STACK_TYPE_ARRAYREF))
            {
              request_add_error (r, ERRLOG_ERR, ERRLOG_MARK,
                                 "The first argument of native method should be a ObjectRef.");
              return -1;
            }

          if (selfobj_beforecall (GET_STACK_VALUE (OBJREF, TICKET_LOCAL (tk)), r))
            return -1;

          if (m->native (GET_STACK_VALUE (OBJREF, TICKET_LOCAL (tk)), TICKET_LOCAL (tk) + 1, TICKET_RET (tk)))
            return -1;
        }
      else
        {
          /* Ϲ method ȣ .  */
          if (rovmcore_main (r, tk, METHOD_OP (m), METHOD_OPLEN (m)))
            return -1;
        }
    }
  else if (OBJECT_TYPE (obj) == REMOTE_OBJECT)
    {
      request_add_error (r, ERRLOG_ERR, ERRLOG_MARK,
                         "Calling remote method is under construction.");
      return -1;
    }
  else
    {
      request_add_error (r, ERRLOG_ERR, ERRLOG_MARK,
                         "Invalid Object Type.");
      return -1;
    }

  return 0;
}

/**
   RvObject ü Ӱ Ҵϸ, Local  Remote  κи
   մϴ.

   @return  ͸  · RvObject ü ͸ ȯմϴ.
 */
RvObject *
init_eobject (r, tk)
     struct rovm *r;
     struct ticket *tk;
{
  RvObject *o;

  o = (RvObject *) gc_tcalloc (r, tk, sizeof (RvObject), GC_OBJECTREF);
  if (!o)
    return NULL_OBJECT;

  OBJECT_TICKET (o) = tk;
  OBJECT_CTIME (o) = rc_time_now ();

  return o;
}

/**
   Ŭ C   ObjectRef  Ͽ ȯմϴ.

   @param c     ObjectRef   Ŭ 
   @return       ObjectRef
 */
RvObject *
NewRvObject (r, tk, c)
     struct rovm *r;
     struct ticket *tk;
     RvClass *c;
{
  RvObject *o;

  if (!r || !tk || !c)
    return NULL_OBJECT;

  o = init_eobject (r, tk);
  if (!o)
    return NULL_OBJECT;

  OBJECT_TYPE (o) = LOCAL_OBJECT;
  OBJECTL_CLASS (o) = c;

  /* Field   ObjectRef   ȮѴ.  */
  if (CLASS_FIELD_COUNT (c) > 0)
    OBJECTL_FIELD (o) = (RvValue *) gc_calloc (r, tk, CLASS_FIELD_COUNT (c) * sizeof (RvValue));

  return o;
}

/**
   ݿ ϴ Ŭ ؼ ObjectRef  Ͽ ȯմϴ.

   @param r             Request ü
   @param iptype        IPv4  IPv6  մϴ.
   @param hostname       Host Name
   @param port           Host  Ʈ ȣ
   @param path          Ŭ 
   @return              ݿ  ObjectRef    
                         ObjectRef
 */
RvObject *
NewRemoteRvObject (r, iptype, hostname, port, path)
     request_rec *r;
     int iptype;
     char *hostname, *path;
     unsigned short port;
{
  return NULL_OBJECT;
}

extern int rovm_stack_size[MAX_STACK_TYPE];

/**
   Array  Ȯմϴ.  OBJ  ݵ ArrayRef  մϴ.
 */
int
rc_expandarray (RvObject *obj, int num)
{
  int curlen, maxlen;
  RvValue *val;

  if (!obj || num < 0)
    return -1;
  if (!OBJECT_IS_ARRAY (obj))
    return -1;
  if (!num)
    return 0;

  val = rc_getfieldvalue (obj, "len", "I");
  if (!val)
    return -1;
  curlen = GET_STACK_VALUE (INT, val);

  val = rc_getfieldvalue (obj, "maxlen", "I");
  if (!val)
    return -1;
  maxlen = GET_STACK_VALUE (INT, val);

  val = rc_getfieldvalue (obj, "value", "[");
  if (!val)
    return -1;

  if (curlen >= maxlen)
    {
      void *newbuf;
      maxlen += num;
      newbuf = (void *) gc_calloc (OBJECTL_ROVM (obj), OBJECT_TICKET (obj), sizeof (RvValue) * maxlen);
      if (!newbuf)
        return -1;
      memcpy (newbuf, GET_STACK_VALUE (ADDR, val), sizeof (RvValue) * curlen);
      GET_STACK_VALUE (ADDR, val) = newbuf;

      if (RvSetField (obj, "maxlen", "I", maxlen))
        return -1;
    }

  return 0;
}

/**
   ArrayRef  迭  entry  Ͽ ȯմϴ.

   @param obj    ArrayRef
   @param entry  迭 ׸ ۵Ǵ 
   @param arrlen 迭 ׸ .
   @return       0, н -1
 */
int
rc_getinfo_array (RvObject *obj, RvValue **entry, int *arrlen)
{
  RvValue *val;

  if (!obj || (obj && !OBJECT_IS_ARRAY (obj)))
    return -1;

  val = rc_getfieldvalue (obj, "len", "I");
  if (!val)
    return -1;
  *arrlen = GET_STACK_VALUE (INT, val);

  val = rc_getfieldvalue (obj, "value", "[");
  if (!val)
    return -1;
  *entry = (RvValue *) GET_STACK_VALUE (ADDR, val);

  return 0;
}

/**
   StringRef  ڿ ۿ ̸ Ͽ STR  LEN   Ͽ
   ȯմϴ.

   @param obj   StringRef
   @param str    ڿ 
   @param len    ڿ 
   @return       0, н -1
 */
int
rc_getinfo_string (RvObject *obj, char **str, int *len)
{
  RvValue *val;

  if (!obj || (obj && !OBJECT_IS_STRING (obj)))
    return -1;

  val = rc_getfieldvalue (obj, "len", "I");
  if (!val)
    return -1;
  *len = GET_STACK_VALUE (INT, val);
  
  val = rc_getfieldvalue (obj, "value", "[");
  if (!val)
    return -1;
  
  *str = RvValue2Str (obj, val);

  return 0;
}

/**
   Ÿ FTYPE   ʵ FNAME  SELF  ã ش  Ǵ
    RvValue ü ȯϰ ˴ϴ.

   @param self  SELF ü.
   @param fname ʵ ̸
   @param ftype ʵ Ÿ
   @return      SELF  ϴ ʵ带   ȯմϴ.
 */
RvValue *
rc_getfieldvalue (RvObject *self, const char *fname, const char *ftype)
{
  RvField *f;

  if (!self || !fname || !ftype)
    return NULL;

  f = rc_find_efield (OBJECTL_CLASS (self), (u1 *) fname, (u1 *) ftype);
  if (!f)
    return NULL;

  return OBJECTL_FIELD_IDX (self, FIELD_INDEX (f));
}

/**
   ArrayRef  Ӱ Ͽ ׿  ͸ ȯѴ.  GC ޸𸮸
   ϴ  Ư¡̴.

   @param nlem  Ҵ ҵ ũ.
 */
RvObject *
NewRvArray (r, tk, nelm)
     struct rovm *r;
     struct ticket *tk;
     int nelm;
{
  RvObject *obj;
  RvValue *val;

  /* ArrayRef  Ҵմϴ.  */
  obj = NewRvObject (r, tk, rc_lookup_class (r, "/core/array"));
  if (!obj)
    return NULL_OBJECT;
  OBJECT_IS_ARRAY (obj) = TRUE;

  /*  field ̸ value  ,  Ư   Ѵ.  */
  val = rc_getfieldvalue (obj, "value", "[");
  if (!val)
    return NULL_OBJECT;
  STACK_TYPE (val) = STACK_TYPE_ARRAYREF;
  STACK_IS_ARRAYVALUE (val) = TRUE;
  GET_STACK_VALUE (ADDR, val) = (void *) gc_calloc (r, tk, sizeof (RvValue) * nelm);
  if (!GET_STACK_VALUE (ADDR, val))
    return NULL_OBJECT;

  if (RvSetField (obj, "len", "I", nelm))
    return NULL_OBJECT;

  if (RvSetField (obj, "maxlen", "I", nelm))
    return NULL_OBJECT;

  return obj;
}

/**
   ̰ LEN  ڿ STR  ObjectRef  ȯϿ ȯѴ.  STR  NULL
     ʽϴ.

   @param r     Request ü
   @param tk    Ticket ü
   @param str   ڿ 
   @param len   ڿ 
 */
RvObject *
NewRvStringObject (r, tk, str, len)
     struct rovm *r;
     struct ticket *tk;
     const char *str;
     size_t len;
{
  RvObject *obj;
  RvValue *val;

  /* String ObjectRef  Ҵմϴ.  */
  obj = NewRvObject (r, tk, rc_lookup_class (r, "/core/str"));
  if (!obj)
    return NULL_OBJECT;
  OBJECT_IS_STRING (obj) = TRUE;

  /* ڿ value  Ưϰ  Ѵ.  */
  val = rc_getfieldvalue (obj, "value", "[");
  if (!val)
    return NULL_OBJECT;
  STACK_TYPE (val) = STACK_TYPE_ARRAYREF;
  STACK_IS_STRINGVALUE (val) = TRUE;
  GET_STACK_VALUE (ADDR, val) = (void *) gc_calloc (r, tk, len);
  if (!GET_STACK_VALUE (ADDR, val))
    return NULL_OBJECT;
  if (str)
    memcpy (GET_STACK_VALUE (ADDR, val), str, len);

  if (RvSetField (obj, "len", "I", len))
    return NULL_OBJECT;

  return obj;
}
