/*  -
   Copyright (C) 2006 Weongyo Jeong (weongyo@gmail.com)

This file is part of ROVM.

ROVM is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation; either version 2, or (at your option) any later
version.

ROVM is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with GCC; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA
02111-1307, USA.  */

#ifndef _ROVM_TICKET_H
#define _ROVM_TICKET_H

#include "core.h"
#include "class.h"

/**
   ⺻   slot  .
 */
#define DEFAULT_STACK_SLOT              256

enum ticket_status
  {
    /*  Ticket  ޽ ŵϴ.  */
    TICKET_IS_RELAX,
    /*  Ticket   ϰ ִٴ Դϴ.  */
    TICKET_IS_WORKING,
    /*  Ticket  GC Slot   ֱ ,  ̻  Ƽ ȿ
       ʴٴ Դϴ.  */
    TICKET_IS_ON_GCSLOT
  };

#define TICKET_STATUS(NODE)             ((NODE)->status)
#define TICKET_TIME_INIT(NODE)		((NODE)->tinit)
#define TICKET_TIME_UPDATE(NODE)        ((NODE)->tupdate)
#define TICKET_SP(NODE)                 ((NODE)->sp)
#define TICKET_MAX_SP(NODE)             ((NODE)->maxsp)
#define TICKET_MIN_SP(NODE)             ((NODE)->minsp)
#define TICKET_LOCAL(NODE)              ((NODE)->local)
#define TICKET_MAXLOCAL(NODE)           ((NODE)->maxlocal)
#define TICKET_RET(NODE)                (&((NODE)->ret))
#define TICKET_DELAYED_SLOT(NODE)       ((NODE)->delayed_slot)
#define TICKET_DELAYED_SLOT_IDX(NODE, IDX)  ((NODE)->delayed_slot[(IDX)])
#define TICKET_DELAYED_SLOT_MAX(NODE)   ((NODE)->delayed_slot_max)
#define TICKET_DELAYED_SLOT_NELM(NODE)  ((NODE)->delayed_slot_nelm)
#define DEFAULT_DELAYED_SLOT            64
#define TICKET_STACK(NODE)              ((NODE)->stack)
#define TICKET_STACK_IDX(NODE, IDX)     ((NODE)->stack[(IDX)])
#define TICKET_MAX_STACK_SLOT(NODE)     ((NODE)->max_stack_slot)

/**
   ڷ  `REQ' ɾ ޵ǰ, ׿  մ   
   ȿ ڷ Ǹ Ǿ , Ǵ üν, ڰ   
   µ  , ̸ ̿Ͽ  û     
   ֵ Ѵ.

    ü  ߿ üν  request     µ
    ִ.

   (ü μ  Ͻø ˴ϴ.)
 */
struct ticket
{
  /**
      Ticket  ¿   Ÿ Դϴ.    Ticket
     ü  GC  ̷  Ǵ ν  ticket   
      ش Ticket ü  GC  ̷ ʵ Ǿ ֽϴ.  
  */
  enum ticket_status status;

  /**
     Ticket   ð  ֱ  ð  ֽϴ.  ̰
     ߿  ð  ticket  , ڵ Ҹ ؼ ˴ϴ.
  */
  rc_time_t tinit;
  rc_time_t tupdate;

  /** Stack Pointer.  x86  stack pointer ̶ ϴ.  */
  rovm_stack_t *sp;
  /** Stack Pointer  ִ/ּҷ Ͽ  ̴.  ̰ Stack 
      Ѿ  ˻ϱ  ƾ̴.  */
  rovm_stack_t *maxsp;
  rovm_stack_t *minsp;

  /** Local Variable Pointer.  ̰ ڹ  ӽſ   
      Ʒ  `stack' 迭 ϳ slot  Ű ȴ.  ̿  ڼ
       `Stack  Local  '  ϱ ٶ.

      @note  `Stack  Local  '   ʴ´.  */
  rovm_stack_t *local;
  /** Local  ִ slot      , iload  
      opcode  ߸ local     ħϴ Ǵϴµ,
      ȴ.  */
  rovm_stack_t *maxlocal;

  /** Ticket  ϴ  slot .   迭Դϴ. */
  rovm_stack_t *stack;
  /**   `stack'  Ҵ  slot  .  */
  int max_stack_slot;

  /**  ticket operation  óǸ鼭 ȯϰ Ǵ return  Ǵ
      ġ.  */
  rovm_stack_t ret;

  /** GC ޸𸮰 Ҵǰ Ticket Slot    ش ޸ Ͱ
      ӹ ̴.  */
  void **delayed_slot;
  int delayed_slot_max;
  int delayed_slot_nelm;
};

extern struct ticket *create_ticket (struct rovm *);
extern char *create_ticketid (request_rec *);
extern int gen_unique_ticketid (char *);
extern int register_ticketid (request_rec *, char *);
extern struct ticket *lookup_ticket (request_rec *, char *);
extern int ticket_pre_config (struct ticket *);
extern int ticket_post_config (struct ticket *);
extern int ticket_beforecall (struct ticket *, RvMethod *, u2, u2 *);
extern void destroy_ticket (struct ticket *);
extern int destroy_tickets (struct rovm *, char *);
extern void ticket_clear_delay_slot (struct ticket *);
extern int ticket_collect (struct rovm *);

extern int safe_tktree_walking (struct rovm *, tktree_t *, tktree_foreach_fn, void *);

#endif
