/*  -
   Copyright (C) 2006 Weongyo Jeong (weongyo@gmail.com)

This file is part of ROVM.

ROVM is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation; either version 2, or (at your option) any later
version.

ROVM is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with GCC; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA
02111-1307, USA.  */

#ifndef _ROVM_MPM_WORKER_H
#define _ROVM_MPM_WORKER_H

typedef struct thread_starter thread_starter;

/*
 * Interval, in microseconds, between scoreboard maintenance.
 */
#ifndef SCOREBOARD_MAINTENANCE_INTERVAL
#define SCOREBOARD_MAINTENANCE_INTERVAL 1000000
#endif

/**
   Special Apache error codes. These are basically used
   in http_main.c so we can keep track of various errors.
*/

/** a normal exit */
#define RCEXIT_OK       0x0
/** A fatal error arising during the server's init sequence */
#define RCEXIT_INIT     0x2
/**  The child died during its init sequence */
#define RCEXIT_CHILDINIT    0x3
/**
 *   The child exited due to a resource shortage.
 *   The parent should limit the rate of forking until
 *   the situation is resolved.
 */
#define RCEXIT_CHILDSICK        0x7
/**
 *     A fatal error, resulting in the whole server aborting.
 *     If a child exits with this error, the parent process
 *     considers this a server-wide fatal error and aborts.
 */
#define RCEXIT_CHILDFATAL   0xf

/* The structure used to pass unique initialization info to each thread */
typedef struct 
{
  int pid;
  int tid;
  int sd;

  thread_starter *ts;
} proc_info;

/**
   Structure used to pass information to the thread responsible for
   creating the rest of the threads.
*/
struct thread_starter
{
  rc_thread_t **threads;
  rc_thread_t *listener;
  rc_os_thread_t *listener_os_thread;
  int child_num_arg;
  rc_threadattr_t *threadattr;

  /** Child Thread   memory pool.  */
  rc_pool_t *p;

  /** Thread   μ pid .  */
  pid_t my_pid;

  fd_queue_t *worker_queue;
  fd_queue_info_t *worker_queue_info;

  int listener_may_exit;
  int workers_may_exit;
  int resource_shortage;
  int terminate_mode;

  rc_socket_t **worker_sockets;

  struct rovm *arg;
};

/**
   ROVM  ,  unix  ϰ ֱ , ̸  ڵ带 static ϰ
   ھ  ̴.   ũδ Ӱ  ʿ䰡 ִ.
 */
#define MPM_ACCEPT_FUNC         unixd_accept
extern rc_status_t unixd_accept (void **, rc_listen_rec *, rc_pool_t *);

extern int mpm_run (struct rovm *);
extern int mpm_pre_config (struct rovm *);

#endif
